/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.util.functions.Function;

public class SnocList<T> {
    public final SnocList<T> init;
    public final T last;
    private final int len;

    public SnocList(SnocList<T> snoc, T e) {
        if (snoc == null) {
            this.init = null;
            this.last = e;
            this.len = 1;
            return;
        }
        this.init = snoc;
        this.last = e;
        this.len = snoc.len + 1;
    }

    public SnocList(T e) {
        this.init = null;
        this.last = e;
        this.len = 1;
    }

    public SnocList<T> init() {
        return this.init;
    }

    public T last() {
        return this.last;
    }

    public int size() {
        return this.len;
    }

    public String toString(String delimiter, Function<? super T, String> f) {
        String str = "]";
        SnocList<T> cell = this;
        for (int i = this.len - 1; i >= 1; --i) {
            str = delimiter + (String)f.apply(cell.last) + str;
            cell = cell.init;
        }
        str = "[" + (String)f.apply(cell.last) + str;
        return str;
    }

    public String toString(String delimiter) {
        String str = "]";
        SnocList<T> cell = this;
        for (int i = this.len - 1; i >= 1; --i) {
            str = delimiter + cell.last.toString() + str;
            cell = cell.init;
        }
        str = "[" + cell.last.toString() + str;
        return str;
    }

    public String toString() {
        return this.toString(", ");
    }

    public void copyTo(T[] array) {
        SnocList<T> cell = this;
        for (int i = this.len - 1; i >= 0; --i) {
            array[i] = cell.last;
            cell = cell.init;
        }
    }
}

