/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.labeledgraph;

import com.ibm.wala.automaton.util.labeledgraph.EdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.MutableEdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.SimpleMutableEdgeDecorator;
import com.ibm.wala.util.collections.Pair;
import java.util.HashSet;
import java.util.Set;

public class DelegatingMutableEdgeDecorator<T, U>
implements MutableEdgeDecorator<T, U> {
    protected final EdgeDecorator<T, U> delegated;
    protected final MutableEdgeDecorator<T, U> addedLabels;
    private final Set<Pair<T, T>> removedEdges = new HashSet<Pair<T, T>>();

    protected MutableEdgeDecorator<T, U> createAddedLabelRecorder() {
        return new SimpleMutableEdgeDecorator();
    }

    public DelegatingMutableEdgeDecorator(EdgeDecorator<T, U> delegated) {
        this.delegated = delegated;
        this.addedLabels = this.createAddedLabelRecorder();
    }

    @Override
    public U getLabel(T n1, T n2) {
        Object l = this.addedLabels.getLabel(n1, n2);
        if (l == null && this.delegated != null) {
            if (this.isRemovedFromDelegated(n1, n2)) {
                return null;
            }
            return this.delegated.getLabel(n1, n2);
        }
        return l;
    }

    @Override
    public void addLabel(T src, U label, T dest) {
        this.addedLabels.addLabel(src, label, dest);
    }

    protected boolean isRemovedFromDelegated(T src, T dest) {
        return this.removedEdges.contains(Pair.make(src, dest));
    }

    @Override
    public void removeLabel(T src, T dest) {
        Object l = this.addedLabels.getLabel(src, dest);
        if (l != null) {
            this.addedLabels.removeLabel(src, dest);
            return;
        }
        l = this.delegated.getLabel(src, dest);
        if (l != null) {
            this.removedEdges.add(Pair.make(src, dest));
        }
    }
}

