/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.callgraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.ContextInsensitiveSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContextPair;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContextPair;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;

public class SelectiveOneLevelContextSelector
implements ContextSelector {
    public static final IPolicy ALWAYS_ONE_LEVEL_CALLER_SITE = new AlwaysOneLevelCallerSitePolicy();
    public static final IPolicy ALWAYS_ONE_LEVEL_SITE = new AlwaysOneLevelSitePolicy();
    public static final IPolicy ALWAYS_ONE_LEVEL_CALLER = new AlwaysOneLevelCallerPolicy();
    public static final IPolicy ALWAYS_CONTEXT_INSENSITIVE = new AlwaysContextInsensitivePolicy();
    public static final IPolicy ONE_LEVEL_CALLER_SITE = new ContextInsensitiveForPrimordialsPolicy(ALWAYS_ONE_LEVEL_CALLER_SITE);
    public static final IPolicy ONE_LEVEL_SITE = new ContextInsensitiveForPrimordialsPolicy(ALWAYS_ONE_LEVEL_SITE);
    public static final IPolicy ONE_LEVEL_CALLER = new ContextInsensitiveForPrimordialsPolicy(ALWAYS_ONE_LEVEL_CALLER);
    private final ContextSelector baseSelector;
    private final IPolicy policy;

    public SelectiveOneLevelContextSelector(ContextSelector baseSelector, IPolicy policy) {
        this.baseSelector = baseSelector;
        this.policy = policy;
    }

    public SelectiveOneLevelContextSelector(ContextSelector baseSelector) {
        this(baseSelector, ONE_LEVEL_SITE);
    }

    public SelectiveOneLevelContextSelector() {
        this((ContextSelector)new ContextInsensitiveSelector());
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        Context baseContext = this.baseSelector.getCalleeTarget(caller, site, callee, receiver);
        if ((caller = this.policy.callerPolicy(caller, callee)) == null) {
            if ((site = this.policy.sitePolicy(caller, site, callee)) == null) {
                return baseContext;
            }
            return new SiteContext(site);
        }
        if (caller.getMethod().equals(callee)) {
            return baseContext;
        }
        if (baseContext.equals(Everywhere.EVERYWHERE)) {
            if ((site = this.policy.sitePolicy(caller, site, callee)) == null) {
                return new CallerContext(caller);
            }
            return new CallerSiteContext(caller, site);
        }
        if (site == null) {
            return new CallerContextPair(caller, baseContext);
        }
        return new CallerSiteContextPair(caller, site, baseContext);
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        return EmptyIntSet.instance;
    }

    public static class RecCallerSiteContext
    extends CallerSiteContext {
        public RecCallerSiteContext(CGNode caller, CallSiteReference callSite) {
            super(caller, callSite);
        }

        public boolean equals(Object obj) {
            if (((Object)((Object)this)).getClass().equals(obj.getClass())) {
                RecCallerSiteContext other = (RecCallerSiteContext)((Object)obj);
                return this.getCaller().getMethod().equals(other.getCaller().getMethod()) && this.getCallSite().equals((Object)other.getCallSite());
            }
            return false;
        }

        public int hashCode() {
            return this.getCaller().getMethod().hashCode() * 19 + this.getCallSite().hashCode();
        }

        public String toString() {
            return this.getCaller().getMethod().toString() + "@" + this.getCallSite().toString();
        }
    }

    public static class RecCallerContext
    extends CallerContext {
        public RecCallerContext(CGNode caller) {
            super(caller);
        }

        public boolean equals(Object obj) {
            if (((Object)((Object)this)).getClass().equals(obj.getClass())) {
                RecCallerContext other = (RecCallerContext)((Object)obj);
                return this.getCaller().getMethod().equals(other.getCaller().getMethod());
            }
            return false;
        }

        public int hashCode() {
            return this.getCaller().getMethod().hashCode();
        }

        public String toString() {
            return this.getCaller().getMethod().toString();
        }
    }

    public static class SiteContext
    implements Context {
        private CallSiteReference callSite;

        public SiteContext(CallSiteReference callSite) {
            this.callSite = callSite;
        }

        public ContextItem get(ContextKey name) {
            if (name.equals(ContextKey.CALLSITE)) {
                return this.callSite;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this.getClass().equals(obj.getClass())) {
                SiteContext other = (SiteContext)obj;
                return this.callSite.equals((Object)other.callSite);
            }
            return false;
        }

        public int hashCode() {
            return this.callSite.hashCode() * 19;
        }

        public String toString() {
            return "@" + this.callSite.toString();
        }
    }

    public static class MethodContext
    implements Context {
        private IMethod m;

        public MethodContext(IMethod m) {
            this.m = m;
        }

        public ContextItem get(ContextKey name) {
            if (name.equals(ContextKey.CALLER)) {
                return this.m;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this.getClass().equals(obj.getClass())) {
                MethodContext other = (MethodContext)obj;
                return this.m.equals(other.m);
            }
            return false;
        }

        public int hashCode() {
            return this.m.hashCode() * 19;
        }

        public String toString() {
            return this.m.toString();
        }
    }

    public static class ContextInsensitiveForPrimordialsPolicy
    implements IPolicy {
        IPolicy basePolicy;

        public ContextInsensitiveForPrimordialsPolicy(IPolicy basePolicy) {
            this.basePolicy = basePolicy;
        }

        @Override
        public CGNode callerPolicy(CGNode caller, IMethod callee) {
            ClassLoaderReference cref = callee.getDeclaringClass().getClassLoader().getReference();
            if (cref.equals((Object)ClassLoaderReference.Primordial)) {
                return null;
            }
            return this.basePolicy.callerPolicy(caller, callee);
        }

        @Override
        public CallSiteReference sitePolicy(CGNode caller, CallSiteReference site, IMethod callee) {
            ClassLoaderReference cref = callee.getDeclaringClass().getClassLoader().getReference();
            if (cref.equals((Object)ClassLoaderReference.Primordial)) {
                return null;
            }
            return this.basePolicy.sitePolicy(caller, site, callee);
        }
    }

    public static class AlwaysContextInsensitivePolicy
    implements IPolicy {
        @Override
        public CallSiteReference sitePolicy(CGNode caller, CallSiteReference site, IMethod callee) {
            return null;
        }

        @Override
        public CGNode callerPolicy(CGNode caller, IMethod callee) {
            return null;
        }
    }

    public static class AlwaysOneLevelCallerSitePolicy
    implements IPolicy {
        @Override
        public CallSiteReference sitePolicy(CGNode caller, CallSiteReference site, IMethod callee) {
            return null;
        }

        @Override
        public CGNode callerPolicy(CGNode caller, IMethod callee) {
            return caller;
        }
    }

    public static class AlwaysOneLevelSitePolicy
    implements IPolicy {
        @Override
        public CallSiteReference sitePolicy(CGNode caller, CallSiteReference site, IMethod callee) {
            return site;
        }

        @Override
        public CGNode callerPolicy(CGNode caller, IMethod callee) {
            return null;
        }
    }

    public static class AlwaysOneLevelCallerPolicy
    implements IPolicy {
        @Override
        public CallSiteReference sitePolicy(CGNode caller, CallSiteReference site, IMethod callee) {
            return null;
        }

        @Override
        public CGNode callerPolicy(CGNode caller, IMethod callee) {
            return caller;
        }
    }

    public static interface IPolicy {
        public CallSiteReference sitePolicy(CGNode var1, CallSiteReference var2, IMethod var3);

        public CGNode callerPolicy(CGNode var1, IMethod var2);
    }
}

