/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.stringAnalysis.condition.AndCondition;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.FalseCondition;
import com.ibm.wala.stringAnalysis.condition.ICondition;
import com.ibm.wala.stringAnalysis.condition.IConditionFactory;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.OrCondition;
import com.ibm.wala.stringAnalysis.condition.TrueCondition;
import com.ibm.wala.stringAnalysis.condition.VarCondition;

public class ConditionFactory
implements IConditionFactory {
    @Override
    public ICondition createAndCondition(ICondition c1, ICondition c2) {
        return new AndCondition(c1, c2);
    }

    @Override
    public IPrimitiveCondition createFalseCondition() {
        return FalseCondition.theInstance;
    }

    @Override
    public IPrimitiveCondition createTrueCondition() {
        return TrueCondition.theInstance;
    }

    @Override
    public IPrimitiveCondition createCaseCondition(int v, int label) {
        return new CaseCondition(v, label);
    }

    @Override
    public IPrimitiveCondition createNotCaseCondition(int v, int label) {
        return new NotCaseCondition(v, label);
    }

    @Override
    public ICondition createOrCondition(ICondition c1, ICondition c2) {
        return new OrCondition(c1, c2);
    }

    @Override
    public IPrimitiveCondition createVarCondition(int v) {
        return new VarCondition(v);
    }
}

