/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.grammar;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InvocationSymbol
implements ISymbol {
    private List<ISymbol> parameters = new ArrayList<ISymbol>();
    private SignatureSymbol funcSymbol = null;
    private ISymbol recvSymbol;
    private CallGraph cg;
    private CGNode cgNode;
    private SSAInstruction instruction = null;
    private int hashCode = 0;

    private InvocationSymbol() {
    }

    public InvocationSymbol(CallGraph cg, CGNode cgNode, SSAInstruction instruction, SignatureSymbol funcSymbol, ISymbol recvSymbol, List<? extends ISymbol> parameters) {
        this();
        this.cg = cg;
        this.cgNode = cgNode;
        this.instruction = instruction;
        this.funcSymbol = funcSymbol;
        this.recvSymbol = recvSymbol;
        this.parameters.addAll(parameters);
    }

    public InvocationSymbol(CallGraph cg, CGNode cgNode, SSAInstruction instruction, SignatureSymbol funcSymbol, ISymbol recvSymbol, ISymbol[] parameters) {
        this(cg, cgNode, instruction, funcSymbol, recvSymbol, SAUtil.list((Object[])parameters));
    }

    public InvocationSymbol(CallGraph cg, CGNode cgNode, SSAInstruction instruction, String funcName, String recvName, ISymbol[] parameters) {
        this(cg, cgNode, instruction, new SignatureSymbol(funcName), (ISymbol)new SignatureSymbol(recvName), parameters);
    }

    public InvocationSymbol(SignatureSymbol funcName, ISymbol recvName, ISymbol[] parameters) {
        this(null, null, null, funcName, recvName, Arrays.asList(parameters));
    }

    public SignatureSymbol getFunction() {
        return this.funcSymbol;
    }

    public ISymbol getReceiver() {
        return this.recvSymbol;
    }

    public List<ISymbol> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ISymbol getParameter(int index) {
        return this.parameters.get(index);
    }

    public SSAInstruction getInstruction() {
        return this.instruction;
    }

    public IR getIR() {
        return this.getCGNode().getIR();
    }

    public CGNode getCGNode() {
        return this.cgNode;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    public String getName() {
        return this.funcSymbol.getName();
    }

    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (symbol == null) {
            return false;
        }
        if (!this.getClass().equals(symbol.getClass())) {
            return false;
        }
        InvocationSymbol isym = (InvocationSymbol)symbol;
        if (this.funcSymbol.matches((ISymbol)isym.funcSymbol, ctx) && (this.recvSymbol == isym.recvSymbol || this.recvSymbol.matches(isym.recvSymbol, ctx)) && this.parameters.size() == isym.getParameters().size()) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                ISymbol s2;
                ISymbol s1 = this.parameters.get(i);
                if (s1.matches(s2 = isym.getParameters().get(i), ctx)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        if (symbol == null) {
            return false;
        }
        if (!this.getClass().equals(symbol.getClass())) {
            return false;
        }
        InvocationSymbol isym = (InvocationSymbol)symbol;
        if (this.funcSymbol.possiblyMatches((ISymbol)isym.funcSymbol, ctx) && (this.recvSymbol == isym.recvSymbol || this.recvSymbol.possiblyMatches(isym.recvSymbol, ctx)) && this.parameters.size() == isym.getParameters().size()) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                ISymbol s2;
                ISymbol s1 = this.parameters.get(i);
                if (s1.possiblyMatches(s2 = isym.getParameters().get(i), ctx)) continue;
                return false;
            }
        }
        return true;
    }

    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit((ISymbol)this);
        if (this.funcSymbol != null) {
            this.funcSymbol.traverse(visitor);
        }
        if (this.recvSymbol != null) {
            this.recvSymbol.traverse(visitor);
        }
        for (ISymbol s : this.parameters) {
            s.traverse(visitor);
        }
        visitor.onLeave((ISymbol)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy((ISymbol)this);
        if (s instanceof InvocationSymbol) {
            InvocationSymbol invoke = (InvocationSymbol)s;
            invoke.funcSymbol = (SignatureSymbol)copier.copySymbolReference((ISymbol)invoke, (ISymbol)invoke.funcSymbol);
            invoke.recvSymbol = copier.copySymbolReference((ISymbol)invoke, invoke.recvSymbol);
            invoke.parameters = (List)copier.copySymbolReferences((ISymbol)invoke, invoke.parameters, new ArrayList());
            invoke.hashCode = 0;
        }
        return s;
    }

    public int size() {
        return 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (this.funcSymbol == null ? 0 : this.funcSymbol.hashCode()) + (this.recvSymbol == null ? 0 : this.recvSymbol.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        InvocationSymbol isym = (InvocationSymbol)obj;
        if (this.hashCode() != isym.hashCode()) {
            return false;
        }
        boolean r = !(this.funcSymbol != isym.funcSymbol && !this.funcSymbol.equals((Object)isym.funcSymbol) || this.recvSymbol != isym.recvSymbol && !this.recvSymbol.equals(isym.recvSymbol) || !this.parameters.equals(isym.parameters));
        return r;
    }

    public String toString() {
        StringBuffer paramStr = new StringBuffer();
        Iterator<ISymbol> i = this.parameters.iterator();
        while (i.hasNext()) {
            ISymbol param = i.next();
            paramStr.append(param.toString());
            if (!i.hasNext()) continue;
            paramStr.append(", ");
        }
        return "&" + this.recvSymbol + "." + (Object)((Object)this.funcSymbol) + "(" + paramStr + ")";
    }
}

