/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.slicer;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.stringAnalysis.slicer.Messages;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public final class DelegatingCallGraph
extends ExplicitCallGraph
implements CallGraph {
    private final ExplicitCallGraph originalCG;
    private final Predicate<CGNode> filter;

    public DelegatingCallGraph(ExplicitCallGraph theOriginalGraph, Predicate<CGNode> theFilter, IClassHierarchy theCHA, AnalysisOptions theOptions, AnalysisCache theCache) {
        super(theCHA, theOptions, theCache);
        this.originalCG = theOriginalGraph;
        this.filter = theFilter;
    }

    public void addNode(CGNode n) {
        throw new UnsupportedOperationException();
    }

    public boolean containsNode(CGNode n) {
        return this.filter.test((Object)n) && this.originalCG.containsNode(n);
    }

    public int getNumberOfNodes() {
        return IteratorUtil.count(this.iterator());
    }

    public Iterator<CGNode> iterator() {
        return new FilterIterator(this.originalCG.iterator(), this.filter);
    }

    public void addEdge(CGNode src, CGNode dst) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Iterator<CGNode> getPredNodes(CGNode n) throws IllegalArgumentException {
        return new FilterIterator(this.originalCG.getPredNodes((Object)n), this.filter);
    }

    public int getPredNodeCount(CGNode n) throws IllegalArgumentException {
        return IteratorUtil.count(this.getPredNodes(n));
    }

    public Iterator<CGNode> getSuccNodes(CGNode n) throws IllegalArgumentException {
        return new FilterIterator(this.originalCG.getSuccNodes((Object)n), this.filter);
    }

    public int getSuccNodeCount(CGNode n) throws IllegalArgumentException {
        return IteratorUtil.count(this.getSuccNodes(n));
    }

    public boolean hasEdge(CGNode src, CGNode dst) {
        return this.filter.test((Object)src) && this.filter.test((Object)dst) && this.originalCG.hasEdge((Object)src, (Object)dst);
    }

    public void removeAllIncidentEdges(CGNode node) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(CGNode src, CGNode dst) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void removeIncomingEdges(CGNode node) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void removeNode(CGNode node) {
        throw new UnsupportedOperationException();
    }

    public void removeOutgoingEdges(CGNode node) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void removeNodeAndEdges(CGNode node) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public int getMaxNumber() {
        return this.originalCG.getMaxNumber();
    }

    public CGNode getNode(int number) {
        CGNode node = (CGNode)this.originalCG.getNode(number);
        if (this.filter.test((Object)node)) {
            return node;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodeNumberNotInCG, (Object)number));
    }

    public int getNumber(CGNode n) {
        if (this.containsNode(n)) {
            return this.originalCG.getNumber((Object)n);
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodeNotInCG, (Object)n));
    }

    public Iterator<CGNode> iterateNodes(IntSet intSet) {
        return new FilterIterator((Iterator)new NumberedNodeIterator(intSet, (NumberedNodeManager)this.originalCG), this.filter);
    }

    public IntSet getPredNodeNumbers(CGNode n) {
        if (this.containsNode(n)) {
            MutableIntSet predNums = IntSetUtil.make();
            Iterator iter = this.originalCG.getPredNodes((Object)n);
            while (iter.hasNext()) {
                CGNode node = (CGNode)iter.next();
                if (!this.containsNode(n)) continue;
                predNums.add(this.originalCG.getNumber((Object)node));
            }
            return predNums;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodeNotInCG, (Object)n));
    }

    public IntSet getSuccNodeNumbers(CGNode n) {
        if (this.containsNode(n)) {
            MutableIntSet succNums = IntSetUtil.make();
            Iterator iter = this.originalCG.getSuccNodes((Object)n);
            while (iter.hasNext()) {
                CGNode node = (CGNode)iter.next();
                if (!this.containsNode(n)) continue;
                succNums.add(this.originalCG.getNumber((Object)node));
            }
            return succNums;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodeNotInCG, (Object)n));
    }

    public Collection<CGNode> getEntrypointNodes() {
        Collection originalEntryPoints = this.originalCG.getEntrypointNodes();
        ArrayList<CGNode> entryPoints = new ArrayList<CGNode>(originalEntryPoints.size());
        for (CGNode node : originalEntryPoints) {
            if (!this.containsNode(node)) continue;
            entryPoints.add(node);
        }
        return entryPoints;
    }

    public CGNode getNode(IMethod method, Context context) {
        CGNode node = this.originalCG.getNode(method, context);
        return node == null || !this.containsNode(node) ? null : node;
    }

    public Set<CGNode> getNodes(MethodReference methodRef) {
        Set nodes = this.originalCG.getNodes(methodRef);
        HashSet<CGNode> resultNodes = new HashSet<CGNode>(nodes.size());
        for (CGNode node : nodes) {
            if (!this.containsNode(node)) continue;
            resultNodes.add(node);
        }
        return resultNodes;
    }

    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        return this.containsNode(node) ? this.originalCG.getPossibleTargets(node, site).size() : -1;
    }

    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        if (this.containsNode(src) && this.containsNode(target)) {
            return this.originalCG.getPossibleSites(src, target);
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodesNotInCG, (Object)src, (Object)target));
    }

    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        if (this.containsNode(node)) {
            HashSet targets = HashSetFactory.make();
            for (CGNode target : this.originalCG.getPossibleTargets(node, site)) {
                if (!this.containsNode(target)) continue;
                targets.add(target);
            }
            return targets;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodeNotInCG, (Object)node));
    }

    public IntSet getPossibleTargetNumbers(CGNode node, CallSiteReference site) {
        if (this.containsNode(node)) {
            MutableIntSet targets = IntSetUtil.make();
            for (CGNode target : this.originalCG.getPossibleTargets(node, site)) {
                if (!this.containsNode(target)) continue;
                targets.add(this.originalCG.getNumber((Object)target));
            }
            return targets;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.DACG_NodeNotInCG, (Object)node));
    }
}

