/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.stringAnalysis.ssa.Util;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.IntStack;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractSSAConversion {
    protected final SSACFG CFG;
    protected final DominanceFrontiers<ISSABasicBlock> DF;
    private final Graph<ISSABasicBlock> dominatorTree;
    protected final int[] phiCounts;
    protected final SSAInstruction[] instructions;
    private final int[] flags;
    protected final SymbolTable symbolTable;
    protected final SSAOptions.DefaultValues defaultValues;
    protected IntStack[] S;
    protected int[] C;
    protected int[] valueMap;
    private Set<SSACFG.BasicBlock>[] assignmentMap;

    protected abstract int getNumberOfDefs(SSAInstruction var1);

    protected abstract int getDef(SSAInstruction var1, int var2);

    protected abstract int getNumberOfUses(SSAInstruction var1);

    protected abstract int getUse(SSAInstruction var1, int var2);

    protected abstract boolean isAssignInstruction(SSAInstruction var1);

    protected abstract int getMaxValueNumber();

    protected abstract boolean isLive(SSACFG.BasicBlock var1, int var2);

    protected abstract boolean skip(int var1);

    protected abstract boolean isConstant(int var1);

    protected abstract int getNextNewValueNumber();

    protected abstract void initializeVariables();

    protected abstract void repairExit();

    protected abstract void placeNewPhiAt(int var1, SSACFG.BasicBlock var2);

    protected abstract SSAPhiInstruction getPhi(SSACFG.BasicBlock var1, int var2);

    protected abstract void setPhi(SSACFG.BasicBlock var1, int var2, SSAPhiInstruction var3);

    protected abstract SSAPhiInstruction repairPhiDefs(SSAPhiInstruction var1, int[] var2);

    protected abstract void repairPhiUse(SSACFG.BasicBlock var1, int var2, int var3, int var4);

    protected abstract void repairInstructionUses(SSAInstruction var1, int var2, int[] var3);

    protected abstract void repairInstructionDefs(SSAInstruction var1, int var2, int[] var3, int[] var4);

    protected abstract void pushAssignment(SSAInstruction var1, int var2, int var3);

    protected abstract void popAssignment(SSAInstruction var1, int var2);

    protected AbstractSSAConversion(IR ir, SSAOptions options) {
        this.CFG = ir.getControlFlowGraph();
        this.DF = new DominanceFrontiers((Graph)ir.getControlFlowGraph(), (Object)ir.getControlFlowGraph().entry());
        this.dominatorTree = this.DF.dominatorTree();
        this.flags = new int[2 * ir.getControlFlowGraph().getNumberOfNodes()];
        this.instructions = this.getInstructions(ir);
        this.phiCounts = new int[this.CFG.getNumberOfNodes()];
        this.symbolTable = ir.getSymbolTable();
        this.defaultValues = options.getDefaultValues();
    }

    protected void perform() {
        this.init();
        this.placePhiNodes();
        this.renameVariables();
    }

    protected SSAInstruction[] getInstructions(IR ir) {
        return ir.getInstructions();
    }

    protected final Iterator<SSAInstruction> iterateInstructions(IR ir) {
        return new ArrayIterator((Object[])this.getInstructions(ir));
    }

    protected void init() {
        this.S = new IntStack[this.getMaxValueNumber() + 1];
        this.C = new int[this.getMaxValueNumber() + 1];
        this.valueMap = new int[this.getMaxValueNumber() + 1];
        this.makeAssignmentMap();
    }

    private void makeAssignmentMap() {
        this.assignmentMap = new Set[this.getMaxValueNumber() + 1];
        for (SSACFG.BasicBlock BB : this.CFG) {
            if (BB.getFirstInstructionIndex() < 0) continue;
            for (SSAInstruction inst : BB) {
                if (inst == null) continue;
                for (int j = 0; j < this.getNumberOfDefs(inst); ++j) {
                    this.addDefiningBlock(this.assignmentMap, BB, this.getDef(inst, j));
                }
            }
        }
    }

    private void addDefiningBlock(Set<SSACFG.BasicBlock>[] A, SSACFG.BasicBlock BB, int i) {
        if (!this.skip(i)) {
            if (A[i] == null) {
                A[i] = new LinkedHashSet<SSACFG.BasicBlock>(2);
            }
            A[i].add(BB);
        }
    }

    protected void placePhiNodes() {
        int IterCount = 0;
        for (SSACFG.BasicBlock X : this.CFG) {
            this.setHasAlready(X, 0);
            this.setWork(X, 0);
        }
        LinkedHashSet<SSACFG.BasicBlock> W = new LinkedHashSet<SSACFG.BasicBlock>();
        for (int V = 0; V < this.assignmentMap.length; ++V) {
            if (this.assignmentMap[V] == null || this.skip(V)) continue;
            ++IterCount;
            for (SSACFG.BasicBlock X : this.assignmentMap[V]) {
                this.setWork(X, IterCount);
                W.add(X);
            }
            while (!W.isEmpty()) {
                SSACFG.BasicBlock X = (SSACFG.BasicBlock)W.iterator().next();
                W.remove(X);
                Iterator YS = this.DF.getDominanceFrontier((Object)X);
                while (YS.hasNext()) {
                    SSACFG.BasicBlock Y = (SSACFG.BasicBlock)YS.next();
                    if (this.getHasAlready(Y) >= IterCount) continue;
                    if (this.isLive(Y, V)) {
                        this.placeNewPhiAt(V, Y);
                        int n = Y.getGraphNodeId();
                        this.phiCounts[n] = this.phiCounts[n] + 1;
                    }
                    this.setHasAlready(Y, IterCount);
                    if (this.getWork(Y) >= IterCount) continue;
                    this.setWork(Y, IterCount);
                    W.add(Y);
                }
            }
        }
    }

    private int getWork(SSACFG.BasicBlock BB) {
        return this.flags[BB.getGraphNodeId() * 2 + 1];
    }

    private void setWork(SSACFG.BasicBlock BB, int v) {
        this.flags[BB.getGraphNodeId() * 2 + 1] = v;
    }

    private int getHasAlready(SSACFG.BasicBlock BB) {
        return this.flags[BB.getGraphNodeId() * 2];
    }

    private void setHasAlready(SSACFG.BasicBlock BB, int v) {
        this.flags[BB.getGraphNodeId() * 2] = v;
    }

    private void renameVariables() {
        for (int V = 1; V <= this.getMaxValueNumber(); ++V) {
            if (this.skip(V)) continue;
            this.C[V] = 0;
            this.S[V] = new IntStack();
        }
        this.initializeVariables();
        this.SEARCH(this.CFG.entry());
    }

    private void SEARCH(SSACFG.BasicBlock X) {
        int j;
        SSAPhiInstruction A;
        int i;
        int i2;
        int id = X.getGraphNodeId();
        int Xf = X.getFirstInstructionIndex();
        for (i2 = 0; i2 < this.phiCounts[id]; ++i2) {
            SSAPhiInstruction phi = this.getPhi(X, i2);
            if (this.skipRepair((SSAInstruction)phi, -1)) continue;
            this.setPhi(X, i2, this.repairPhiDefs(phi, this.makeNewDefs((SSAInstruction)phi)));
        }
        for (i2 = Xf; i2 <= X.getLastInstructionIndex(); ++i2) {
            SSAInstruction inst = this.instructions[i2];
            if (this.isAssignInstruction(inst)) {
                int lhs = this.getDef(inst, 0);
                int rhs = this.getUse(inst, 0);
                int newRhs = this.skip(rhs) ? rhs : this.top(rhs);
                this.S[lhs].push(newRhs);
                this.pushAssignment(inst, i2, newRhs);
                continue;
            }
            if (this.skipRepair(inst, i2)) continue;
            int[] newUses = this.makeNewUses(inst);
            this.repairInstructionUses(inst, i2, newUses);
            int[] newDefs = this.makeNewDefs(inst);
            this.repairInstructionDefs(inst, i2, newDefs, newUses);
        }
        if (X.isExitBlock()) {
            this.repairExit();
        }
        Iterator YS = this.CFG.getSuccNodes((ISSABasicBlock)X);
        while (YS.hasNext()) {
            SSACFG.BasicBlock Y = (SSACFG.BasicBlock)YS.next();
            int Y_id = Y.getGraphNodeId();
            int j2 = Util.whichPred(this.CFG, Y, X);
            for (int i3 = 0; i3 < this.phiCounts[Y_id]; ++i3) {
                SSAPhiInstruction phi = this.getPhi(Y, i3);
                if (this.skipRepair((SSAInstruction)phi, -1)) continue;
                int oldUse = this.getUse((SSAInstruction)phi, j2);
                int newUse = this.skip(oldUse) ? oldUse : this.top(oldUse);
                this.repairPhiUse(Y, i3, j2, newUse);
            }
        }
        YS = this.dominatorTree.getSuccNodes((Object)X);
        while (YS.hasNext()) {
            this.SEARCH((SSACFG.BasicBlock)YS.next());
        }
        for (i = 0; i < this.phiCounts[id]; ++i) {
            A = this.getPhi(X, i);
            if (this.skipRepair((SSAInstruction)A, -1)) continue;
            for (j = 0; j < this.getNumberOfDefs((SSAInstruction)A); ++j) {
                if (this.skip(this.getDef((SSAInstruction)A, j))) continue;
                this.S[this.valueMap[this.getDef((SSAInstruction)A, j)]].pop();
            }
        }
        for (i = Xf; i <= X.getLastInstructionIndex(); ++i) {
            A = this.instructions[i];
            if (this.isAssignInstruction((SSAInstruction)A)) {
                this.S[this.getDef((SSAInstruction)A, 0)].pop();
                this.popAssignment((SSAInstruction)A, i);
                continue;
            }
            if (A == null) continue;
            for (j = 0; j < this.getNumberOfDefs((SSAInstruction)A); ++j) {
                if (this.skip(this.getDef((SSAInstruction)A, j))) continue;
                this.S[this.valueMap[this.getDef((SSAInstruction)A, j)]].pop();
            }
        }
    }

    private int[] makeNewUses(SSAInstruction inst) {
        int[] newUses = new int[this.getNumberOfUses(inst)];
        for (int j = 0; j < this.getNumberOfUses(inst); ++j) {
            newUses[j] = this.skip(this.getUse(inst, j)) ? this.getUse(inst, j) : this.top(this.getUse(inst, j));
        }
        return newUses;
    }

    private int[] makeNewDefs(SSAInstruction inst) {
        int[] newDefs = new int[this.getNumberOfDefs(inst)];
        for (int j = 0; j < this.getNumberOfDefs(inst); ++j) {
            if (this.skip(this.getDef(inst, j))) {
                newDefs[j] = this.getDef(inst, j);
                continue;
            }
            int ii = this.getNextNewValueNumber();
            if (this.valueMap.length <= ii) {
                int[] nvm = new int[this.valueMap.length * 2 + ii + 1];
                System.arraycopy(this.valueMap, 0, nvm, 0, this.valueMap.length);
                this.valueMap = nvm;
            }
            this.valueMap[ii] = this.getDef(inst, j);
            this.S[this.getDef(inst, j)].push(ii);
            newDefs[j] = ii;
        }
        return newDefs;
    }

    protected boolean skipRepair(SSAInstruction inst, int index) {
        int i;
        if (inst == null) {
            return true;
        }
        for (i = 0; i < this.getNumberOfDefs(inst); ++i) {
            if (this.skip(this.getDef(inst, i))) continue;
            return false;
        }
        for (i = 0; i < this.getNumberOfUses(inst); ++i) {
            if (this.skip(this.getUse(inst, i))) continue;
            return false;
        }
        return true;
    }

    protected void fail(int v) {
        assert (this.isConstant(v) || !this.S[v].isEmpty()) : "bad stack for " + v + " while SSA converting";
    }

    protected boolean hasDefaultValue(int valueNumber) {
        return this.defaultValues != null && this.defaultValues.getDefaultValue(this.symbolTable, valueNumber) != -1;
    }

    protected int getDefaultValue(int valueNumber) {
        return this.defaultValues.getDefaultValue(this.symbolTable, valueNumber);
    }

    protected int top(int v) {
        if (!this.isConstant(v) && this.S[v].isEmpty()) {
            if (this.hasDefaultValue(v)) {
                return this.getDefaultValue(v);
            }
            this.fail(v);
        }
        return this.isConstant(v) ? v : this.S[v].peek();
    }
}

