/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.stringAnalysis.ssa.SSAConversion;
import com.ibm.wala.stringAnalysis.ssa.SSAConversionException;
import com.ibm.wala.stringAnalysis.ssa.SyntheticIR;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class IRRewriter {
    private final SSAInstructionFactory factory;

    public IRRewriter(SSAInstructionFactory factory) {
        this.factory = factory;
    }

    public Conversion rewrite(IR ir, Context ctx, ISSAInstructionRewriteRule rule) {
        SSAInstruction[] inst = ir.getInstructions();
        SSAInstruction[] orig = (SSAInstruction[])inst.clone();
        for (int i = 0; i < inst.length; ++i) {
            if (inst[i] == null || !rule.matches(inst[i])) continue;
            inst[i] = rule.rewrite(this.factory, inst[i]);
        }
        try {
            SSAConversion conv = SSAConversion.convert(ir.getMethod(), ir, ir.getOptions());
            return new Conversion(ir, orig, conv);
        }
        catch (SSAConversionException e) {
            SAUtil.print((Object)e);
            return null;
        }
    }

    public IR copyAndRewrite(IR ir, Context ctx, Logger logger, ISSAInstructionRewriteRule rule) {
        SyntheticIR sir = SyntheticIR.makeIR(ir);
        SSAInstruction[] inst = sir.getInstructions();
        for (int i = 0; i < inst.length; ++i) {
            if (inst[i] == null || !rule.matches(inst[i])) continue;
            inst[i] = rule.rewrite(this.factory, inst[i]);
        }
        try {
            SSAConversion.convert(sir.getMethod(), sir, sir.getOptions());
            return sir;
        }
        catch (SSAConversionException e) {
            logger.trace((Object)"SSA conversion issue", (Throwable)e);
            SAUtil.print((Object)e);
            return null;
        }
    }

    public static class Conversion {
        private final SSAConversion conv;
        private final SSAInstruction[] inst;
        private final IR ir;

        public Conversion(IR ir, SSAInstruction[] inst, SSAConversion conv) {
            this.ir = ir;
            this.inst = inst;
            this.conv = conv;
        }

        public void redo() {
            this.conv.redoSSAConversion();
        }

        public void undo() {
            this.conv.undoSSAConversion();
            System.arraycopy(this.ir.getInstructions(), 0, this.inst, 0, this.inst.length);
        }
    }

    public static class SSAInvocationRewriteRule
    extends SSAInstructionRewriteRule {
        private Pattern signaturePattern;

        public SSAInvocationRewriteRule(IValueNumberReference[] defs, IValueNumberReference[] uses, Pattern pattern) {
            super(defs, uses);
            this.signaturePattern = pattern;
        }

        public static SSAInvocationRewriteRule makeFromString(IValueNumberReference[] defs, IValueNumberReference[] uses, String signature) {
            return SSAInvocationRewriteRule.makeFromRegex(defs, uses, Pattern.quote(signature));
        }

        public static SSAInvocationRewriteRule makeFromRegex(IValueNumberReference[] defs, IValueNumberReference[] uses, String pattern) {
            return new SSAInvocationRewriteRule(defs, uses, Pattern.compile(pattern));
        }

        @Override
        public boolean matches(SSAInstruction instruction) {
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                String sig = invoke.getDeclaredTarget().getSignature();
                return this.signaturePattern.matcher(sig).matches();
            }
            return false;
        }
    }

    public static abstract class SSAInstructionRewriteRule
    implements ISSAInstructionRewriteRule {
        private IValueNumberReference[] defRefs;
        private IValueNumberReference[] useRefs;

        public SSAInstructionRewriteRule(IValueNumberReference[] defs, IValueNumberReference[] uses) {
            this.defRefs = defs;
            this.useRefs = uses;
        }

        @Override
        public SSAInstruction rewrite(SSAInstructionFactory factory, SSAInstruction instruction) {
            int i;
            int[] newDefs = new int[this.defRefs.length];
            int[] newUses = new int[this.useRefs.length];
            for (i = 0; i < this.defRefs.length; ++i) {
                newDefs[i] = this.defRefs[i].getValueNumber(instruction);
            }
            for (i = 0; i < this.useRefs.length; ++i) {
                newDefs[i] = this.useRefs[i].getValueNumber(instruction);
            }
            return instruction.copyForSSA(factory, newDefs, newUses);
        }
    }

    public static class UseReference
    extends ValueNumberReference {
        public UseReference(int nth) {
            super(nth);
        }

        public int getValueNumber(SSAInstruction instruction) {
            return instruction.getUse(this.nth);
        }
    }

    public static class DefReference
    extends ValueNumberReference {
        public DefReference(int nth) {
            super(nth);
        }

        public int getValueNumber(SSAInstruction instruction) {
            return instruction.getDef(this.nth);
        }
    }

    public static abstract class ValueNumberReference {
        protected int nth;

        public ValueNumberReference(int nth) {
            this.nth = nth;
        }
    }

    public static interface IValueNumberReference {
        public int getValueNumber(SSAInstruction var1);
    }

    public static interface ISSAInstructionRewriteRule {
        public boolean matches(SSAInstruction var1);

        public SSAInstruction rewrite(SSAInstructionFactory var1, SSAInstruction var2);
    }
}

