/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.BooleanSymbol;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.RealSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.util.collections.ConcurrentHashSet;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.stringAnalysis.grammar.CDVariable;
import com.ibm.wala.stringAnalysis.grammar.ClassSymbol;
import com.ibm.wala.stringAnalysis.grammar.FieldSymbol;
import com.ibm.wala.stringAnalysis.grammar.InstanceKeyVariable;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.MemberVariable;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.SSAConstantSymbol;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BasicSymbolFactory<T>
implements ISymbolFactory<T> {
    protected static ISymbol NULL_SYMBOL = new SSAConstantSymbol("#null", "");
    protected static ISymbol UNDEFINED_SYMBOL = new SSAConstantSymbol("#undefined", "");
    protected static ISymbol NAN_SYMBOL = new SSAConstantSymbol("#NaN", "");
    protected static ISymbol DEFAULT_PARAMETER_VALUE_SYMBOL = NULL_SYMBOL;
    private ITranslatorRepository<T> repository;
    private IVariableFactory<IVariable> varFactory;
    private Map<CallGraph, Map<IMethod, Set<CGNode>>> nodeCache;

    public BasicSymbolFactory(ITranslatorRepository<T> repository, IVariableFactory<IVariable> varFactory) {
        this.repository = repository;
        this.varFactory = varFactory;
        this.nodeCache = new ConcurrentHashMap<CallGraph, Map<IMethod, Set<CGNode>>>();
    }

    @Override
    public ITranslatorRepository<T> getRepository() {
        return this.repository;
    }

    @Override
    public IVariableFactory<IVariable> getVariableFactory() {
        return this.varFactory;
    }

    @Override
    public ISymbol createNullSymbol() {
        return NULL_SYMBOL;
    }

    @Override
    public ISymbol createUndefinedValueSymbol() {
        return UNDEFINED_SYMBOL;
    }

    @Override
    public ISymbol createNANSymbol() {
        return NAN_SYMBOL;
    }

    @Override
    public ISymbol getDefaultParameterValueSymbol() {
        return DEFAULT_PARAMETER_VALUE_SYMBOL;
    }

    @Override
    public Collection<ISymbol> createInstanceKeySymbol(int v, TranslationContext ctx) throws ISymbolFactory.NoInstanceKeyException {
        throw new ISymbolFactory.NoInstanceKeyException("cannot use the pointer analysis");
    }

    protected synchronized Map<IMethod, Set<CGNode>> getNodeCache(CallGraph cg) {
        Map<IMethod, Set<CGNode>> cache = this.nodeCache.get(cg);
        if (cache == null) {
            cache = new ConcurrentHashMap<IMethod, Set<CGNode>>();
            this.nodeCache.put(cg, cache);
        }
        return cache;
    }

    protected synchronized Set<CGNode> getNodeCache(CallGraph cg, IMethod m) {
        Map<IMethod, Set<CGNode>> c = this.getNodeCache(cg);
        Set<CGNode> nodes = c.get(m);
        if (nodes == null) {
            nodes = this.createNodes(cg, m);
            c.put(m, nodes);
        }
        return nodes;
    }

    protected synchronized Set<CGNode> createNodes(CallGraph cg, IMethod m) {
        return new ConcurrentHashSet();
    }

    protected Collection<ISymbol> getInstanceKeySymbol(InstanceKey ikey, TranslationContext ctx) {
        TypeReference type = ikey.getConcreteType().getReference();
        HashSet<ISymbol> result = new HashSet<ISymbol>();
        if (ikey instanceof ConstantKey) {
            ConstantKey ckey = (ConstantKey)ikey;
            ISymbol s = this.getObjectSymbol(ckey.getValue(), type);
            if (s != null) {
                result.add(s);
            }
        } else if (ikey instanceof ConcreteTypeKey) {
            ISymbol s;
            ConcreteTypeKey tkey = (ConcreteTypeKey)ikey;
            IClass klass = tkey.getConcreteType();
            if (!klass.getName().toString().equals("Ljava/lang/String") && (s = this.getObjectSymbol(klass, type)) != null) {
                result.add(s);
            }
        } else if (ikey instanceof AllocationSiteInNode) {
            AllocationSiteInNode akey = (AllocationSiteInNode)ikey;
            CGNode node = akey.getNode();
            IR ir = node.getIR();
            NewSiteReference sref = akey.getSite();
            SSANewInstruction newInstruction = ir.getNew(sref);
            TranslationContext newCtx = new TranslationContext(ir, node, ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
            Collection<ISymbol> s = this.createValueSymbol(newInstruction.getDef(0), (SSAInstruction)newInstruction, newCtx);
            result.addAll(s);
        } else if (ikey instanceof AllocationSite) {
            CallGraph cg = ctx.getCallGraph();
            AllocationSite akey = (AllocationSite)ikey;
            Set<CGNode> nodes = this.getNodeCache(cg, akey.getMethod());
            for (CGNode node : nodes) {
                NewSiteReference sref = akey.getSite();
                SSANewInstruction newInstruction = node.getIR().getNew(sref);
                TranslationContext newCtx = new TranslationContext(node.getIR(), node, ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
                Collection<ISymbol> s = this.createValueSymbol(newInstruction.getDef(0), (SSAInstruction)newInstruction, newCtx);
                result.addAll(s);
            }
        }
        return result;
    }

    @Override
    public Collection<ISymbol> createValueSymbol(int v, SSAInstruction instruction, TranslationContext ctx) {
        if (v < 0) {
            return Collections.singleton(null);
        }
        Value val = ctx.getIR().getSymbolTable().getValue(v);
        Collection<ISymbol> s = this.getValueSymbol(v, val, ctx);
        return s;
    }

    protected Collection<ISymbol> getValueSymbol(int v, Value val, TranslationContext ctx) {
        TypeInference typeInference;
        TypeReference type;
        ConstantValue cval;
        Object obj;
        ISymbol s;
        if (val instanceof ConstantValue && (s = this.getObjectSymbol(obj = (cval = (ConstantValue)val).getValue(), type = (typeInference = ctx.getTypeInference()) == null ? null : typeInference.getType(v).getTypeReference())) != null) {
            return Collections.singleton(s);
        }
        return new HashSet<IVariable>(this.createCDVariable(v, ctx));
    }

    @Override
    public IVariable createValueNumberVariable(int v, CGNode node, CallGraph cg) {
        CDVariable var = new CDVariable(v, node);
        return var;
    }

    @Override
    public Collection<IVariable> createCDVariable(int v, TranslationContext ctx) {
        return Collections.singleton(this.createValueNumberVariable(v, ctx.getCGNode(), ctx.getCallGraph()));
    }

    protected ISymbol getObjectSymbol(Object obj, TypeReference type) {
        if (obj == null) {
            return NULL_SYMBOL;
        }
        if (obj instanceof String) {
            return new StringSymbol((String)obj);
        }
        if (obj instanceof Number) {
            String s;
            Number num = (Number)obj;
            if (type == null) {
                if (obj instanceof Float) {
                    return new RealSymbol((Float)obj);
                }
                if (obj instanceof Double) {
                    return new RealSymbol((Double)obj);
                }
                if (obj instanceof Integer) {
                    return new IntSymbol((Integer)obj);
                }
                if (obj instanceof Long) {
                    return new IntSymbol((Long)obj);
                }
                if (obj instanceof Byte) {
                    return new CharSymbol(((Byte)obj).byteValue());
                }
                if (obj instanceof Short) {
                    return new IntSymbol(((Short)obj).intValue());
                }
            } else {
                if (type.equals((Object)TypeReference.Char)) {
                    return new CharSymbol((char)num.intValue());
                }
                if (type.equals((Object)TypeReference.Boolean)) {
                    return new BooleanSymbol(num.intValue() != 0);
                }
                if (type.equals((Object)TypeReference.Long)) {
                    return new IntSymbol(num.longValue());
                }
                if (type.equals((Object)TypeReference.Int)) {
                    return new IntSymbol(num.intValue());
                }
                if (type.equals((Object)TypeReference.Short)) {
                    return new IntSymbol(num.intValue());
                }
                if (type.equals((Object)TypeReference.Byte)) {
                    return new CharSymbol((char)num.intValue());
                }
                if (type.equals((Object)TypeReference.Double)) {
                    return new RealSymbol(num.doubleValue());
                }
                if (type.equals((Object)TypeReference.Float)) {
                    return new RealSymbol(num.floatValue());
                }
                if (obj instanceof Float) {
                    return new RealSymbol((Float)obj);
                }
                if (obj instanceof Double) {
                    return new RealSymbol((Double)obj);
                }
                if (obj instanceof Integer) {
                    return new IntSymbol((Integer)obj);
                }
                if (obj instanceof Long) {
                    return new IntSymbol((Long)obj);
                }
                if (obj instanceof Byte) {
                    return new CharSymbol(((Byte)obj).byteValue());
                }
                if (obj instanceof Short) {
                    return new IntSymbol(((Short)obj).intValue());
                }
            }
            if ((s = num.toString()).contains(".")) {
                return new RealSymbol(Double.parseDouble(s));
            }
            return new IntSymbol(Long.parseLong(s));
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return new BooleanSymbol(bool.booleanValue());
        }
        if (obj instanceof IClass) {
            IClass klass = (IClass)obj;
            return new ClassSymbol(klass);
        }
        if (obj instanceof TypeReference) {
            TypeReference ty = (TypeReference)obj;
            return new ClassSymbol(ty);
        }
        if (obj instanceof InstanceKey) {
            InstanceKey ikey = (InstanceKey)obj;
            return new InstanceKeyVariable(ikey);
        }
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("unsupported type of the constant: " + obj.getClass()));
        }
        return null;
    }

    protected ISymbol getSymbol(String s) {
        return new Symbol(s);
    }

    protected Collection<List<ISymbol>> getValueSymbols(int[] v, SSAInstruction instruction, TranslationContext ctx) {
        ArrayList<Collection<ISymbol>> l = new ArrayList<Collection<ISymbol>>();
        for (int i = 0; i < v.length; ++i) {
            Collection<ISymbol> syms = this.createValueSymbol(v[i], instruction, ctx);
            l.add(syms);
        }
        return AUtil.combination1(l);
    }

    @Override
    public Collection<IVariable> createArrayElementVariable(int objv, int memv, SSAInstruction instruction, TranslationContext ctx) {
        TranslationContext newCtx = new TranslationContext(ctx.getIR(), ctx.getCGNode(), ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
        IVariable s1 = (IVariable)this.createValueSymbol(objv, instruction, newCtx);
        ISymbol s2 = (ISymbol)this.createValueSymbol(memv, instruction, newCtx);
        HashSet<IVariable> vars = new HashSet<IVariable>();
        vars.add(new MemberVariable((ISymbol)s1, s2));
        return vars;
    }

    protected MemberVariable getArrayElementVariable(int objv, SSAFieldAccessInstruction instruction, TranslationContext ctx) {
        TranslationContext newCtx = new TranslationContext(ctx.getIR(), ctx.getCGNode(), ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
        IVariable s1 = (IVariable)this.createValueSymbol(objv, (SSAInstruction)instruction, newCtx);
        FieldSymbol s2 = new FieldSymbol(instruction.getDeclaredField());
        return new MemberVariable((ISymbol)s1, (ISymbol)s2);
    }

    @Override
    public Collection<IVariable> createMemberVariable(int objv, int memv, SSAInstruction instruction, TranslationContext ctx) {
        TranslationContext newCtx = new TranslationContext(ctx.getIR(), ctx.getCGNode(), ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
        Collection<ISymbol> objs = null;
        try {
            objs = this.createInstanceKeySymbol(objv, newCtx);
        }
        catch (ISymbolFactory.NoInstanceKeyException e) {
            objs = new HashSet<IVariable>(this.createCDVariable(objv, newCtx));
        }
        HashSet<IVariable> vars = new HashSet<IVariable>();
        ISymbol memSym = (ISymbol)this.createValueSymbol(memv, instruction, ctx);
        for (ISymbol obj : objs) {
            MemberVariable v = new MemberVariable((ISymbol)((IVariable)obj), memSym);
            vars.add(v);
        }
        return vars;
    }

    @Override
    public Collection<IVariable> createMemberVariable(int objv, SSAFieldAccessInstruction instruction, TranslationContext ctx) {
        TranslationContext newCtx = new TranslationContext(ctx.getIR(), ctx.getCGNode(), ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger());
        Collection<ISymbol> objs = null;
        try {
            objs = this.createInstanceKeySymbol(objv, newCtx);
        }
        catch (ISymbolFactory.NoInstanceKeyException e) {
            objs = new HashSet<IVariable>(this.createCDVariable(objv, newCtx));
        }
        HashSet<IVariable> vars = new HashSet<IVariable>();
        FieldSymbol memSym = new FieldSymbol(instruction.getDeclaredField().getName().toString());
        if (objs.isEmpty()) {
            objs.addAll(this.createCDVariable(objv, newCtx));
        }
        for (ISymbol obj : objs) {
            MemberVariable v = new MemberVariable(obj, (ISymbol)memSym);
            vars.add(v);
        }
        return vars;
    }

    @Override
    public Collection<IVariable> createStaticMemberVariable(TypeReference type, SSAFieldAccessInstruction instruction, TranslationContext ctx) {
        ClassSymbol s1 = new ClassSymbol(type);
        FieldSymbol s2 = new FieldSymbol(instruction.getDeclaredField());
        return Collections.singleton(new MemberVariable((ISymbol)s1, (ISymbol)s2));
    }

    protected MemberVariable getStaticMemberVariable(TypeReference type, int memv, SSAInstruction instruction, TranslationContext ctx) {
        ClassSymbol s1 = new ClassSymbol(type);
        ISymbol s2 = (ISymbol)this.createValueSymbol(memv, instruction, ctx);
        return new MemberVariable((ISymbol)s1, s2);
    }

    @Override
    public Collection<InvocationSymbol> createInvocationSymbol(SSAAbstractInvokeInstruction instruction, TranslationContext ctx) {
        int recv = this.repository.getReceiver(instruction, ctx);
        Set<String> signatures = this.repository.getSignature(instruction, ctx);
        int[] params = this.repository.getParams(instruction, ctx);
        HashSet<InvocationSymbol> syms = new HashSet<InvocationSymbol>();
        if (signatures.isEmpty()) {
            syms.addAll(this.createInvocationSymbol(null, recv, params, (SSAInstruction)instruction, ctx));
        } else {
            for (String signature : signatures) {
                syms.addAll(this.createInvocationSymbol(new SignatureSymbol(signature), recv, params, (SSAInstruction)instruction, ctx));
            }
        }
        return syms;
    }

    @Override
    public Collection<InvocationSymbol> createInvocationSymbol(SignatureSymbol f, int recv, int[] params, SSAInstruction instruction, TranslationContext ctx) {
        HashSet<InvocationSymbol> result = new HashSet<InvocationSymbol>();
        Collection<ISymbol> recvSyms = this.createValueSymbol(recv, instruction, ctx);
        if (recvSyms.isEmpty()) {
            for (List<ISymbol> lparam : this.getValueSymbols(params, instruction, ctx)) {
                InvocationSymbol isym = new InvocationSymbol(ctx.getCallGraph(), ctx.getCGNode(), instruction, f, null, lparam);
                result.add(isym);
            }
        } else {
            for (ISymbol recvSym : recvSyms) {
                for (List<ISymbol> lparam : this.getValueSymbols(params, instruction, ctx)) {
                    InvocationSymbol isym = new InvocationSymbol(ctx.getCallGraph(), ctx.getCGNode(), instruction, f, recvSym, lparam);
                    result.add(isym);
                }
            }
        }
        return result;
    }

    protected String getOperatorName(IBinaryOpInstruction.IOperator opCode) {
        return opCode.toString();
    }

    @Override
    public Collection<ISymbol> createOpSymbol(IBinaryOpInstruction.IOperator opCode, int[] params, SSABinaryOpInstruction instruction, TranslationContext ctx) {
        HashSet<ISymbol> result = new HashSet<ISymbol>();
        SignatureSymbol op = new SignatureSymbol("op(" + this.getOperatorName(opCode) + ")");
        for (List<ISymbol> lparam : this.getValueSymbols(params, (SSAInstruction)instruction, ctx)) {
            InvocationSymbol isym = new InvocationSymbol(ctx.getCallGraph(), ctx.getCGNode(), (SSAInstruction)instruction, op, null, lparam);
            result.add(isym);
        }
        return result;
    }
}

