/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class IR2Grammar<T>
implements IIR2Grammar<T> {
    IBB2Grammar<T> bb2gr = null;

    public IR2Grammar(IBB2Grammar<T> bb2gr) {
        this.bb2gr = bb2gr;
    }

    @Override
    public GR translate(TranslationContext ctx) {
        HashSet<GRule> rules = new HashSet<GRule>();
        IR ir = ctx.getIR();
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("IR2Grammar.translate(): " + ir.getMethod().getSignature()));
            SAUtil.println((Object)"invoking IR2GR#translate with a IR:");
            SAUtil.println((Object)ir);
        }
        SSACFG cfg = ir.getControlFlowGraph();
        Iterator i = cfg.iterator();
        while (i.hasNext()) {
            if (ctx.getProgressMonitor().isCanceled()) {
                throw CancelRuntimeException.make((String)"during PCA");
            }
            ISSABasicBlock bb = (ISSABasicBlock)i.next();
            GR bgr = this.bb2gr.translate(bb, ctx);
            if (bgr == null) {
                Assertions.UNREACHABLE((String)("bgr is null against: " + bb));
            }
            rules.addAll(bgr.getGRules());
        }
        this.addConstantDefinitions(rules, ctx);
        GR gr = new GR(ir, rules);
        gr = this.bb2gr.getSSA2Rule().postTranslate(gr);
        if (SAUtil.DEBUG) {
            if (gr.getRules().size() < 10000) {
                SAUtil.println((Object)("IR2Grammar.translate() result: " + gr.toString()));
            } else {
                SAUtil.println((Object)("IR2Grammar.translate() result: too big grammar: #rules = " + gr.getRules().size()));
            }
        }
        return gr;
    }

    private void addConstantDefinitions(Collection<GRule> rules, TranslationContext ctx) {
        IR ir = ctx.getIR();
        SymbolTable tbl = ir.getSymbolTable();
        Iterator i = ir.iterateAllInstructions();
        while (i.hasNext()) {
            SSAInstruction inst = (SSAInstruction)i.next();
            for (int j = 0; j < inst.getNumberOfUses(); ++j) {
                int v = inst.getUse(j);
                if (v < 0 || !tbl.isConstant(v)) continue;
                for (ISymbol s : this.bb2gr.getSSA2Rule().getSymbolFactory().createValueSymbol(v, inst, ctx)) {
                    for (IVariable var : this.bb2gr.getSSA2Rule().getSymbolFactory().createCDVariable(v, ctx)) {
                        GRule r = new GRule(ir, inst, var, s);
                        rules.add(r);
                    }
                }
            }
        }
    }

    @Override
    public IBB2Grammar<T> getBB2Grammar() {
        return this.bb2gr;
    }
}

