/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.DeepSymbolCopier;
import com.ibm.wala.automaton.string.IEnumerableValueSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.LabeledSymbol;
import com.ibm.wala.automaton.string.Labeling;
import com.ibm.wala.automaton.string.SetSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.translator.BasicSymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LabeledSymbolFactory<T>
extends BasicSymbolFactory<T> {
    Map<InstanceKey, Set<LocalPointerKey>> lpkeyCache = null;

    public LabeledSymbolFactory(ITranslatorRepository<T> repository, IVariableFactory<IVariable> varFactory, PointerAnalysis<InstanceKey> pa) {
        super(repository, varFactory);
        this.initLPKeyCache(pa);
    }

    @Override
    public Collection<ISymbol> createValueSymbol(int v, SSAInstruction instruction, TranslationContext ctx) {
        HashSet<ISymbol> result = new HashSet<ISymbol>();
        for (ISymbol s : super.createValueSymbol(v, instruction, ctx)) {
            CGNode node = ctx.getCGNode();
            if (s == null) continue;
            ISymbol t = s.copy((ISymbolCopier)new LabelingSymbolCopier(new LabelElement(ctx.getCallGraph(), node, instruction, v)));
            result.add(t);
        }
        return result;
    }

    protected void initLPKeyCache(PointerAnalysis<InstanceKey> pa) {
        System.err.println("initLPKeyCache()");
        this.lpkeyCache = new HashMap<InstanceKey, Set<LocalPointerKey>>();
        for (PointerKey pkey : pa.getPointerKeys()) {
            String loaderName;
            LocalPointerKey lpkey;
            CGNode node;
            if (!(pkey instanceof LocalPointerKey) || (node = (lpkey = (LocalPointerKey)pkey).getNode()) == null || (loaderName = node.getMethod().getDeclaringClass().getClassLoader().getName().toString()).equals("Primordial")) continue;
            for (InstanceKey ikey : pa.getPointsToSet((PointerKey)lpkey)) {
                Set<LocalPointerKey> lpkeys = this.lpkeyCache.get(ikey);
                if (lpkeys == null) {
                    lpkeys = new HashSet<LocalPointerKey>();
                    this.lpkeyCache.put(ikey, lpkeys);
                }
                lpkeys.add(lpkey);
            }
        }
        System.err.println("end of initLPKeyCache()");
    }

    @Override
    protected Collection<ISymbol> getInstanceKeySymbol(InstanceKey ikey, TranslationContext ctx) {
        ILabelSymbol label = ILabelSymbol.BOTTOM;
        Collection<ISymbol> ss = super.getInstanceKeySymbol(ikey, ctx);
        if (!(ikey instanceof ConstantKey)) {
            return ss;
        }
        Set<LocalPointerKey> lpkeys = this.lpkeyCache.get(ikey);
        for (LocalPointerKey lpkey : lpkeys) {
            CGNode node = lpkey.getNode();
            int vn = lpkey.getValueNumber();
            SSAInstruction instruction = node.getDU().getDef(vn);
            label = label.meet((ILabelSymbol)new SetSymbol((Object)new LabelElement(ctx.getCallGraph(), node, instruction, vn)));
        }
        HashSet<ISymbol> result = new HashSet<ISymbol>();
        Labeling labeling = new Labeling(label);
        for (ISymbol s : ss) {
            result.add(s.copy((ISymbolCopier)labeling));
        }
        return result;
    }

    private static class LabelingSymbolCopier
    extends DeepSymbolCopier {
        private LabelElement label;

        public LabelingSymbolCopier(LabelElement label) {
            this.label = label;
        }

        public ISymbol copy(ISymbol symbol) {
            if (symbol instanceof StringSymbol) {
                return new LabeledSymbol((IEnumerableValueSymbol)((StringSymbol)symbol), (ILabelSymbol)new SetSymbol((Object)this.label));
            }
            if (symbol instanceof CharSymbol) {
                return new LabeledSymbol((IEnumerableValueSymbol)((CharSymbol)symbol), (ILabelSymbol)new SetSymbol((Object)this.label));
            }
            return super.copy(symbol);
        }
    }

    public static class LabelElement {
        private CallGraph cg;
        private CGNode node;
        private SSAInstruction instruction;
        private int valueNumber;
        private int hashCode = 0;

        public LabelElement(CallGraph cg, CGNode node, SSAInstruction instruction, int valueNumber) {
            this.cg = cg;
            this.node = node;
            this.instruction = instruction;
            this.valueNumber = valueNumber;
        }

        public CallGraph getCallGraph() {
            return this.cg;
        }

        public CGNode getCGNode() {
            return this.node;
        }

        public SSAInstruction getInstruction() {
            return this.instruction;
        }

        public int getValueNumber() {
            return this.valueNumber;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 1 + this.valueNumber + (this.instruction == null ? 0 : this.instruction.hashCode()) * 19 + (this.node == null ? 0 : this.node.hashCode()) * 23 + this.cg.hashCode() * 29;
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LabelElement) {
                LabelElement l = (LabelElement)obj;
                return this.valueNumber == l.valueNumber && (this.instruction == null ? l.instruction == null : this.instruction.equals((Object)l.instruction)) && (this.node == null ? l.node == null : this.node.equals(l.node)) && this.cg.equals(l.cg);
            }
            return false;
        }

        public String toString() {
            return "v=" + this.valueNumber + ",node=" + (this.node == null ? -1 : this.node.getGraphNodeId());
        }
    }
}

