/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.PathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.PropagatingPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.grammar.BBVariable;
import com.ibm.wala.stringAnalysis.grammar.CDVariable;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.IR2GRFilter;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelRuntimeException;
import java.util.HashMap;
import java.util.Iterator;

public class PathSensitiveIR2GR<T>
implements IIR2Grammar<T> {
    private static final boolean USE_NEW_PCA = "true".equalsIgnoreCase(System.getProperty("com.ibm.wala.sa.newPca", "false"));
    private final IIR2Grammar<T> base;
    private final boolean useNewPCA;

    public PathSensitiveIR2GR(IIR2Grammar<T> base) {
        this(base, USE_NEW_PCA);
    }

    public PathSensitiveIR2GR(IIR2Grammar<T> base, boolean useNewPCA) {
        this.base = base;
        this.useNewPCA = useNewPCA;
    }

    @Override
    public IBB2Grammar<T> getBB2Grammar() {
        return this.base.getBB2Grammar();
    }

    protected boolean accept(TranslationContext ctx) {
        if (this.base instanceof IR2GRFilter) {
            return ((IR2GRFilter)this.base).accept(ctx);
        }
        return true;
    }

    private boolean isBooleanMethod(SSAInstruction instr) {
        if (instr instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instr;
            return invoke.getDeclaredResultType().equals((Object)TypeReference.Boolean);
        }
        return false;
    }

    @Override
    public GR translate(TranslationContext ctx) {
        if (ctx.getProgressMonitor().isCanceled()) {
            throw CancelRuntimeException.make((String)"during translation");
        }
        if (this.accept(ctx)) {
            IPathConditionAnalysis pca = this.useNewPCA ? new PropagatingPathConditionAnalysis(ctx.getIR(), ctx.getProgressMonitor()) : new PathConditionAnalysis(ctx.getIR(), ctx.getProgressMonitor());
            TranslationContext newCtx = new TranslationContext(ctx.getIR(), ctx.getCGNode(), ctx.getCallGraph(), ctx.getPointerAnalysis(), ctx.getTypeInference(), pca, ctx.getProgressMonitor(), ctx.getLogger());
            GR gr = this.base.translate(newCtx);
            gr = this.managePiInstructions(gr, ctx);
            return gr;
        }
        return this.base.translate(ctx);
    }

    private GR managePiInstructions(GR gr, TranslationContext ctx) {
        HashMap<IVariable, ISymbol> replace = new HashMap<IVariable, ISymbol>();
        Iterator<IProductionRule> i = gr.getRules().iterator();
        while (i.hasNext()) {
            SSAPiInstruction pi;
            ISymbol s;
            GRule r = (GRule)i.next();
            SSAInstruction instruction = r.getSSAInstruction();
            if (instruction instanceof SSAPiInstruction) {
                SSAPiInstruction pi2 = (SSAPiInstruction)instruction;
                if (!this.isBooleanMethod(pi2.getCause())) continue;
                replace.put(r.getLeft(), r.getRight(0));
                continue;
            }
            if (!(instruction instanceof SSAPhiInstruction) || !((s = r.getRight(0)) instanceof CDVariable) || s instanceof BBVariable) continue;
            CDVariable v = (CDVariable)s;
            SSAInstruction defInstr = ctx.getDefUse().getDef(v.getValueNumber());
            if (!(defInstr instanceof SSAPiInstruction) || !this.isBooleanMethod((pi = (SSAPiInstruction)defInstr).getCause())) continue;
            i.remove();
        }
        gr = (GR)gr.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer(replace)){

            public IVariable copyLeft(IVariable v) {
                return v;
            }
        }));
        return gr;
    }
}

