/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.IInvocationSymbolComposer;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ReceiverBasedComposer<T>
implements IInvocationSymbolComposer<T> {
    private final Collection<String> signatures;

    public ReceiverBasedComposer(Collection<String> signatures) {
        this.signatures = signatures;
    }

    @Override
    public Collection<InvocationSymbol> compose(String signature, SSAAbstractInvokeInstruction instruction, ISymbolFactory<T> sf, TranslationContext ctx) {
        int recv = instruction.getReceiver();
        ITranslatorRepository<T> repository = sf.getRepository();
        Iterator iter = ctx.getDefUse().getUses(instruction.getUse(recv));
        HashSet<InvocationSymbol> invokeSymbols = new HashSet<InvocationSymbol>();
        while (iter.hasNext()) {
            SSAInstruction cinst = (SSAInstruction)iter.next();
            if (!(cinst instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction invokeInst = (SSAAbstractInvokeInstruction)cinst;
            if (cinst == instruction || invokeInst.getReceiver() != recv) continue;
            Set<String> sigs2 = repository.getSignature(invokeInst, ctx);
            for (String sig2 : sigs2) {
                int i;
                if (!this.signatures.contains(sig2)) continue;
                String csig = signature + sig2;
                int[] params1 = repository.getParams(instruction, ctx);
                int[] params2 = repository.getParams(invokeInst, ctx);
                int[] params3 = new int[params1.length + params2.length];
                int n = 0;
                for (i = 0; i < params1.length; ++i) {
                    params3[n] = params1[i];
                    ++n;
                }
                for (i = 0; i < params2.length; ++i) {
                    params3[n] = params2[i];
                    ++n;
                }
                Collection<InvocationSymbol> r = sf.createInvocationSymbol(new SignatureSymbol(csig), instruction.getReceiver(), params3, (SSAInstruction)instruction, ctx);
                invokeSymbols.addAll(r);
            }
        }
        return invokeSymbols;
    }
}

