/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.stringAnalysis.callgraph.InterReachingDefs;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.util.LocalNameTable;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.debug.Assertions;
import org.apache.log4j.Logger;

public class TranslationContext
implements Cloneable {
    private final IR ir;
    private final CGNode node;
    private final CallGraph callGraph;
    private final PointerAnalysis pointerAnalysis;
    private final TypeInference typeInference;
    private final IPathConditionAnalysis pathCondition;
    private final MonitorUtil.IProgressMonitor progressMonitor;
    private final SSAInstructionFactory instructionFactory;
    private final Logger logger;
    private LocalNameTable ltable;
    private DefUse du;
    private InterReachingDefs ird = null;

    public TranslationContext(IR ir, CGNode node, CallGraph callGraph, PointerAnalysis pointerAnalysis, TypeInference typeInference, IPathConditionAnalysis pathCondition, MonitorUtil.IProgressMonitor progressMonitor, Logger logger) {
        assert (ir != null) : node;
        this.ir = ir;
        this.node = node;
        this.callGraph = callGraph;
        assert (callGraph != null);
        this.pointerAnalysis = pointerAnalysis;
        this.typeInference = typeInference;
        this.pathCondition = pathCondition;
        this.progressMonitor = progressMonitor == null ? SAUtil.nullProgressMonitor : progressMonitor;
        this.ltable = null;
        this.du = null;
        this.logger = logger;
        this.instructionFactory = ir.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory();
    }

    public TranslationContext(IR ir, CGNode node, CallGraph callGraph, PointerAnalysis pointerAnalysis, TypeInference typeInference, IPathConditionAnalysis pathCondition, Logger logger) {
        this(ir, node, callGraph, pointerAnalysis, typeInference, pathCondition, null, logger);
    }

    public TranslationContext(TranslationContext ctx) {
        this(ctx.ir, ctx.node, ctx.callGraph, ctx.pointerAnalysis, ctx.typeInference, ctx.pathCondition, ctx.progressMonitor, ctx.logger);
        this.ird = ctx.ird;
    }

    public IR getIR() {
        return this.ir;
    }

    public DefUse getDefUse() {
        if (this.du == null) {
            this.du = new DefUse(this.getIR());
        }
        return this.du;
    }

    public InterReachingDefs getReachingDefs() {
        if (this.ird == null) {
            this.ird = new InterReachingDefs(this.callGraph);
        }
        return this.ird;
    }

    public CGNode getCGNode() {
        return this.node;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    public LocalNameTable getLocalNameTable() {
        if (this.ltable == null) {
            this.ltable = new LocalNameTable(this.getIR());
        }
        return this.ltable;
    }

    public TypeInference getTypeInference() {
        return this.typeInference;
    }

    public IPathConditionAnalysis getPathConditionAnalysis() {
        return this.pathCondition;
    }

    public MonitorUtil.IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SSAInstructionFactory getInstructionFactory() {
        return this.instructionFactory;
    }
}

