/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg;

import com.ibm.wala.automaton.grammar.string.CFLReachability;
import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.SimpleConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Transducer;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CFGConstraintSolver
extends SimpleConstraintSolver<IContextFreeGrammar> {
    public CFGConstraintSolver(ITranslatorRepository<IContextFreeGrammar> translators, ISolverCache<IContextFreeGrammar> cache, ISolverStack stack, MonitorUtil.IProgressMonitor monitor) {
        super(translators, cache, stack, monitor);
    }

    protected IContextFreeGrammar approximatePrecisely(IContextFreeGrammar cfg) {
        return Grammars.toRegularGrammar((IContextFreeGrammar)cfg, (IVariableFactory)this.varFactory);
    }

    protected IContextFreeGrammar approximateRoughly(IContextFreeGrammar target) {
        return this.possibleGrammar(target);
    }

    protected IContextFreeGrammar possibleGrammar(IContextFreeGrammar g) {
        return this.possibleStrings(g, true);
    }

    protected IContextFreeGrammar possibleStrings(IContextFreeGrammar g, boolean allowEmpty) {
        Collection c = Grammars.collectTerminals((IGrammar[])new IGrammar[]{g});
        c = RangeSymbol.mergeSymbols((Collection)c);
        return this.possibleStrings(c, allowEmpty);
    }

    protected IContextFreeGrammar possibleStrings(Collection<? extends ISymbol> terminals, boolean allowEmpty) {
        IVariable start = this.varFactory.createVariable(Grammars.variablePrefix);
        IVariable v0 = this.varFactory.createVariable(Grammars.variablePrefix);
        HashSet<ProductionRule> rules = new HashSet<ProductionRule>();
        rules.add(new ProductionRule(start, (ISymbol)v0));
        if (allowEmpty) {
            rules.add(new ProductionRule(v0, new ISymbol[0]));
        } else {
            for (ISymbol iSymbol : terminals) {
                rules.add(new ProductionRule(v0, new ISymbol[]{iSymbol}));
            }
        }
        for (ISymbol iSymbol : terminals) {
            rules.add(new ProductionRule(v0, new ISymbol[]{iSymbol, v0}));
        }
        if (rules.isEmpty()) {
            rules.add(new ProductionRule(start, new ISymbol[0]));
        }
        ContextFreeGrammar g = new ContextFreeGrammar(start, rules);
        return g;
    }

    @Override
    protected IContextFreeGrammar approximate(IContextFreeGrammar target, int cycle) {
        if (cycle >= this.WIDENING_THRESHOLD) {
            return this.approximateRoughly(target);
        }
        return this.approximatePrecisely(target);
    }

    @Override
    protected boolean contains(IContextFreeGrammar g1, IContextFreeGrammar g2) {
        IAutomaton fst1 = Grammars.toAutomaton((IContextFreeGrammar)g1);
        fst1 = Automatons.minimize((IAutomaton)fst1);
        if (Transducer.USE_REGULAR_APPROXIMATION) {
            IAutomaton fst2 = Grammars.toAutomaton((IContextFreeGrammar)g2);
            fst2 = Automatons.minimize((IAutomaton)fst2);
            return Automatons.containsAll((IAutomaton)fst1, (IAutomaton)fst2);
        }
        return CFLReachability.containsAll((IAutomaton)fst1, (IContextFreeGrammar)g2, (MonitorUtil.IProgressMonitor)this.monitor);
    }

    @Override
    protected IContextFreeGrammar composeResult(SimpleGrammar g) {
        ContextFreeGrammar cfg = new ContextFreeGrammar(g);
        return cfg;
    }

    @Override
    protected IContextFreeGrammar composeResult(IValueSymbol val) {
        return val.getGrammar();
    }

    @Override
    protected IContextFreeGrammar composeResult(ILanguageSymbol<?> val) {
        IContextFreeGrammar cfg = (IContextFreeGrammar)val.getLanguage();
        return cfg;
    }

    @Override
    protected IContextFreeGrammar composeResults(Collection<IContextFreeGrammar> cfgs) {
        IContextFreeGrammar result = Grammars.createUnion(cfgs);
        return result;
    }

    @Override
    protected IContextFreeGrammar concatResults(List<IContextFreeGrammar> cfgs) {
        IContextFreeGrammar result = Grammars.createConcatenation(cfgs);
        return result;
    }

    @Override
    protected IContextFreeGrammar createAny() {
        return Grammars.createAny((IVariableFactory)this.varFactory);
    }

    @Override
    protected IContextFreeGrammar createEmpty() {
        ContextFreeGrammar e = new ContextFreeGrammar(this.varFactory.createVariable(Grammars.variablePrefix), Collections.emptySet());
        return e;
    }

    @Override
    protected SimpleGrammar composeGrammar(IContextFreeGrammar r) {
        return r.toSimple();
    }

    @Override
    protected IContextFreeGrammar substitute(IContextFreeGrammar g) {
        g = CFGConstraintSolver.substituteGrammars(g, (IVariableFactory<IVariable>)new FreshVariableFactory((IGrammar)g));
        return g;
    }

    @Override
    protected IContextFreeGrammar minimize(IContextFreeGrammar g) {
        IContextFreeGrammar r;
        Grammars.eliminateUselessRules((IGrammar)g);
        if (this.CHARSET_APPROXIMATION_THRESHOLD > 0 && g.getRules().size() > this.CHARSET_APPROXIMATION_THRESHOLD) {
            r = this.possibleStrings(g, true);
        } else {
            Grammars.eliminateReflectiveRules((IGrammar)g);
            r = (IContextFreeGrammar)Grammars.minimize((IGrammar)g);
        }
        return r;
    }
}

