/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.SingletonGrammar;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringTranslator;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Transducer;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public class IntersectionOp
extends StringTranslator {
    @Override
    public IContextFreeGrammar translate(IContextFreeGrammar g) throws TranslationException {
        if (Transducer.USE_REGULAR_APPROXIMATION) {
            IContextFreeGrammar g1 = this.translateAsRegular(g);
            return g1;
        }
        IContextFreeGrammar g2 = this.translateAsCFG(g);
        return g2;
    }

    protected IContextFreeGrammar translateAsRegular(IContextFreeGrammar g) throws TranslationException {
        IAutomaton a1 = Grammars.toAutomaton((IContextFreeGrammar)g);
        IAutomaton a1m = Automatons.minimize((IAutomaton)a1);
        ISymbol param0 = (ISymbol)this.params.get(0);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("calculate intersection of: the following automaton and " + param0));
            SAUtil.println((Object)a1m);
        }
        if (param0 instanceof CharSymbol) {
            return new SingletonGrammar(g.getStartSymbol(), (IValueSymbol)((CharSymbol)param0));
        }
        if (param0 instanceof RangeSymbol) {
            Automaton a2 = Automatons.createAutomaton((ISymbol[])new ISymbol[]{param0});
            IAutomaton a2m = Automatons.minimize((IAutomaton)a2);
            IAutomaton result = Automatons.createIntersection((IAutomaton)a1m, (IAutomaton)a2m);
            return Grammars.toCFG((IAutomaton)result);
        }
        if (param0 instanceof IVariable) {
            IGrammar pg = (IGrammar)this.solveParameter(0).getLanguage();
            ContextFreeGrammar cfg2 = new ContextFreeGrammar(pg.getStartSymbol(), (Collection)pg.getRules());
            IContextFreeGrammar cfg2m = (IContextFreeGrammar)Grammars.minimize((IGrammar)cfg2);
            IAutomaton a2m = Grammars.toAutomaton((IContextFreeGrammar)cfg2m);
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)("original automaton: " + cfg2m));
                SAUtil.println((Object)("regular approximated grammar: " + a2m));
            }
            IAutomaton result = Automatons.createIntersection((IAutomaton)a1m, (IAutomaton)a2m);
            return Grammars.toCFG((IAutomaton)result);
        }
        Assertions.UNREACHABLE();
        return null;
    }

    protected IContextFreeGrammar translateAsCFG(IContextFreeGrammar g) throws TranslationException {
        ISymbol param0 = (ISymbol)this.params.get(0);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("calculate intersection of: the following grammar and " + param0));
            SAUtil.println((Object)g);
        }
        if (param0 instanceof CharSymbol) {
            return new SingletonGrammar(g.getStartSymbol(), (IValueSymbol)((CharSymbol)param0));
        }
        if (param0 instanceof RangeSymbol) {
            Automaton fst2 = Automatons.createAutomaton((ISymbol[])new ISymbol[]{param0});
            IContextFreeGrammar result = Grammars.createIntersection((IContextFreeGrammar)g, (IAutomaton)fst2, (IVariableFactory)this.varFactory, (MonitorUtil.IProgressMonitor)this.monitor);
            return result;
        }
        if (param0 instanceof IVariable) {
            IGrammar pg = (IGrammar)this.solveParameter(0).getLanguage();
            ContextFreeGrammar cfg2 = new ContextFreeGrammar(pg.getStartSymbol(), (Collection)pg.getRules());
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)("original grammar: " + cfg2));
            }
            IAutomaton fst2 = Grammars.toAutomaton((IContextFreeGrammar)cfg2);
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)("regular approximated grammar: " + fst2));
            }
            g = (IContextFreeGrammar)Grammars.minimize((IGrammar)g);
            fst2 = Automatons.minimize((IAutomaton)fst2);
            IContextFreeGrammar result = Grammars.createIntersection((IContextFreeGrammar)g, (IAutomaton)fst2, (IVariableFactory)this.varFactory, (MonitorUtil.IProgressMonitor)this.monitor);
            return result;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean acceptCyclic() {
        return false;
    }
}

