/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.MappingElement;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.CharTranslator;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Homomorphism;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JavaBridge
extends CharTranslator {
    private Map<RangeSymbol, ISymbol> mapping;
    private Class<?> klass;
    private Method method;
    private Object object;
    private Collection<ISymbol> terminals;

    public JavaBridge(int target, ClassLoader loader, String className, String methodName, Object ... args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        super(target);
        this.mapping = this.getMapping(loader, className, methodName, args);
        this.terminals = new HashSet<RangeSymbol>(this.mapping.keySet());
    }

    private Map<RangeSymbol, ISymbol> getMapping(ClassLoader loader, String className, String methodName, Object ... args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.method = this.getMethod(loader, className, methodName);
        this.method.setAccessible(true);
        return this.createMapping(args);
    }

    private Map<RangeSymbol, ISymbol> createMapping(Object ... args) throws IllegalAccessException, InvocationTargetException {
        HashSet<MappingElement> elems = new HashSet<MappingElement>();
        for (byte b = 0; b < 127; b = (byte)((byte)(b + 1))) {
            String s = new String(new byte[]{b});
            CharSequence r = null;
            args[this.target] = s;
            r = (CharSequence)this.method.invoke(this.object, args);
            MappingElement elem = null;
            elem = r.length() == 1 ? new MappingElement(Character.valueOf((char)b), Character.valueOf(r.charAt(0))) : new MappingElement((IEnumerableSymbol)new CharSymbol((char)b), (IEnumerableSymbol)new StringSymbol(r.toString()));
            elems.add(elem);
        }
        return MappingElement.createApproximatedMapping(elems);
    }

    private Method getMethod(ClassLoader loader, String className, String methodName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            this.klass = Class.forName(className, true, loader);
        }
        catch (ExceptionInInitializerError e) {
            e.getCause().printStackTrace();
        }
        try {
            this.object = this.klass.newInstance();
        }
        catch (ExceptionInInitializerError e) {
            e.getCause().printStackTrace();
        }
        return this.getMethod(loader, this.klass, className, methodName);
    }

    private Method getMethod(ClassLoader loader, Class<?> klass, String className, String methodName) throws ClassNotFoundException {
        if (klass == null) {
            throw new ClassNotFoundException(className);
        }
        Method[] methods = klass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || !JavaBridge.isHomomorphism(methods[i])) continue;
            return methods[i];
        }
        return this.getMethod(loader, klass.getSuperclass(), klass.getSuperclass().getName(), methodName);
    }

    private static boolean isHomomorphism(Method m) {
        if (CharSequence.class.isAssignableFrom(m.getReturnType())) {
            Class<?>[] klass = m.getParameterTypes();
            if (klass.length == 0 && CharSequence.class.isAssignableFrom(m.getDeclaringClass())) {
                return true;
            }
            if (klass.length == 1 && CharSequence.class.isAssignableFrom(klass[0])) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Collection<ISymbol> getTerminals(Collection<Homomorphism.Rule> ruleSet) {
        return this.terminals;
    }

    @Override
    protected ISymbol translate(char c) {
        CharSymbol s = new CharSymbol(c);
        for (Map.Entry<RangeSymbol, ISymbol> entry : this.mapping.entrySet()) {
            if (!entry.getKey().contains((IEnumerableSymbol)s)) continue;
            return entry.getValue();
        }
        return new CharSymbol(c);
    }

    @Override
    protected List<ISymbol> translate(RangeSymbol range) {
        for (Map.Entry<RangeSymbol, ISymbol> entry : this.mapping.entrySet()) {
            if (!entry.getKey().contains(range)) continue;
            return Arrays.asList(entry.getValue());
        }
        return Arrays.asList(range);
    }
}

