/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Transducer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Strireplace
extends Transducer {
    private int repStrIndex;
    private int searchStrIndex;

    public Strireplace(int target, int search, int replace) {
        super(target);
        this.repStrIndex = replace;
        this.searchStrIndex = search;
    }

    public Strireplace(int search, int replace) {
        this.repStrIndex = replace;
        this.searchStrIndex = search;
    }

    @Override
    public IAutomaton createTransducer() {
        State s0;
        Variable v = new Variable("v");
        List repStrList = ((StringSymbol)this.solveParameter(this.repStrIndex)).toCharSymbols();
        List searchStrList = ((StringSymbol)this.solveParameter(this.searchStrIndex)).toCharSymbols();
        CharSymbol[] repChars = repStrList.toArray(new CharSymbol[0]);
        final CharSymbol[] searchChars = searchStrList.toArray(new CharSymbol[0]);
        HashSet<FilteredTransition> transitions = new HashSet<FilteredTransition>();
        State initState = s0 = new State("s0");
        HashSet<State> finalStates = new HashSet<State>();
        finalStates.add(s0);
        FilteredTransition t0 = new FilteredTransition((IState)s0, (IState)s0, (ISymbol)v, new ISymbol[]{v}, null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                boolean r;
                boolean bl = r = !Strireplace.this.isEquals(symbol, searchChars[0]);
                if (r) {
                    System.err.println("(in filtered transition: accept " + symbol + ")");
                }
                return r;
            }
        });
        transitions.add(t0);
        State state = s0;
        State searchFirstState = new State("s1");
        final CharSymbol searchFirstChar = searchChars[0];
        final int searchCharsLen = searchChars.length;
        for (int i = 0; i < searchCharsLen - 1; ++i) {
            State nextState = new State("s" + (i + 1));
            if (i == 0) {
                nextState = searchFirstState;
            }
            final CharSymbol searchChar = searchChars[i];
            final CharSymbol nextSearchChar = searchChars[i + 1];
            final int index = i;
            FilteredTransition ta = new FilteredTransition((IState)state, (IState)nextState, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = Strireplace.this.isEquals(symbol, searchChar);
                    if (r) {
                        System.err.println("(in filtered transition: accept " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(ta);
            List<CharSymbol[]> subSearchCharSymsList = this.generateCharSymsList(searchChars, index);
            for (final CharSymbol[] subSearchChars : subSearchCharSymsList) {
                FilteredTransition tb = new FilteredTransition((IState)nextState, (IState)s0, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

                    public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                        ArrayList<ISymbol> newOutputs = new ArrayList<ISymbol>();
                        for (int j = 0; j < index + 1; ++j) {
                            newOutputs.add((ISymbol)subSearchChars[j]);
                        }
                        newOutputs.add(symbol);
                        return newOutputs;
                    }
                }, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                    public boolean accept(ISymbol symbol, IMatchContext ctx) {
                        boolean r;
                        boolean bl = r = !Strireplace.this.isEquals(symbol, nextSearchChar) && !Strireplace.this.isEquals(symbol, searchFirstChar);
                        if (r) {
                            System.err.println("(in filtered transition: accept " + symbol + ")");
                        }
                        return r;
                    }
                });
                transitions.add(tb);
                FilteredTransition tc = new FilteredTransition((IState)nextState, (IState)searchFirstState, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

                    public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                        ArrayList<ISymbol> newOutputs = new ArrayList<ISymbol>();
                        for (int j = 0; j < index + 1; ++j) {
                            newOutputs.add((ISymbol)subSearchChars[j]);
                        }
                        return newOutputs;
                    }
                }, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                    public boolean accept(ISymbol symbol, IMatchContext ctx) {
                        boolean r;
                        boolean bl = r = !Strireplace.this.isEquals(symbol, nextSearchChar) && Strireplace.this.isEquals(symbol, searchFirstChar);
                        if (r) {
                            System.err.println("(in filtered transition: accept " + symbol + ")");
                        }
                        return r;
                    }
                });
                transitions.add(tc);
            }
            state = nextState;
            finalStates.add(state);
        }
        FilteredTransition t1 = new FilteredTransition((IState)state, (IState)s0, (ISymbol)v, (ISymbol[])repChars, null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                boolean r = Strireplace.this.isEquals(symbol, searchChars[searchCharsLen - 1]);
                if (r) {
                    System.err.println("(in filtered transition: accept " + symbol + ")");
                }
                return r;
            }
        });
        transitions.add(t1);
        Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
        return transducer;
    }

    private List<CharSymbol[]> generateCharSymsList(CharSymbol[] searchChars, int index) {
        ArrayList<CharSymbol> searchCharList = new ArrayList<CharSymbol>();
        for (int i = 0; i < index + 1; ++i) {
            searchCharList.add(searchChars[i]);
        }
        return this.getCharSymbolsList(searchCharList);
    }

    private List<CharSymbol[]> getCharSymbolsList(List<CharSymbol> searchCharList) {
        ArrayList<CharSymbol[]> charSymbolsList = new ArrayList<CharSymbol[]>();
        CharSymbol[] symbols = searchCharList.toArray(new CharSymbol[0]);
        for (int i = 0; i < (int)Math.pow(2.0, symbols.length); ++i) {
            CharSymbol[] result = new CharSymbol[symbols.length];
            int length = symbols.length;
            for (int index = 0; index < length; ++index) {
                char chr = (i & 1 << length - 1 - index) > 0 ? Character.toUpperCase(symbols[index].charValue()) : Character.toLowerCase(symbols[index].charValue());
                result[index] = new CharSymbol(chr);
            }
            charSymbolsList.add(result);
        }
        return charSymbolsList;
    }

    protected boolean isEquals(ISymbol symbol, CharSymbol searchChar) {
        CharSymbol uChar = new CharSymbol(Character.toUpperCase(searchChar.charValue()));
        CharSymbol lChar = new CharSymbol(Character.toLowerCase(searchChar.charValue()));
        return symbol.equals(uChar) || symbol.equals(lChar);
    }
}

