/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.concurrent;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.cfg.CFGConstraintSolver;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentConstraintSolver
extends CFGConstraintSolver {
    private final Server[] servers;

    public ConcurrentConstraintSolver(ITranslatorRepository<IContextFreeGrammar> translators, ISolverCache<IContextFreeGrammar> cache, ISolverStack stack, int nThread, MonitorUtil.IProgressMonitor monitor) {
        super(translators, cache, stack, monitor);
        this.servers = new Server[nThread];
    }

    @Override
    protected Map<IVariable, IContextFreeGrammar> solveInternal(SimpleGrammar g, Collection<? extends IVariable> startSymbols) {
        int i;
        ConcurrentLinkedQueue<IVariable> queue = new ConcurrentLinkedQueue<IVariable>(startSymbols);
        ConcurrentHashMap<IVariable, IContextFreeGrammar> result = new ConcurrentHashMap<IVariable, IContextFreeGrammar>();
        for (i = 0; i < this.servers.length; ++i) {
            this.servers[i] = new Server(g, queue, result);
            this.servers[i].start();
            if (!SAUtil.DEBUG) continue;
            SAUtil.println((Object)("Thread " + this.servers[i].getName() + " started."));
        }
        for (i = 0; i < this.servers.length; ++i) {
            try {
                this.servers[i].join();
                if (!SAUtil.DEBUG) continue;
                SAUtil.println((Object)("Thread " + this.servers[i].getName() + " joined."));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected class Server
    extends Thread {
        private final Queue<IVariable> startSymbols;
        private final SimpleGrammar G;
        private final Map<IVariable, IContextFreeGrammar> result;

        public Server(SimpleGrammar G, Queue<IVariable> startSymbols, Map<IVariable, IContextFreeGrammar> result) {
            this.G = G;
            this.startSymbols = startSymbols;
            this.result = result;
            this.setUncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler());
        }

        @Override
        public void run() {
            IVariable v = this.startSymbols.poll();
            while (v != null) {
                if (SAUtil.DEBUG) {
                    SAUtil.println((Object)("-- Thread " + this.getName() + " is processing " + v));
                }
                ConcurrentConstraintSolver.this.solveInternal(this.G, v, this.result);
                if (SAUtil.DEBUG) {
                    SAUtil.println((Object)("-- done (Thread " + this.getName() + " is processing " + v + ")"));
                }
                v = this.startSymbols.poll();
            }
        }
    }
}

