/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular;

import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.DeepSTSCopier;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IAutomatonSymbol;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.ISTSCopier;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.ITransitionCopier;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.Minimization;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StateReplacer;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.SimpleConstraintSolver;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegularConstraintSolver
extends SimpleConstraintSolver<IAutomaton> {
    protected static final int MINIMIZATION_SIZE_LIMIT = Integer.getInteger("com.ibm.wala.stringAnalysis.minimizationSizeLimit", 300);
    protected static final int MINIMIZATION_SIZE_LIMIT2 = MINIMIZATION_SIZE_LIMIT * MINIMIZATION_SIZE_LIMIT;
    protected static final int APPROXIMATION_SCALE = Integer.getInteger("com.ibm.wala.stringAnalysis.approximationScale", 10);
    protected static final int APPROXIMATION_SCALE2 = APPROXIMATION_SCALE * APPROXIMATION_SCALE;

    public RegularConstraintSolver(ITranslatorRepository<IAutomaton> translators, ISolverCache<IAutomaton> cache, ISolverStack stack, MonitorUtil.IProgressMonitor monitor) {
        super(translators, cache, stack, monitor);
    }

    @Override
    protected IAutomaton createAny() {
        return Automatons.createAny((IState)new State("s"));
    }

    @Override
    protected IAutomaton createEmpty() {
        return Automatons.createEmpty((IState)new State("s"));
    }

    @Override
    public IAutomaton substitute(IAutomaton a) {
        return RegularConstraintSolver.substituteAutomatons(a, false);
    }

    public static IAutomaton substituteAutomatons(IAutomaton a, boolean keepString) {
        HashSet<Transition> s = new HashSet<Transition>();
        HashSet<ITransition> d = new HashSet<ITransition>();
        FreshStateFactory sf = new FreshStateFactory(a);
        boolean containsEpsilon = false;
        for (ITransition t : a.getTransitions()) {
            ISymbol isym = t.getInputSymbol();
            if (!(isym instanceof IAutomatonSymbol) || keepString && isym instanceof StringSymbol) continue;
            IAutomatonSymbol asym = (IAutomatonSymbol)isym;
            d.add(t);
            IAutomaton a2 = Automatons.useUniqueStates((IAutomaton)asym.getAutomaton(), (IStateFactory)sf);
            Set finStates2 = a2.getFinalStates();
            IState initState2 = a2.getInitialState();
            if (finStates2.contains(initState2)) {
                s.addAll(a2.getTransitions());
                s.add(new Transition(t.getPreState(), initState2));
                for (IState finState : finStates2) {
                    s.add(new Transition(finState, t.getPostState()));
                }
                containsEpsilon = true;
                continue;
            }
            HashMap<IState, IState> m = new HashMap<IState, IState>();
            m.put(initState2, t.getPreState());
            for (IState finState2 : finStates2) {
                m.put(finState2, t.getPostState());
            }
            a2 = (IAutomaton)a2.copy((ISTSCopier)new DeepSTSCopier((ITransitionCopier)new StateReplacer(m)));
            s.addAll(a2.getTransitions());
        }
        a.getTransitions().removeAll(d);
        a.getTransitions().addAll(s);
        if (containsEpsilon) {
            Automatons.eliminateEpsilonTransitions((IAutomaton)a);
        }
        return a;
    }

    @Override
    protected IAutomaton composeResult(SimpleGrammar g) {
        IAutomaton a = Grammars.toAutomaton((IContextFreeGrammar)new ContextFreeGrammar(g), (MonitorUtil.IProgressMonitor)this.monitor);
        if (a.getFinalStates().isEmpty()) {
            return this.createAny();
        }
        return a;
    }

    @Override
    protected IAutomaton composeResult(IValueSymbol val) {
        IAutomaton a = val.getAutomaton();
        return a;
    }

    @Override
    protected IAutomaton composeResult(ILanguageSymbol<?> val) {
        IAutomaton a = (IAutomaton)val.getLanguage();
        return a;
    }

    @Override
    protected IAutomaton composeResults(Collection<IAutomaton> c) {
        IAutomaton a = Automatons.createUnion(c);
        return a;
    }

    @Override
    protected IAutomaton concatResults(List<IAutomaton> l) {
        IAutomaton a = Automatons.createConcatenation(l);
        return a;
    }

    private IAutomaton approximatePrecisely(IAutomaton a, int cycle) {
        int scale = APPROXIMATION_SCALE2 * (cycle + 1);
        return Minimization.minimize((IAutomaton)a, (int)(MINIMIZATION_SIZE_LIMIT2 / scale), (MonitorUtil.IProgressMonitor)this.monitor);
    }

    private IAutomaton approximateRoughly(IAutomaton a, int cycle) {
        return this.possibleStrings(a);
    }

    private IAutomaton possibleStrings(IAutomaton a) {
        Collection c = Automatons.collectTerminals((IAutomaton[])new IAutomaton[]{a});
        c = RangeSymbol.mergeSymbols((Collection)c);
        return this.possibleStrings(c);
    }

    private IAutomaton possibleStrings(Collection<? extends ISymbol> terminals) {
        IState s = this.stateFactory.createState(Automatons.prefixState);
        HashSet<Transition> transitions = new HashSet<Transition>();
        for (ISymbol iSymbol : terminals) {
            Transition t = new Transition(s, s, iSymbol);
            transitions.add(t);
        }
        Automaton a = new Automaton(s, Collections.singleton(s), transitions);
        return a;
    }

    @Override
    protected IAutomaton approximate(IAutomaton a, int cycle) {
        if (cycle >= this.WIDENING_THRESHOLD) {
            return this.approximateRoughly(a, cycle);
        }
        return this.approximatePrecisely(a, cycle);
    }

    @Override
    protected boolean contains(IAutomaton a1, IAutomaton a2) {
        return Automatons.containsAll((IAutomaton)a1, (IAutomaton)a2, (MonitorUtil.IProgressMonitor)this.monitor);
    }

    @Override
    protected IAutomaton minimize(IAutomaton a) {
        IAutomaton r;
        Automatons.eliminateUnreachableStates((IAutomaton)a);
        int asize = a.getTransitions().size();
        if (this.CHARSET_APPROXIMATION_THRESHOLD > 0 && asize > this.CHARSET_APPROXIMATION_THRESHOLD) {
            r = this.possibleStrings(a);
        } else {
            r = MINIMIZATION_SIZE_LIMIT == 0 || asize < MINIMIZATION_SIZE_LIMIT ? Minimization.minimize((IAutomaton)a, (MonitorUtil.IProgressMonitor)this.monitor) : Minimization.minimize((IAutomaton)a, (int)MINIMIZATION_SIZE_LIMIT2, (MonitorUtil.IProgressMonitor)this.monitor);
            Automatons.reduceTransitions((IAutomaton)r);
        }
        return r;
    }

    @Override
    protected SimpleGrammar composeGrammar(IAutomaton r) {
        return Grammars.toCFG((IAutomaton)r).toSimple();
    }
}

