/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.grammar.ConditionedInvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringConstraint;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class StringConstIndexOf
extends StringConstraint {
    public StringConstIndexOf(int target, int constraintTarget) {
        super(target, constraintTarget);
    }

    public boolean acceptCyclic() {
        return true;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IAutomaton> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        super.prepare(solver, funcName, recv, params, rule, grammar);
        return null;
    }

    @Override
    public IAutomaton translate(IAutomaton a) throws TranslationException {
        if (this.rule.getRight(0) instanceof ConditionedInvocationSymbol) {
            ConditionedInvocationSymbol invoke = (ConditionedInvocationSymbol)this.rule.getRight(0);
            IPrimitiveCondition cond = invoke.getCondition();
            if (cond instanceof RangeCondition) {
                RangeCondition range = (RangeCondition)cond;
                switch (range.op) {
                    case LT: {
                        if (range.boundary <= 0L) {
                            return this.translateForNegation(a);
                        }
                    }
                    case LE: {
                        if (range.boundary >= 0L) break;
                        return this.translateForNegation(a);
                    }
                }
            } else if (cond instanceof CaseCondition) {
                CaseCondition c = (CaseCondition)cond;
                if (c.label < 0) {
                    return this.translateForNegation(a);
                }
            } else if (cond instanceof NotCaseCondition) {
                NotCaseCondition c = (NotCaseCondition)cond;
                if (c.label >= 0) {
                    return this.translateForNegation(a);
                }
            }
        }
        a = StringConstIndexOf.createAnyFST();
        try {
            Collection<String> strs = this.solveStringConstantParameters(-1);
            if (strs.size() == 1) {
                String str = strs.iterator().next();
                a = this.createSublanguage(str);
            }
        }
        catch (IllegalGrammarException illegalGrammarException) {
            // empty catch block
        }
        return a;
    }

    private IAutomaton createSublanguage(String str) {
        Automaton a = Automatons.createAutomaton((List)StringSymbol.toCharSymbols((String)str));
        Set ss = a.getStates();
        IState init = a.getInitialState();
        a.getFinalStates().addAll(ss);
        ss.remove(init);
        for (IState state : ss) {
            a.getTransitions().add(new Transition(init, state));
        }
        return a;
    }

    public IAutomaton translateForNegation(IAutomaton a) {
        a = StringConstIndexOf.createAnyFST();
        try {
            Collection<String> strs = this.solveStringConstantParameters(-1);
            if (strs.size() == 1) {
                IAutomaton inv;
                String str = strs.iterator().next();
                IAutomaton fst = this.createSublanguage(str);
                a = inv = Automatons.createComplementByChars((IAutomaton)fst);
            }
        }
        catch (IllegalGrammarException illegalGrammarException) {
            // empty catch block
        }
        return a;
    }
}

