/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.stringAnalysis.translator.IConstraint;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringTranslator;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class StringConstraint
extends StringTranslator
implements IConstraint<IAutomaton> {
    private final int constraintTarget;

    public StringConstraint(int target, int constraintTarget) {
        super(target);
        this.constraintTarget = constraintTarget;
    }

    protected int getConstrainedParameter() {
        return this.constraintTarget;
    }

    public static Collection<IVariable> getConstraintTarget(int param, SSAAbstractInvokeInstruction invoke, ISymbolFactory<IAutomaton> symFactory, ISSABasicBlock bb, TranslationContext ctx) {
        HashSet<IVariable> vars = new HashSet<IVariable>();
        switch (param) {
            case -1: {
                IVariable v = symFactory.createValueNumberVariable(invoke.getReceiver(), ctx.getCGNode(), ctx.getCallGraph());
                vars.add(v);
                break;
            }
            case -2: {
                Assertions.UNREACHABLE();
                break;
            }
            default: {
                for (int vn : StringConstraint.getTargetForPai(invoke, param, bb, ctx)) {
                    IVariable v1 = symFactory.createValueNumberVariable(vn, ctx.getCGNode(), ctx.getCallGraph());
                    vars.add(v1);
                }
                IVariable v2 = symFactory.createValueNumberVariable(invoke.getUse(param), ctx.getCGNode(), ctx.getCallGraph());
                vars.add(v2);
            }
        }
        return vars;
    }

    private static Collection<Integer> getTargetForPai(SSAAbstractInvokeInstruction invoke, int param, ISSABasicBlock bb, TranslationContext ctx) {
        HashSet<Integer> vars = new HashSet<Integer>();
        Iterator iter = ctx.getCGNode().getIR().iteratePis();
        while (iter.hasNext()) {
            SSAPiInstruction pai;
            SSAInstruction instruction = (SSAInstruction)iter.next();
            if (!(instruction instanceof SSAPiInstruction) || (pai = (SSAPiInstruction)instruction).getCause() != invoke || pai.getUse(0) != invoke.getUse(param)) continue;
            vars.add(pai.getDef());
        }
        return vars;
    }

    @Override
    public Collection<IVariable> getConstraintTarget(SSAAbstractInvokeInstruction invoke, ISymbolFactory<IAutomaton> symFactory, ISSABasicBlock bb, TranslationContext ctx) {
        return StringConstraint.getConstraintTarget(this.getConstrainedParameter(), invoke, symFactory, bb, ctx);
    }
}

