/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringTranslator;
import java.util.HashSet;

public abstract class StringMap
extends StringTranslator {
    public static final ISymbol KEY_VALUE_SEPARATOR = new MapKeySeparator("->");

    public static boolean isMap(IAutomaton a) {
        for (ITransition t : a.getTransitions()) {
            if (!KEY_VALUE_SEPARATOR.equals(t.getInputSymbol())) continue;
            return true;
        }
        return false;
    }

    public static IAutomaton[] splitKeyValue(IAutomaton a) throws TranslationException {
        HashSet<IState> finStates = new HashSet<IState>();
        HashSet<IState> iniStates = new HashSet<IState>();
        for (ITransition t : a.getTransitions()) {
            if (!KEY_VALUE_SEPARATOR.equals(t.getInputSymbol())) continue;
            finStates.add(t.getPreState());
            iniStates.add(t.getPostState());
        }
        if (iniStates.isEmpty()) {
            throw new TranslationException("not a Map object");
        }
        IAutomaton key = a.dup();
        key.getFinalStates().clear();
        key.getFinalStates().addAll(finStates);
        Automatons.eliminateUnreachableStates((IAutomaton)key);
        IAutomaton val = a.dup();
        IState iniState = val.getInitialState();
        val.getTransitions().removeAll(val.getTransitions(iniState));
        for (IState s : iniStates) {
            Transition t = new Transition(iniState, s);
            val.getTransitions().add(t);
        }
        Automatons.eliminateUnreachableStates((IAutomaton)val);
        return new IAutomaton[]{key, val};
    }

    static class MapKeySeparator
    extends Symbol {
        public MapKeySeparator(String name) {
            super(name);
        }
    }
}

