/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.ITransitionVisitor;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.RegularConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringTranslator;
import com.ibm.wala.util.MonitorUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Transducer
extends StringTranslator {
    private IAutomaton transducer;
    static long totalTime = 0L;

    public Transducer(int target) {
        super(target);
    }

    public Transducer() {
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IAutomaton> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar g) {
        SimpleGrammar g2 = super.prepare(translator, funcName, recv, params, rule, g);
        try {
            this.transducer = this.createTransducer();
        }
        catch (TranslationException e) {
            this.transducer = null;
        }
        return g2;
    }

    protected abstract IAutomaton createTransducer() throws TranslationException;

    protected IAutomaton getTransducer() {
        return this.transducer;
    }

    @Override
    public IAutomaton translate(IAutomaton fst) throws TranslationException {
        IAutomaton transducer = this.getTransducer();
        if (transducer == null) {
            throw new TranslationException("The transducer was not created.");
        }
        IAutomaton a = Automatons.translateAutomaton((IAutomaton)transducer, (IAutomaton)fst, (MonitorUtil.IProgressMonitor)this.monitor);
        a = RegularConstraintSolver.substituteAutomatons(a, true);
        a = Automatons.determinize((IAutomaton)a, (MonitorUtil.IProgressMonitor)this.monitor);
        return a;
    }

    public boolean acceptCyclic() {
        return false;
    }

    public SimpleGrammar translateCyclic(SimpleGrammar g, Set<ISymbol> terminals) {
        System.err.println("Warning: cyclic constraint: " + this.funcName);
        IContextFreeGrammar g2 = Grammars.toCFG((IAutomaton)this.transducer, terminals, (Grammars.ITransitionSymbol)Grammars.TransitionOutput.defaultInstance, (IVariableFactory)this.varFactory);
        return g2.toSimple();
    }

    protected Set<ISymbol> possibleOutputs(Set<ISymbol> inputs) {
        final HashSet<ISymbol> outputs = new HashSet<ISymbol>();
        if (this.transducer == null) {
            outputs.add((ISymbol)new RangeSymbol('\u0000', '\uffff'));
        } else {
            IAutomaton fst = Automatons.expand((IAutomaton)this.transducer, inputs);
            fst.traverseTransitions(new ITransitionVisitor(){

                public void onVisit(ITransition transition) {
                    outputs.addAll(transition.getOutputSymbols());
                }
            });
        }
        return outputs;
    }

    public IAutomaton possibleAutomaton(SimpleGrammar g) {
        HashSet<ISymbol> outputs = new HashSet<ISymbol>();
        outputs.addAll(this.possibleOutputs(Grammars.collectTerminals((IGrammar[])new IGrammar[]{g})));
        return Transducer.possibleStringsAsFST(outputs, true);
    }
}

