/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Transducer;
import com.ibm.wala.util.debug.Assertions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Vsprintf
extends Transducer {
    private int arrayVarIndex;
    private final CharSymbol percentChar = new CharSymbol("%");
    private final CharSymbol plusChar = new CharSymbol("+");
    private final CharSymbol dChar = new CharSymbol("d");
    private final CharSymbol[] typeSpecifier = new StringSymbol("dsfoxXbeuc").toCharSymbols().toArray(new CharSymbol[0]);

    public Vsprintf(int target, int array) {
        super(target);
        this.arrayVarIndex = array;
    }

    public Vsprintf(int array) {
        this.arrayVarIndex = array;
    }

    @Override
    public IAutomaton createTransducer() {
        State state;
        Variable v = new Variable("v");
        List<IVariable> arrayVarList = this.getArrayVarList();
        String[] args = this.getArrayValues(arrayVarList);
        HashSet<Object> transitions = new HashSet<Object>();
        State initState = state = new State("s0");
        HashSet<State> finalStates = new HashSet<State>();
        int stateIndex = 1;
        int argsLen = args.length;
        for (int i = 0; i < argsLen; ++i) {
            State s1 = new State("s" + stateIndex++);
            State s2 = new State("s" + stateIndex++);
            State s3 = new State("s" + stateIndex++);
            finalStates.add(s1);
            finalStates.add(s2);
            finalStates.add(s3);
            FilteredTransition t0 = new FilteredTransition((IState)state, (IState)state, (ISymbol)v, new ISymbol[]{v}, null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r;
                    boolean bl = r = !symbol.equals(Vsprintf.this.percentChar);
                    if (r) {
                        System.err.println("(!symbol.equals(percentChar): accept " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t0);
            FilteredTransition t1 = new FilteredTransition((IState)state, (IState)s1, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = symbol.equals(Vsprintf.this.percentChar);
                    if (r) {
                        System.err.println("(symbol.equals(percentChar) " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t1);
            FilteredTransition t2 = new FilteredTransition((IState)s1, (IState)s2, (ISymbol)v, new ISymbol[0], null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = symbol.equals(Vsprintf.this.plusChar);
                    if (r) {
                        System.err.println("(symbol.equals(plusChar) " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t2);
            for (int j = 0; j < argsLen; ++j) {
                State nextState = new State("ss" + (i * argsLen + j));
                ITransition t3 = this.generateFormatSpecifierTransition((IState)s2, (IState)nextState, args[j]);
                transitions.add(t3);
                ITransition t4 = this.generateFormatTransition((IState)s1, (IState)nextState, args[j]);
                transitions.add(t4);
                Transition t5 = new Transition((IState)nextState, (IState)s3, Transition.EpsilonSymbol);
                transitions.add(t5);
                finalStates.add(nextState);
            }
            FilteredTransition t6 = new FilteredTransition((IState)s1, (IState)state, (ISymbol)v, new ISymbol[]{v}, null, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

                public boolean accept(ISymbol symbol, IMatchContext ctx) {
                    boolean r = symbol.equals(Vsprintf.this.percentChar);
                    if (r) {
                        System.err.println("(symbol.equals(percentChar) " + symbol + ")");
                    }
                    return r;
                }
            });
            transitions.add(t6);
            state = s3;
        }
        Transition t = new Transition((IState)state, (IState)state, (ISymbol)v, new ISymbol[]{v});
        transitions.add(t);
        Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
        return transducer;
    }

    private ITransition generateFormatTransition(IState s1, IState nextState, final String arg) {
        Variable v = new Variable("v");
        FilteredTransition t = new FilteredTransition(s1, nextState, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                ArrayList<ISymbol> newOutputs = new ArrayList<ISymbol>();
                if (symbol.equals(Vsprintf.this.typeSpecifier[0])) {
                    return Vsprintf.this.formatStandardInteger(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[1])) {
                    return Vsprintf.this.formatString(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[2])) {
                    return Vsprintf.this.formatFloatingPoint(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[3])) {
                    return Vsprintf.this.formatOctal(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[4])) {
                    return Vsprintf.this.formatHexadecimalLowerCase(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[5])) {
                    return Vsprintf.this.formatHexadecimalUpperCase(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[6])) {
                    return Vsprintf.this.formatBinary(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[7])) {
                    return Vsprintf.this.formatScientificNotation(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[8])) {
                    return Vsprintf.this.formatUnsignedInteger(arg);
                }
                if (symbol.equals(Vsprintf.this.typeSpecifier[9])) {
                    return Vsprintf.this.printAsciiCharacter(arg);
                }
                return newOutputs;
            }
        }, (FilteredTransition.ICondition)new FilteredTransition.IObsoleteCondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                boolean r;
                boolean bl = r = !symbol.equals(Vsprintf.this.percentChar) && !symbol.equals(Vsprintf.this.plusChar);
                if (r) {
                    System.err.println("(!symbol.equals(percentChar) && (!symbol.equals(plucChar)");
                }
                return r;
            }
        });
        return t;
    }

    private ITransition generateFormatSpecifierTransition(IState s2, IState nextState, final String arg) {
        Variable v = new Variable("v");
        FilteredTransition t = new FilteredTransition(s2, nextState, (ISymbol)v, new ISymbol[]{v}, new FilteredTransition.IFilter(){

            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                if (symbol.equals(Vsprintf.this.dChar)) {
                    return Vsprintf.this.formatSignSpecifier(arg);
                }
                if (symbol.equals(Vsprintf.this.percentChar)) {
                    return outputs;
                }
                outputs.clear();
                return outputs;
            }
        }, null);
        return t;
    }

    private String[] getArrayValues(List<IVariable> arrayVarList) {
        String[] args = new String[arrayVarList.size()];
        Set rules = this.grammar.getRules();
        Iterator<IVariable> arrayVarIte = arrayVarList.iterator();
        int index = 0;
        block0: while (arrayVarIte.hasNext()) {
            IVariable arrayVar = arrayVarIte.next();
            for (ProductionRule rule : rules) {
                if (!rule.getLeft().equals(arrayVar)) continue;
                List right = rule.getRight();
                args[index] = this.list2Str(right);
                ++index;
                continue block0;
            }
        }
        return args;
    }

    private String list2Str(List<ISymbol> right) {
        Iterator<ISymbol> rightIte = right.iterator();
        StringBuffer sb = new StringBuffer();
        while (rightIte.hasNext()) {
            ISymbol sym = rightIte.next();
            if (sym instanceof CharSymbol) {
                CharSymbol charSym = (CharSymbol)sym;
                sb.append(charSym.charValue());
                continue;
            }
            Assertions.UNREACHABLE();
        }
        return sb.toString();
    }

    private List<IVariable> getArrayVarList() {
        Variable arrayVar = (Variable)this.params.get(this.arrayVarIndex);
        ArrayList<IVariable> arrayVarList = new ArrayList<IVariable>();
        Set rules = this.grammar.getRules();
        for (ProductionRule rule : rules) {
            if (!rule.getLeft().equals(arrayVar)) continue;
            arrayVarList.add((IVariable)rule.getRight().get(0));
        }
        return arrayVarList;
    }

    protected List<ISymbol> printAsciiCharacter(String arg) {
        Charset asciiCharset = Charset.forName("US-ASCII");
        CharsetDecoder decoder = asciiCharset.newDecoder();
        int argInt = 0;
        if (this.isNumber(arg)) {
            argInt = Integer.parseInt(arg);
        }
        if (0 > argInt || argInt > 127) {
            return new ArrayList<ISymbol>();
        }
        byte b1 = (byte)argInt;
        byte[] b = new byte[]{b1};
        ByteBuffer asciiBytes = ByteBuffer.wrap(b);
        CharBuffer cBuf = null;
        try {
            cBuf = decoder.decode(asciiBytes);
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        StringSymbol strSym = new StringSymbol(cBuf.toString());
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatSignSpecifier(String arg) {
        int argInt = 0;
        if (this.isNumber(arg)) {
            argInt = Integer.parseInt(arg);
        }
        StringSymbol strSym = new StringSymbol(String.valueOf(argInt));
        if (argInt >= 0) {
            strSym = new StringSymbol("+" + String.valueOf(argInt));
        }
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatUnsignedInteger(String arg) {
        int argInt = 0;
        if (this.isNumber(arg)) {
            argInt = Integer.parseInt(arg);
        }
        double argDouble = argInt;
        if (argInt < 0) {
            argDouble = (double)argInt + Math.pow(2.0, 32.0);
            System.out.println(argDouble);
        }
        DecimalFormat df = new DecimalFormat("0");
        StringSymbol strSym = new StringSymbol(df.format(argDouble));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatScientificNotation(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        DecimalFormat df = new DecimalFormat("0.00000E0");
        String argStr = df.format(Double.parseDouble(arg));
        int ePos = argStr.indexOf("E");
        int minusPos = argStr.indexOf("-");
        if (minusPos < 0) {
            StringBuffer sb = new StringBuffer(argStr);
            sb.replace(ePos, ePos + 1, "e");
            sb.insert(ePos + 1, "+");
            argStr = sb.toString();
        }
        StringSymbol strSym = new StringSymbol(argStr);
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatBinary(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        StringSymbol strSym = new StringSymbol(Integer.toBinaryString(Integer.parseInt(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatHexadecimalUpperCase(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        String argStr = Integer.toHexString(Integer.parseInt(arg));
        StringSymbol strSym = new StringSymbol(argStr.toUpperCase());
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatHexadecimalLowerCase(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        StringSymbol strSym = new StringSymbol(Integer.toHexString(Integer.parseInt(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatOctal(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        StringSymbol strSym = new StringSymbol(Integer.toOctalString(Integer.parseInt(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatFloatingPoint(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        DecimalFormat df = new DecimalFormat("0.000000");
        StringSymbol strSym = new StringSymbol(df.format(Double.parseDouble(arg)));
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatString(String arg) {
        StringSymbol strSym = new StringSymbol(arg);
        return strSym.toSymbols();
    }

    protected List<ISymbol> formatStandardInteger(String arg) {
        if (!this.isNumber(arg)) {
            arg = "0";
        }
        BigDecimal bigDecimal = new BigDecimal(arg);
        StringSymbol strSym = new StringSymbol(String.valueOf(bigDecimal.intValue()));
        return strSym.toSymbols();
    }

    private boolean isNumber(String arg) {
        char[] charArray = arg.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (!Character.isDigit(charArray[i])) continue;
            return true;
        }
        return false;
    }
}

