/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.util;

import com.ibm.wala.automaton.util.collections.BinaryFunction;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.functions.Function;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class StringUtil {
    private static final String[] table = new String[65536];

    public static String join(Appendable buf, String sep, Iterator<? extends Object> it) throws IOException {
        if (it == null || !it.hasNext()) {
            return "";
        }
        buf.append(it.next().toString());
        while (it.hasNext()) {
            buf.append(sep);
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    public static String join(Appendable buf, String sep, Object[] arr) throws IOException {
        if (arr == null || arr.length == 0) {
            return "";
        }
        buf.append(arr[0].toString());
        for (int i = 1; i < arr.length; ++i) {
            buf.append(sep);
            buf.append(arr[i].toString());
        }
        return buf.toString();
    }

    public static String join(Appendable buf, String sep, Collection<? extends Object> c) throws IOException {
        return StringUtil.join(buf, sep, c.iterator());
    }

    public static <T> String join(Appendable buf, Function<T, String> sepmaker, Iterator<? extends T> it) throws IOException {
        if (it == null || !it.hasNext()) {
            return "";
        }
        buf.append(it.next().toString());
        while (it.hasNext()) {
            T e = it.next();
            buf.append((CharSequence)sepmaker.apply(e));
            buf.append(e.toString());
        }
        return buf.toString();
    }

    public static <T> String join(Appendable buf, Function<T, String> sepmaker, T[] arr) throws IOException {
        if (arr == null || arr.length == 0) {
            return "";
        }
        buf.append(arr[0].toString());
        for (int i = 1; i < arr.length; ++i) {
            buf.append((CharSequence)sepmaker.apply(arr[i]));
            buf.append(arr[i].toString());
        }
        return buf.toString();
    }

    public static <T> String join(Appendable buf, Function<T, String> sepmaker, Collection<? extends T> c) throws IOException {
        if (c == null) {
            return "";
        }
        return StringUtil.join(buf, sepmaker, c.iterator());
    }

    public static String join(StringBuilder buf, String sep, Iterator<? extends Object> it) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        buf.append(it.next().toString());
        while (it.hasNext()) {
            buf.append(sep);
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    public static String join(StringBuilder buf, String sep, Object[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        buf.append(arr[0].toString());
        for (int i = 1; i < arr.length; ++i) {
            buf.append(sep);
            buf.append(arr[i].toString());
        }
        return buf.toString();
    }

    public static String join(StringBuilder buf, String sep, Collection<? extends Object> c) {
        if (c == null) {
            return "";
        }
        return StringUtil.join(buf, sep, c.iterator());
    }

    public static <T> String join(StringBuilder buf, Function<T, String> sepmaker, Iterator<? extends T> it) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        buf.append(it.next().toString());
        while (it.hasNext()) {
            T e = it.next();
            buf.append((String)sepmaker.apply(e));
            buf.append(e.toString());
        }
        return buf.toString();
    }

    public static <T> String join(StringBuilder buf, Function<T, String> sepmaker, T[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        buf.append(arr[0].toString());
        for (int i = 1; i < arr.length; ++i) {
            buf.append((String)sepmaker.apply(arr[i]));
            buf.append(arr[i].toString());
        }
        return buf.toString();
    }

    public static <T> String join(StringBuilder buf, Function<T, String> sepmaker, Collection<? extends T> c) {
        if (c == null) {
            return "";
        }
        return StringUtil.join(buf, sepmaker, c.iterator());
    }

    public static String join(StringBuffer buf, String sep, Iterator<? extends Object> it) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        buf.append(it.next().toString());
        while (it.hasNext()) {
            buf.append(sep);
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    public static String join(StringBuffer buf, String sep, Object[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        buf.append(arr[0].toString());
        for (int i = 1; i < arr.length; ++i) {
            buf.append(sep);
            buf.append(arr[i].toString());
        }
        return buf.toString();
    }

    public static String join(StringBuffer buf, String sep, Collection<? extends Object> c) {
        return StringUtil.join(buf, sep, c.iterator());
    }

    public static <T> String join(StringBuffer buf, Function<T, String> sepmaker, Iterator<? extends T> it) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        buf.append(it.next().toString());
        while (it.hasNext()) {
            T e = it.next();
            buf.append((String)sepmaker.apply(e));
            buf.append(e.toString());
        }
        return buf.toString();
    }

    public static <T> String join(StringBuffer buf, Function<T, String> sepmaker, T[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        buf.append(arr[0].toString());
        for (int i = 1; i < arr.length; ++i) {
            buf.append((String)sepmaker.apply(arr[i]));
            buf.append(arr[i].toString());
        }
        return buf.toString();
    }

    public static <T> String join(StringBuffer buf, Function<T, String> sepmaker, Collection<? extends T> c) {
        if (c == null) {
            return "";
        }
        return StringUtil.join(buf, sepmaker, c.iterator());
    }

    public static <T> String join(Appendable buf, BinaryFunction<T, T, String> sepmaker, Iterator<? extends T> it) throws IOException {
        if (it == null || !it.hasNext()) {
            return "";
        }
        T curr = it.next();
        if (!it.hasNext()) {
            return curr.toString();
        }
        while (it.hasNext()) {
            T next = it.next();
            buf.append(curr.toString());
            buf.append((CharSequence)sepmaker.apply(curr, next));
            buf.append(next.toString());
            curr = next;
        }
        return buf.toString();
    }

    public static <T> String join(Appendable buf, BinaryFunction<T, T, String> sepmaker, Collection<? extends T> c) throws IOException {
        if (c == null) {
            return "";
        }
        return StringUtil.join(buf, sepmaker, c.iterator());
    }

    public static <T> String join(Appendable buf, BinaryFunction<T, T, String> sepmaker, T[] array) throws IOException {
        if (array == null) {
            return "";
        }
        return StringUtil.join(buf, sepmaker, new ArrayIterator((Object[])array));
    }

    public static String escapeMeta(String string) {
        int len = string.length();
        StringBuilder buf = new StringBuilder(len);
        char[] arr = string.toCharArray();
        for (int i = 0; i < len; ++i) {
            buf.append(StringUtil.escapeMeta(arr[i]));
        }
        return buf.toString();
    }

    public static String escapeMeta(char c) {
        return table[c - '\u0000'];
    }

    static {
        block10: for (int i = 0; i < 65535; i = (int)((char)(i + 1))) {
            int c = i - 0;
            switch (c) {
                case 8: {
                    StringUtil.table[c] = "\\b";
                    continue block10;
                }
                case 9: {
                    StringUtil.table[c] = "\\t";
                    continue block10;
                }
                case 10: {
                    StringUtil.table[c] = "\\n";
                    continue block10;
                }
                case 12: {
                    StringUtil.table[c] = "\\f";
                    continue block10;
                }
                case 13: {
                    StringUtil.table[c] = "\\r";
                    continue block10;
                }
                case 34: {
                    StringUtil.table[c] = "\\\"";
                    continue block10;
                }
                case 39: {
                    StringUtil.table[c] = "\\'";
                    continue block10;
                }
                case 92: {
                    StringUtil.table[c] = "\\\\";
                    continue block10;
                }
                default: {
                    StringUtil.table[c] = Character.isIdentifierIgnorable(c) ? String.format("\\u%04x", c) : (Character.isUnicodeIdentifierPart(c) ? Character.toString((char)c) : (c > 32 && c < 126 && !Character.isSpaceChar(c) ? Character.toString((char)c) : String.format("\\u%04x", c)));
                }
            }
        }
    }
}

