/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.auth.providers;

import com.ibm.appscan.cli.cloud.auth.Messages;
import com.ibm.appscan.cli.cloud.auth.handlers.LoginHandler;
import com.ibm.appscan.cli.cloud.auth.handlers.LoginType;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ConnectionHelper;
import com.ibm.appscan.common.utils.CryptoUtils;
import com.ibm.appscan.common.utils.StringUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.WebServiceUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class AuthenticationProvider
implements SaaSConstants {
    private static AuthenticationProvider m_instance;
    private IProgress m_progress = new ProgressAdapter();
    private static String m_homeDirectory;
    private static String m_appscanDirectory;
    private static String m_tokenLocation;
    private static final String DELIMITER = "_=_";
    private static final String NEW_LINE = "\n";
    private static final String LINE_RETURN = "\r";
    private static final String PROP_EXPIRE = "EXPIRE";

    public static AuthenticationProvider getInstance() {
        if (m_instance == null) {
            m_instance = new AuthenticationProvider();
        }
        return m_instance;
    }

    public boolean isTokenExpired() throws IOException {
        if (this.getTokenFile() == null || this.getToken() == null) {
            return true;
        }
        if (this.isBypassedSSL()) {
            try {
                ConnectionHelper.bypassSSL();
            }
            catch (GeneralSecurityException e) {
                this.m_progress.setStatus(new Message((Throwable)e));
            }
        }
        boolean isExpired = true;
        if (SystemUtil.isPropertySet((String)PROP_EXPIRE)) {
            System.clearProperty(PROP_EXPIRE);
        } else {
            String request_url = this.getServer() + "/api/v4/Account/TenantInfo";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + this.getToken().trim());
            headers.put("Accept", "application/json");
            headers.put("charset", "utf-8");
            HttpClient httpClient = new HttpClient();
            HttpResponse httpResponse = httpClient.get(request_url, headers, null);
            isExpired = httpResponse.getResponseCode() != 200;
        }
        boolean shouldPersist = this.isPersistedConnection();
        if (isExpired && shouldPersist) {
            try {
                isExpired = !this.reconnect();
            }
            catch (GeneralSecurityException e) {
                this.m_progress.setStatus(new Message(4, Messages.getMessage("login.error", this.getServer())));
            }
        }
        return isExpired;
    }

    public boolean saveConnection(Map<String, char[]> connectionProperties) {
        boolean success;
        File appscanDirectoryFile = new File(m_appscanDirectory);
        if (!appscanDirectoryFile.exists() && !(success = new File(m_appscanDirectory).mkdir())) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("login.token.create.err", new Object[0])));
        }
        return this.createTokenFile(connectionProperties);
    }

    public boolean deleteConnection() {
        File keyFile = new File(m_tokenLocation);
        return keyFile.exists() ? keyFile.delete() : true;
    }

    @SuppressSecurityTrace
    private boolean createTokenFile(Map<String, char[]> properties) {
        File keyFile = new File(m_tokenLocation);
        try {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, char[]> property : properties.entrySet()) {
                builder.append(property.getKey());
                builder.append(DELIMITER);
                for (char c : property.getValue()) {
                    builder.append(c);
                }
                builder.append(LINE_RETURN);
                builder.append(NEW_LINE);
            }
            String encrypted = this.encryptContent(StringUtil.getCharsFromStringBuilder((StringBuilder)builder));
            FileWriter writer = new FileWriter(keyFile, false);
            writer.write(encrypted);
            writer.close();
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
            return false;
        }
        catch (GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
            return false;
        }
        return true;
    }

    @SuppressSecurityTrace
    private File getTokenFile() {
        File tokenFile = new File(m_tokenLocation);
        if (!tokenFile.exists()) {
            return null;
        }
        try {
            this.readTokenFile(tokenFile);
        }
        catch (Exception e) {
            return null;
        }
        return tokenFile;
    }

    private String readTokenFile(File tokenFile) throws IOException, GeneralSecurityException {
        if (tokenFile == null) {
            throw new GeneralSecurityException(Messages.getMessage("login.token.expired", new Object[0]));
        }
        String decryptedOutput = null;
        FileInputStream fin = new FileInputStream(tokenFile);
        byte[] buffer = new byte[(int)tokenFile.length()];
        new DataInputStream(fin).readFully(buffer);
        fin.close();
        try {
            decryptedOutput = this.decryptContent(new String(buffer, "utf-8"));
        }
        catch (GeneralSecurityException e) {
            throw new GeneralSecurityException(Messages.getMessage("login.token.expired", new Object[0]));
        }
        return decryptedOutput;
    }

    @SuppressSecurityTrace
    private String getProperty(String propertyKey) throws IOException, GeneralSecurityException {
        return new String(this.getPropertyCharacters(propertyKey));
    }

    @SuppressSecurityTrace
    private char[] getPropertyCharacters(String propertyKey) throws IOException, GeneralSecurityException {
        String line;
        BufferedReader br = null;
        StringBuilder str = new StringBuilder();
        StringReader sr = null;
        String content = this.readTokenFile(this.getTokenFile());
        if (content == null) {
            return null;
        }
        sr = new StringReader(content);
        br = new BufferedReader(sr);
        while ((line = br.readLine()) != null && str.length() == 0) {
            String[] properties;
            for (String property : properties = line.split(NEW_LINE)) {
                String[] propertyPair = property.split(DELIMITER);
                if (!propertyPair[0].equalsIgnoreCase(propertyKey)) continue;
                str.append(propertyPair[1]);
            }
        }
        if (br != null) {
            br.close();
        }
        return StringUtil.getCharsFromStringBuilder((StringBuilder)str);
    }

    public String getServer() {
        String server = null;
        try {
            server = this.getProperty("connection.server");
            if (server == null) {
                server = WebServiceUtil.getServer((String)this.getProperty("connection.username"));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
            server = WebServiceUtil.getServer();
        }
        return server;
    }

    public String getKeyID() {
        String keyId = null;
        try {
            keyId = this.getProperty("connection.username");
        }
        catch (IOException | GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        return keyId;
    }

    public String getToken() {
        String token = null;
        try {
            token = this.getProperty("connection.token");
        }
        catch (IOException | GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        return token;
    }

    public String getApiEnvironment() {
        String apiEnvironment = null;
        try {
            apiEnvironment = this.getProperty("connection.environment");
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        catch (GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        if (apiEnvironment != null) {
            return apiEnvironment;
        }
        return "BlueMix";
    }

    public boolean isBypassedSSL() {
        String sslBypass = null;
        try {
            sslBypass = this.getProperty("connection.bypassSSL");
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        catch (GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        return sslBypass != null ? Boolean.parseBoolean(sslBypass) : false;
    }

    public boolean isPersistedConnection() {
        String persist = null;
        try {
            persist = this.getProperty("connection.persist");
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        catch (GeneralSecurityException e) {
            this.m_progress.setStatus(new Message((Throwable)e));
        }
        return persist != null ? Boolean.parseBoolean(persist) : false;
    }

    private String encryptContent(char[] content) throws IOException, GeneralSecurityException {
        CharBuffer charBuffer = CharBuffer.wrap(content);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] contentBytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        byte[] encryptedData = CryptoUtils.aesEncrypt((byte[])contentBytes);
        String ret = DatatypeConverter.printBase64Binary((byte[])encryptedData);
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return ret;
    }

    private String decryptContent(String content) throws IOException, GeneralSecurityException {
        byte[] contentBytes = DatatypeConverter.parseBase64Binary((String)content);
        byte[] decryptedData = CryptoUtils.aesDecrypt((byte[])contentBytes);
        return new String(decryptedData, "utf-8");
    }

    public Map<String, String> getAuthorizationHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + (this.getToken() != null ? this.getToken().trim() : ""));
        headers.put("Connection", "Keep-Alive");
        return headers;
    }

    public boolean reconnect() throws IOException, GeneralSecurityException {
        boolean success = false;
        LoginHandler handler = new LoginHandler(){

            @Override
            protected String getServer(String key) {
                return AuthenticationProvider.this.getServer();
            }
        };
        String username = this.getProperty("connection.username");
        char[] password = this.getPropertyCharacters("connection.password");
        String server = this.getServer();
        if (username != null && !username.isEmpty() && password != null && password.length > 0) {
            boolean acceptSSL = Boolean.parseBoolean(this.getProperty("connection.bypassSSL"));
            LoginType type = Boolean.parseBoolean(this.getProperty("connection.federated")) ? LoginType.ASoC_Federated : LoginType.ASoC;
            success = handler.login(username, password, acceptSSL, true, type, null, server);
        } else {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("login.error", server)));
        }
        return success;
    }

    static {
        m_homeDirectory = System.getProperty("user.home");
        m_appscanDirectory = m_homeDirectory + File.separator + ".appscan";
        m_tokenLocation = m_appscanDirectory + File.separator + "cli.token";
    }
}

