/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.IrxCacheConstants;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.xml.ConfigReader;
import com.ibm.appscan.common.xml.XMLFileReader;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.stream.events.StartElement;

public abstract class IrxCache
implements IrxCacheConstants {
    public boolean objectInCache(Object key, File setting_dir) throws NoSuchAlgorithmException, AppScanException, IOException {
        if (!SystemUtil.useCacheForSlicer()) {
            return false;
        }
        return this.getCacheEntry(this.generateSha256Key(key, setting_dir)) != null;
    }

    public boolean insertCacheEntry(Object key, File setting_dir, File source) throws NoSuchAlgorithmException, IOException {
        if (!SystemUtil.useCacheForSlicer()) {
            return false;
        }
        try {
            return this.insertCacheEntry(this.generateSha256Key(key, setting_dir), source);
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyCacheEntryToFile(Object o, File setting_dir, File output) throws NoSuchAlgorithmException, IOException {
        InputStream cache_entry;
        block5: {
            boolean bl;
            if (!SystemUtil.useCacheForSlicer()) {
                return false;
            }
            cache_entry = null;
            try {
                cache_entry = this.getCacheEntry(this.generateSha256Key(o, setting_dir));
                if (cache_entry == null) break block5;
                IOUtil.write((InputStream)cache_entry, (File)output);
                bl = true;
            }
            catch (AppScanException e) {
                try {
                    CommonCore.getLogManager().log((Exception)((Object)e));
                }
                catch (Throwable throwable) {
                    IOUtil.close(cache_entry);
                    throw throwable;
                }
                IOUtil.close((Closeable)cache_entry);
            }
            IOUtil.close((Closeable)cache_entry);
            return bl;
        }
        IOUtil.close((Closeable)cache_entry);
        return false;
    }

    public boolean checkCacheForCleanup() {
        if (!SystemUtil.useCacheForSlicer()) {
            return false;
        }
        if (this.clearAllFilesInIrxCache()) {
            return true;
        }
        return this.reduceCacheFiles();
    }

    protected byte[] mergeInTargetInfoSrcPath(byte[] object, File target_info) {
        byte[] cp;
        final ArrayList src_root = new ArrayList();
        byte[] ret = object;
        final HashSet<String> dependency_files = new HashSet<String>();
        try {
            if (target_info.exists() && target_info.isFile()) {
                XMLFileReader reader = new XMLFileReader(target_info){

                    protected boolean process(StartElement element) {
                        String name = element.getName().getLocalPart();
                        if (name.equals("BuildInfo")) {
                            if (this.getAttribute(element, "src_root") != null) {
                                src_root.add(this.getAttribute(element, "src_root"));
                            }
                            dependency_files.addAll(IrxCache.this.processClassPathElement(this.getAttribute(element, "additional_classpath")));
                            dependency_files.addAll(IrxCache.this.processClassPathElement(this.getAttribute(element, "bootstrap_classpath")));
                            dependency_files.addAll(IrxCache.this.processClassPathElement(this.getAttribute(element, "classpath")));
                            dependency_files.addAll(IrxCache.this.processClassPathElement(this.getAttribute(element, "extension_jars")));
                        }
                        return true;
                    }
                };
                reader.read();
            }
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(e);
        }
        if (src_root.size() == 1) {
            ret = this.mergeBytes(ret, ((String)src_root.get(0)).getBytes());
        }
        if ((cp = this.getBytesFromClassPathFileHash(dependency_files)) != null && cp.length > 0) {
            ret = this.mergeBytes(ret, cp);
        }
        return ret;
    }

    private byte[] mergeBytes(byte[] base, byte[] add) {
        int i;
        byte[] tmp = new byte[base.length + add.length];
        int index = 0;
        for (i = 0; i < add.length; ++i) {
            tmp[index] = add[i];
            ++index;
        }
        for (i = 0; i < base.length; ++i) {
            tmp[index] = base[i];
            ++index;
        }
        return tmp;
    }

    private HashSet<String> processClassPathElement(String attribute_value) {
        HashSet<String> ret = new HashSet<String>();
        if (attribute_value != null) {
            File prod_root = new File(CommonCore.getDirectoryLocator().getProductRoot());
            for (String path : attribute_value.split(File.pathSeparator)) {
                File f = new File(path);
                if (!f.exists() || !f.isFile() || f.getName().equals("user.code.staged.jar") || f.getAbsolutePath().startsWith(prod_root.getPath())) continue;
                try {
                    ret.add(f.getCanonicalPath());
                }
                catch (IOException e) {
                    CommonCore.getLogManager().log((Exception)e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromClassPathFileHash(HashSet<String> files) {
        byte[] ret = null;
        if (files == null || files.size() == 0) {
            return ret;
        }
        ArrayList<String> sorted_file = new ArrayList<String>(files);
        Collections.sort(sorted_file, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (new File(o1).getName().compareTo(new File(o2).getName()) != 0) {
                    return new File(o1).getName().compareTo(new File(o2).getName());
                }
                return o1.compareTo(o2);
            }
        });
        for (String f : sorted_file) {
            BufferedInputStream bis = null;
            try {
                int count;
                byte[] buffer = new byte[8192];
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                bis = new BufferedInputStream(new FileInputStream(f));
                while ((count = bis.read(buffer)) > 0) {
                    digest.update(buffer, 0, count);
                }
                bis.close();
                ret = digest.digest();
                IOUtil.close((Closeable)bis);
            }
            catch (Exception e) {
                CommonCore.getLogManager().log(e);
            }
            finally {
                IOUtil.close(bis);
            }
        }
        return ret;
    }

    public String generateSha256Key(Object o, File setting_dir) throws NoSuchAlgorithmException, IOException {
        Object settings;
        String SHA1key = null;
        MessageDigest algorithm = MessageDigest.getInstance("SHA-256");
        if (setting_dir != null && setting_dir.isDirectory()) {
            settings = new HashMap();
            for (File f : setting_dir.listFiles()) {
                if (!f.getPath().endsWith("apsettings")) continue;
                ConfigReader r = new ConfigReader(f, (HashMap)settings);
                try {
                    r.read();
                }
                catch (Exception e) {
                    CommonCore.getLogManager().log(e);
                }
            }
            ArrayList keys = new ArrayList(((HashMap)settings).keySet());
            Collections.sort(keys);
            for (String key : keys) {
                algorithm.update(((String)((HashMap)settings).get(key)).getBytes());
            }
        }
        algorithm.update(this.getBytesFromObjectData(o));
        algorithm.update(ByteBuffer.allocate(4).putInt(this.getCacheVersionToUse()).array());
        settings = this.getBytesFromAppScanSettings();
        if (settings != null && ((Object)settings).length > 0) {
            algorithm.update(this.getBytesFromAppScanSettings());
        }
        BigInteger no = new BigInteger(1, algorithm.digest());
        SHA1key = no.toString(16);
        while (SHA1key.length() < 32) {
            SHA1key = "0" + SHA1key;
        }
        return SHA1key;
    }

    protected boolean clearAllFilesInIrxCache() {
        if (SystemUtil.defaultFalseProperty((String)this.getSettingForClearAllCheck())) {
            this.deleteAllFilesInCache();
            return true;
        }
        return false;
    }

    protected boolean reduceCacheFiles() {
        boolean ret = false;
        while (this.cacheSpaceExceeded() || this.cacheEntryAmountExceed()) {
            ret = true;
            this.reduceCacheEntry();
        }
        return ret;
    }

    private boolean cacheSpaceExceeded() {
        return (double)this.getUsedSpaceInCache() > this.getMaxCacheSpaceAllowed();
    }

    protected double getMaxCacheSpaceAllowed() {
        if (SystemUtil.isPropertySet((String)this.getSettingForMaxSpaceAllowed())) {
            try {
                return Double.parseDouble(System.getProperty(this.getSettingForMaxSpaceAllowed()));
            }
            catch (Exception e) {
                return this.getMaxCacheSpaceAllowed_();
            }
        }
        return this.getMaxCacheSpaceAllowed_();
    }

    private boolean cacheEntryAmountExceed() {
        return this.getCacheEntryCount() > this.getMaxEntriesAllowed();
    }

    private long getMaxEntriesAllowed() {
        if (SystemUtil.isPropertySet((String)this.getSettingForMaxEntriesdAllowed())) {
            return Integer.parseInt(System.getProperty(this.getSettingForMaxEntriesdAllowed()));
        }
        return this.getMaxEntriesAllowed_();
    }

    protected int getCacheVersionToUse() {
        return 3;
    }

    protected abstract boolean insertCacheEntry(String var1, File var2) throws IOException;

    protected abstract void deleteAllFilesInCache();

    protected abstract InputStream getCacheEntry(String var1) throws AppScanException, IOException;

    protected abstract byte[] getBytesFromObjectData(Object var1) throws NoSuchAlgorithmException, IOException;

    protected abstract byte[] getBytesFromAppScanSettings() throws NoSuchAlgorithmException, IOException;

    protected abstract String getSettingForMaxSpaceAllowed();

    protected abstract String getSettingForMaxEntriesdAllowed();

    protected abstract String getSettingForClearAllCheck();

    protected abstract long getMaxCacheSpaceAllowed_();

    protected abstract long getMaxEntriesAllowed_();

    protected abstract long getCacheEntryCount();

    protected abstract void reduceCacheEntry();

    protected abstract long getUsedSpaceInCache();
}

