/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.slice.Bucket;
import com.hcl.irx.slice.IrxCache;
import com.ibm.appscan.common.CommonCore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.json.JSONException;

public abstract class IrxMinorCache
extends IrxCache {
    @Override
    protected byte[] getBytesFromObjectData(Object o) throws NoSuchAlgorithmException, IOException {
        Bucket bucket = (Bucket)o;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (ClassInfo classInfo : bucket.getClassesInBucket()) {
            outputStream.write(classInfo.getDataFromJspOrClassFile());
        }
        return this.mergeInTargetInfoSrcPath(outputStream.toByteArray(), new File(bucket.getBucketDir(), ".targetinfo"));
    }

    protected abstract HashMap<String, HashSet<String>> getPreviousBuckets(boolean var1) throws IOException, JSONException;

    protected abstract void updatePreviousBuckets(HashMap<String, HashSet<String>> var1) throws JSONException, IOException;

    @Override
    protected byte[] getBytesFromAppScanSettings() throws NoSuchAlgorithmException, IOException {
        return ByteBuffer.allocate(4).putInt(CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("can_wafl_gen") ? 1 : 0).array();
    }

    @Override
    protected long getMaxCacheSpaceAllowed_() {
        return 0x280000000L;
    }

    @Override
    protected String getSettingForClearAllCheck() {
        return "IRX_MINOR_CACHE_CLEAR_ALL";
    }

    @Override
    protected String getSettingForMaxEntriesdAllowed() {
        return "IRX_MINOR_CACHE_MAX_COUNT";
    }

    @Override
    protected String getSettingForMaxSpaceAllowed() {
        return "IRX_MINOR_CACHE_SPACE";
    }
}

