/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.wafl;

import com.hcl.irx.slice.Bucket;
import com.hcl.irx.slice.Messages;
import com.hcl.irx.slice.wafl.SliceWafl;
import com.hcl.irx.slice.wafl.WaflXml;
import com.hcl.irx.slice.wafl.WaflXmlFrameworkInput;
import com.hcl.irx.slice.wafl.WaflXmlLogConfig;
import com.hcl.irx.slice.wafl.WalaScope;
import com.hcl.irx.stage.Stager;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class JavaWaflGen {
    private Stager m_stager;
    private File m_wafl_file;
    private IScanTargetMinProxy m_proxy;
    private IProgress m_progress;
    private long m_wafl_gen_time = 0L;
    ArrayList<WaflXml> m_xml_files;
    public static String BLANK_WAFL_CONTENTS = "<wafl xmlns=\"http://www.ibm.com/WAFLSchema\">\r\n  <global-bean-decls>\r\n  </global-bean-decls>\r\n  <synthetic-methods>\r\n  </synthetic-methods>\r\n  <entrypoints>\r\n  </entrypoints>\r\n  <call-replacements>\r\n  </call-replacements>\r\n</wafl>\r\n";

    public JavaWaflGen(Stager stager, IScanTargetMinProxy proxy, IProgress progress) {
        this.m_stager = stager;
        this.m_proxy = proxy;
        this.m_xml_files = new ArrayList();
        this.m_progress = progress;
        if (this.m_progress == null) {
            this.m_progress = new NullProgress();
        }
    }

    public File getWaflFileForBucket(Bucket b, Stager stager) throws IOException {
        return new SliceWafl(this.getWaflFile(), stager, b).getWaflForSlice();
    }

    public synchronized File getWaflFile() {
        if (this.m_wafl_file == null) {
            this.m_wafl_file = new File(this.m_stager.getWaflGenPath(), "_frameworksCLI.wafl");
            this.waflgen();
        }
        return this.m_wafl_file;
    }

    private void waflgen() {
        try {
            int class_file_limit;
            int n = class_file_limit = SystemUtil.isPropertySet((String)"WAFL_CLASS_COUNT_LIMIT") ? Integer.parseInt(System.getProperty("WAFL_CLASS_COUNT_LIMIT")) : 5000;
            if (this.m_stager.getUserCodeFiles().size() > class_file_limit) {
                throw new AppScanException(Messages.getMessage("wafl.gen.files.limit.exceeded", this.m_stager.getUserCodeFiles().size()));
            }
            this.m_progress.setStatus(new Message(1, Messages.getMessage("wafl.gen.start", new Object[0])));
            long start = System.currentTimeMillis();
            WalaScope walascope = new WalaScope(this.m_stager, this.m_proxy);
            walascope.writeScope();
            this.m_xml_files.add(new WaflXmlLogConfig(this.m_stager));
            this.m_xml_files.add(new WaflXmlFrameworkInput(this.m_stager, this.m_wafl_file, this.m_xml_files.get(0).getXmlFile(), walascope.getOutputFile(), this.getCompilerVersion()));
            for (WaflXml xml : this.m_xml_files) {
                try {
                    xml.saveXml();
                }
                catch (TransformerException e) {
                    throw new AppScanException((Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    throw new AppScanException((Throwable)e);
                }
            }
            this.waflRunner(this.m_stager.getWaflGenPath());
            this.m_wafl_gen_time = System.currentTimeMillis() - start;
            System.out.println(Messages.getMessage("wafl.gen.time", this.m_wafl_file.getAbsolutePath(), this.m_wafl_gen_time));
        }
        catch (Exception e) {
            try {
                Files.write(Paths.get(this.m_stager.getWaflGenPath().getAbsolutePath(), "wafl.fail.log"), Messages.getMessage("wafl.gen.fail", new Object[0]).getBytes(), new OpenOption[0]);
                Files.write(Paths.get(this.m_wafl_file.getAbsolutePath(), new String[0]), BLANK_WAFL_CONTENTS.getBytes(), new OpenOption[0]);
            }
            catch (IOException e1) {
                CommonCore.getLogManager().log(e);
            }
        }
    }

    private void waflRunner(File dir) throws AppScanException, IOException, InterruptedException {
        final ArrayList stdout = new ArrayList();
        final ArrayList stderr = new ArrayList();
        String[] args = new String[]{new File(CommonCore.getDirectoryLocator().getProductRoot(), "jre" + File.separator + "bin" + File.separator + "java").getCanonicalPath(), "-ea", "-Xmx1200m", "-Dcom.ibm.wala.taint.sa.newPca=true", "-Dlog4j2.configurationFile=" + this.m_xml_files.get(0).getXmlFile().getCanonicalPath(), "-classpath", Paths.get(new File(CommonCore.getDirectoryLocator().getBin()).getParentFile().getAbsolutePath(), "lib").toFile().getAbsolutePath() + File.separatorChar + "*" + File.pathSeparatorChar + Paths.get(new File(CommonCore.getDirectoryLocator().getBin()).getParentFile().getAbsolutePath(), "walalib").toFile().getAbsolutePath() + File.separatorChar + "*" + File.pathSeparatorChar + Paths.get(new File(CommonCore.getDirectoryLocator().getBin()).getParentFile().getAbsolutePath(), "waflgens").toFile().getAbsolutePath() + File.separatorChar + "*", "com.ibm.appscan.frameworks.FrameworksCLI", "-input", this.m_xml_files.get(1).getXmlFile().getCanonicalPath()};
        StringBuilder str = new StringBuilder();
        for (String a : args) {
            str.append(a);
            str.append(" ");
        }
        Files.write(Paths.get(dir.getAbsolutePath(), "wafl_command.txt"), str.toString().getBytes(), new OpenOption[0]);
        ProcessRunner.StreamHandler outputHandler = new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                stdout.add(line);
            }
        };
        ArrayList<String> args_a = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            args_a.add(args[i]);
        }
        IOUtil.write(args_a, (File)new File(dir, dir.getName() + ".command.log"));
        ProcessRunner.StreamHandler errorHandler = new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                stderr.add(line);
            }
        };
        ProcessRunner r = new ProcessRunner(args_a);
        r.setDirectory(dir);
        int rc = r.exec(outputHandler, errorHandler);
        if (stdout.size() > 0) {
            IOUtil.write(stdout, (File)new File(dir, dir.getName() + ".wafl.prepare.stdout.log"));
        }
        if (stderr.size() > 0) {
            IOUtil.write(stderr, (File)new File(dir, dir.getName() + ".wafl.prepare.stderr.log"));
        }
        if (rc != 0) {
            throw new AppScanException(Messages.getMessage("wafl.prepare.err", dir.getPath(), rc));
        }
    }

    public long getWaflGenTime() {
        return this.m_wafl_gen_time;
    }

    private String getCompilerVersion() {
        String version = this.m_proxy.inheritedGetBuidInfo("compiler_version");
        if (version != null) {
            try {
                Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return version;
    }
}

