/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.wafl;

import com.hcl.irx.slice.wafl.WaflXml;
import com.hcl.irx.stage.Stager;
import com.ibm.appscan.common.CommonCore;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WaflXmlFrameworkInput
extends WaflXml {
    private Stager m_stager;
    private File m_wafl_file;
    private File m_wafl_config_file;
    private File m_wala_scope_file;
    private String m_compiler_version;

    public WaflXmlFrameworkInput(Stager stager, File waflFile, File waflConfigFile, File walaScopeFile, String compilerVersion) {
        super(stager);
        this.m_stager = stager;
        this.m_wafl_file = waflFile;
        this.m_wafl_config_file = waflConfigFile;
        this.m_wala_scope_file = walaScopeFile;
        this.m_compiler_version = compilerVersion == null ? "90" : compilerVersion;
    }

    @Override
    protected String getFileName() {
        return "wafl_framework.xml";
    }

    @Override
    protected void writeXml(Document doc) throws DOMException, IOException {
        Element mainRootElement = doc.createElementNS("http://www.ibm.com/FrameworkInput", "FrameworkInput");
        mainRootElement.setAttribute("type", "Java");
        doc.appendChild(mainRootElement);
        Element waflfile = doc.createElement("WaflFile");
        waflfile.appendChild(doc.createTextNode(this.m_wafl_file.getAbsolutePath()));
        mainRootElement.appendChild(waflfile);
        Element logconfig = doc.createElement("LogConfig");
        logconfig.appendChild(doc.createTextNode(this.m_wafl_config_file.getCanonicalPath()));
        mainRootElement.appendChild(logconfig);
        Element handlrjardir = doc.createElement("HandlerJarDir");
        handlrjardir.appendChild(doc.createTextNode(this.getHandlerJarDir_().getCanonicalPath()));
        mainRootElement.appendChild(handlrjardir);
        Element javainfo = doc.createElement("JavaInfo");
        Element webcontentroot = doc.createElement("WebContentRoot");
        webcontentroot.appendChild(doc.createTextNode(this.m_stager.getStageDirectory().getAbsolutePath()));
        javainfo.appendChild(webcontentroot);
        Element walascopefile = doc.createElement("WalaScopeFile");
        walascopefile.appendChild(doc.createTextNode(this.m_wala_scope_file.getCanonicalPath()));
        javainfo.appendChild(walascopefile);
        Element options = doc.createElement("Options");
        Element property1 = doc.createElement("Property");
        property1.setAttribute("name", "javaee.core.jsp.precompiler");
        property1.setAttribute("value", "tomcat");
        options.appendChild(property1);
        Element property2 = doc.createElement("Property");
        property2.setAttribute("name", "javaee.core.jsp.package");
        property2.setAttribute("value", "org.apache.jsp");
        options.appendChild(property2);
        Element property3 = doc.createElement("Property");
        property3.setAttribute("name", "javaee.core.replaceSetGetAttributeCalls");
        property3.setAttribute("value", "false");
        options.appendChild(property3);
        Element property4 = doc.createElement("Property");
        property4.setAttribute("name", "javaee.core.jsp.precompiler.version");
        property4.setAttribute("value", this.m_compiler_version);
        options.appendChild(property4);
        mainRootElement.appendChild(javainfo);
        javainfo.appendChild(options);
    }

    private File getHandlerJarDir_() {
        File fileWaflGen = new File(CommonCore.getDirectoryLocator().getProductRoot(), "waflgens");
        return fileWaflGen;
    }

    @Override
    protected boolean addDocType() {
        return false;
    }
}

