/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.clazz.info.SlicerClassInfo;
import com.ibm.appscan.common.utils.DirectoryUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class Bucket {
    private ArrayList<SlicerClassInfo> m_classes_in_bucket = new ArrayList();
    private HashSet<String> m_classes_in_bucket_names = new HashSet();
    private HashSet<String> m_classes_dependent_on = new HashSet();
    private int m_id = BUCKET_COUNTER.incrementAndGet();
    private File m_bucket_dir;
    private File m_base_dir;
    private int m_bucket_size = 1;
    private static AtomicInteger BUCKET_COUNTER = new AtomicInteger();

    public Bucket(File base_dir, int bucket_size) {
        this.m_base_dir = base_dir;
        this.m_bucket_size = bucket_size;
    }

    public void deleteBucket() throws IOException {
        BUCKET_COUNTER.decrementAndGet();
        DirectoryUtil.delete((File)this.getBucketDir());
    }

    public File getBucketDir() {
        if (this.m_bucket_dir == null) {
            this.m_bucket_dir = new File(this.m_base_dir, Integer.toString(this.m_id));
            this.m_bucket_dir.mkdirs();
        }
        return this.m_bucket_dir;
    }

    public int getId() {
        return this.m_id;
    }

    public ArrayList<SlicerClassInfo> getClassesInBucket() {
        return this.m_classes_in_bucket;
    }

    private boolean canAddClassToBucket(SlicerClassInfo ci) {
        if (this.m_classes_in_bucket.size() >= this.m_bucket_size) {
            return false;
        }
        if (this.m_classes_dependent_on.contains(ci.getClassName())) {
            return false;
        }
        for (String d : ci.getDependentClasses()) {
            if (!this.m_classes_dependent_on.contains(d)) continue;
            return false;
        }
        for (SlicerClassInfo bci : this.getClassesInBucket()) {
            if (!bci.getDependentClasses().contains(ci.getClassName())) continue;
            return false;
        }
        return true;
    }

    public boolean addClassToBucket(SlicerClassInfo ci) {
        return this.addClassToBucket(ci, false);
    }

    public boolean addClassToBucket(SlicerClassInfo ci, boolean force) {
        if (!this.m_classes_in_bucket_names.contains(ci.getClassName()) && (this.canAddClassToBucket(ci) || force)) {
            this.m_classes_in_bucket_names.add(ci.getClassName());
            this.m_classes_in_bucket.add(ci);
            this.m_classes_in_bucket.sort(new Comparator<SlicerClassInfo>(){

                @Override
                public int compare(SlicerClassInfo ci1, SlicerClassInfo ci2) {
                    return ci1.getClassName().compareTo(ci2.getClassName());
                }
            });
            this.m_classes_dependent_on.add(ci.getClassName());
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Bucket size:" + this.m_classes_in_bucket.size());
        ret.append(System.lineSeparator());
        for (SlicerClassInfo ci : this.getClassesInBucket()) {
            ret.append("\t" + ci.getClassName());
            ret.append(System.lineSeparator());
        }
        return ret.toString();
    }
}

