/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.wafl;

import com.hcl.irx.stage.java.JavaStager;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WaflReader {
    private Document m_wafl_document;
    private HashMap<String, HashSet<String>> m_dependencies;
    private HashSet<String> m_class_list;
    private HashMap<String, String> m_global_entries;
    private HashMap<String, String> m_class_name_to_global_entry;
    private JavaStager m_stager;

    public WaflReader(File file, JavaStager stager) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.m_wafl_document = builder.parse(file);
        this.m_wafl_document.getDocumentElement().normalize();
        this.m_stager = stager;
    }

    public synchronized HashMap<String, HashSet<String>> getDependencies() {
        if (this.m_dependencies == null) {
            this.m_dependencies = new HashMap();
            this.processSyntheticDependencies();
            this.processReplaceCalls();
        }
        return this.m_dependencies;
    }

    private void processSyntheticDependencies() {
        NodeList nList = this.m_wafl_document.getElementsByTagName("synthetic-method");
        for (int i = 0; i < nList.getLength(); ++i) {
            Element newElement;
            int j;
            HashSet<String> tmpDependencies = new HashSet<String>();
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element eElement = (Element)node;
            String className = this.getMethodNameFQDN(eElement.getAttribute("sig"));
            if (className != null) {
                tmpDependencies.add(className);
            }
            int dependencyAmount = eElement.getElementsByTagName("local-decl").getLength();
            for (j = 0; j < dependencyAmount; ++j) {
                newElement = (Element)eElement.getElementsByTagName("local-decl").item(j);
                tmpDependencies.add(newElement.getAttribute("type"));
            }
            dependencyAmount = eElement.getElementsByTagName("call").getLength();
            for (j = 0; j < dependencyAmount; ++j) {
                newElement = (Element)eElement.getElementsByTagName("call").item(j);
                tmpDependencies.add(this.getMethodNameFQDN(newElement.getAttribute("signature")));
            }
            this.addDependencies(tmpDependencies);
        }
    }

    private void processReplaceCalls() {
        NodeList nList = this.m_wafl_document.getElementsByTagName("replace-call");
        for (int i = 0; i < nList.getLength(); ++i) {
            HashSet<String> tmpDependencies = new HashSet<String>();
            Node node = nList.item(i);
            if (node.getNodeType() == 1) {
                int j;
                Element newElement;
                int j2;
                Element eElement = (Element)node;
                int dependencyAmount = eElement.getElementsByTagName("global").getLength();
                for (j2 = 0; j2 < dependencyAmount; ++j2) {
                    newElement = (Element)eElement.getElementsByTagName("global").item(j2);
                    if (!this.getGlobalEntries().containsKey(newElement.getAttribute("id"))) continue;
                    tmpDependencies.add(this.getGlobalEntries().get(newElement.getAttribute("id")));
                }
                dependencyAmount = eElement.getElementsByTagName("call-site-info").getLength();
                for (j2 = 0; j2 < dependencyAmount; ++j2) {
                    newElement = (Element)eElement.getElementsByTagName("call-site-info").item(j2);
                    if (this.getMethodNameFQDN(newElement.getAttribute("caller")) == null) continue;
                    tmpDependencies.add(this.getMethodNameFQDN(newElement.getAttribute("caller")));
                }
                NodeList calls = eElement.getElementsByTagName("call");
                for (j = 0; j < calls.getLength(); ++j) {
                    Element callElement;
                    String className;
                    node = calls.item(j);
                    if (node.getNodeType() != 1 || (className = this.getMethodNameFQDN((callElement = (Element)node).getAttribute("signature"))) == null) continue;
                    tmpDependencies.add(className);
                }
                for (j = 0; j < dependencyAmount; ++j) {
                    Element newElement2 = (Element)eElement.getElementsByTagName("global").item(j);
                    if (newElement2 == null || !this.getGlobalEntries().containsKey(newElement2.getAttribute("id"))) continue;
                    tmpDependencies.add(this.getGlobalEntries().get(newElement2.getAttribute("id")));
                }
            }
            this.addDependencies(tmpDependencies);
        }
    }

    private void addDependencies(HashSet<String> tmpDependencies) {
        ArrayList<String> deps = new ArrayList<String>(tmpDependencies);
        for (int k = 0; k < deps.size(); ++k) {
            if (!this.m_dependencies.containsKey(deps.get(k))) {
                this.m_dependencies.put(deps.get(k), new HashSet());
            }
            this.m_dependencies.get(deps.get(k)).addAll(this.getSubList(deps, k));
        }
    }

    public synchronized HashSet<String> getClassList() {
        if (this.m_class_list == null) {
            this.m_class_list = new HashSet();
            NodeList nList = this.m_wafl_document.getElementsByTagName("synthetic-method");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                if (node.getNodeType() != 1) continue;
                Element eElement = (Element)node;
                int dependencyAmount = eElement.getElementsByTagName("local-decl").getLength();
                for (int j = 0; j < dependencyAmount; ++j) {
                    Element newElement = (Element)eElement.getElementsByTagName("local-decl").item(j);
                    this.m_class_list.add(newElement.getAttribute("type"));
                }
            }
        }
        return this.m_class_list;
    }

    private HashMap<String, String> getGlobalEntries() {
        if (this.m_global_entries == null) {
            this.m_global_entries = new HashMap();
            NodeList nList = this.m_wafl_document.getElementsByTagName("global-bean-decls");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                if (node.getNodeType() != 1) continue;
                Element eElement = (Element)node;
                int dependencyAmount = eElement.getElementsByTagName("object-decl").getLength();
                for (int j = 0; j < dependencyAmount; ++j) {
                    Element newElement = (Element)eElement.getElementsByTagName("object-decl").item(j);
                    this.m_global_entries.put(newElement.getAttribute("id"), newElement.getAttribute("type"));
                }
            }
        }
        return this.m_global_entries;
    }

    public synchronized HashMap<String, String> getClassNameToGlobalEntryMap() {
        if (this.m_class_name_to_global_entry == null) {
            this.m_class_name_to_global_entry = new HashMap();
            for (String key : this.getGlobalEntries().keySet()) {
                this.m_class_name_to_global_entry.put(this.getGlobalEntries().get(key), key);
            }
        }
        return this.m_class_name_to_global_entry;
    }

    private String getMethodNameFQDN(String signature) {
        try {
            if (signature.startsWith("AppScan.Synthetic")) {
                return signature.substring(0, signature.indexOf("("));
            }
            Method m = MethodProvider.getMethod((String)signature, (Language.LANGUAGE)Language.LANGUAGE.JAVA);
            return m.getClassNameFqdn();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Set<String> getSubList(ArrayList<String> dependencies, int index) {
        List<String> listOne = dependencies.subList(0, index);
        List<String> listTwo = dependencies.subList(index + 1, dependencies.size());
        HashSet<String> set = new HashSet<String>(listOne);
        set.addAll(listTwo);
        return set;
    }
}

