/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.data;

import com.ibm.appscan.common.Language;
import java.util.ArrayList;

public class MarkupActiveFeatures {
    private Language.LANGUAGE m_lang;
    private String m_dir;
    private ArrayList<MARKUP_FEATURES> m_features;

    public MarkupActiveFeatures(Language.LANGUAGE lang) {
        this.m_lang = lang;
    }

    protected Language.LANGUAGE getLanguage() {
        return this.m_lang;
    }

    public ArrayList<MARKUP_FEATURES> getFeatures() {
        if (this.m_features == null) {
            this.m_features = new ArrayList();
            this.m_features.add(MARKUP_FEATURES.METHOD_NAME);
            this.m_features.add(MARKUP_FEATURES.METHOD_ARGS);
            this.m_features.add(MARKUP_FEATURES.METHOD_RETURN);
            this.m_features.add(MARKUP_FEATURES.METHOD_NAME_NEG);
            this.m_features.add(MARKUP_FEATURES.METHOD_ARGS_NEG);
            this.m_features.add(MARKUP_FEATURES.METHOD_RETURN_NEG);
            this.m_features.add(MARKUP_FEATURES.ARG_COUNT);
            this.m_features.add(MARKUP_FEATURES.ALLOWS_RETURN);
            if (this.m_lang == Language.LANGUAGE.JAVA || this.m_lang == Language.LANGUAGE.DOT_NET) {
                this.m_features.add(MARKUP_FEATURES.METHOD_CLASS);
                this.m_features.add(MARKUP_FEATURES.METHOD_PACKAGE);
                this.m_features.add(MARKUP_FEATURES.METHOD_CLASS_NEG);
                this.m_features.add(MARKUP_FEATURES.METHOD_PACKAGE_NEG);
                this.m_features.add(MARKUP_FEATURES.META);
                this.m_features.add(MARKUP_FEATURES.CONSTRUCTOR);
                this.m_features.add(MARKUP_FEATURES.GETTER);
                this.m_features.add(MARKUP_FEATURES.SETTER);
                this.m_features.add(MARKUP_FEATURES.STATIC);
            }
            this.m_features.add(MARKUP_FEATURES.ALLOWS_TAINT_THROUGH_ARG);
            this.m_features.add(MARKUP_FEATURES.ALLOWS_TAINT_THROUGH_RETURN);
            this.m_features.add(MARKUP_FEATURES.TYPE);
            this.m_features.add(MARKUP_FEATURES.TECH_MECH);
        }
        return this.m_features;
    }

    public String getDirString() {
        if (this.m_dir == null) {
            StringBuffer str = new StringBuffer();
            str.append(this.getLanguage());
            str.append("_");
            for (MARKUP_FEATURES feature : this.getFeatures()) {
                int i = 0;
                for (MARKUP_FEATURES f : MARKUP_FEATURES.values()) {
                    if (feature == f) {
                        str.append(i);
                        str.append("_");
                    }
                    ++i;
                }
            }
            str.deleteCharAt(str.length() - 1);
            this.m_dir = str.toString();
        }
        return this.m_dir;
    }

    public static enum MARKUP_FEATURES {
        TAINT,
        TAINT_SOURCE,
        SOURCE,
        SINK,
        SINK_ARG,
        SINK_SEV,
        VULN_TYPE,
        GETTER,
        SETTER,
        CONSTRUCTOR,
        METHOD,
        METHOD_NAME,
        METHOD_ARGS,
        METHOD_RETURN,
        METHOD_PACKAGE,
        METHOD_CLASS,
        METHOD_NEG,
        METHOD_NAME_NEG,
        METHOD_ARGS_NEG,
        METHOD_RETURN_NEG,
        METHOD_PACKAGE_NEG,
        METHOD_CLASS_NEG,
        ALLOWS_RETURN,
        ALLOWS_TAINT_THROUGH_ARG,
        ALLOWS_TAINT_THROUGH_RETURN,
        ARG_COUNT,
        STATIC,
        TYPE,
        META,
        TECH_MECH,
        METHOD_PART1,
        METHOD_PART2,
        METHOD_PART3,
        SIMPLE_ARG_1,
        SIMPLE_ARG_2,
        SIMPLE_ARG_3;

    }
}

