/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.trainer.MarkupTrainer;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class TaintTrainer
extends MarkupTrainer
implements Serializable {
    private static final long serialVersionUID = 1049702524220595239L;

    @Override
    public boolean useNoMarkupMethods() {
        return false;
    }

    @Override
    protected boolean addStrings() {
        return true;
    }

    @Override
    public String getMarkupString(Method m) {
        StringBuffer taint = new StringBuffer();
        ArrayList<String> taints = new ArrayList<String>();
        if (m.getTaints().size() == 0) {
            return "0";
        }
        HashMap<String, Taint> ts = new HashMap<String, Taint>();
        for (Taint taint2 : m.getTaints()) {
            ts.put(taint2.toString(m), taint2);
        }
        for (Taint taint3 : ts.values()) {
            taints.add(this.getTaintString(taint3, m));
        }
        Collections.sort(taints);
        for (String string : taints) {
            taint.append(string);
            taint.append(";");
        }
        if (taint.length() > 0) {
            taint.deleteCharAt(taint.length() - 1);
        }
        return taint.toString();
    }

    private String getTaintString(Taint t, Method m) {
        StringBuffer taint = new StringBuffer();
        if (t.isNotSusceptibleToTaint()) {
            taint.append("dnp");
        } else {
            String src = t.getSourceParam().toString(m);
            src = src.replaceAll("-", "=");
            src = src.replaceAll(",", "_");
            String dst = t.getDstParam().toString(m);
            dst = dst.replaceAll("-", "=");
            dst = dst.replaceAll(",", "_");
            taint.append(src);
            taint.append("-");
            taint.append(dst);
            taint.append("-");
            if (t.isReturn()) {
                taint.append("1");
            } else {
                taint.append("0");
            }
        }
        return taint.toString();
    }

    @Override
    protected MarkupActiveFeatures.MARKUP_FEATURES getFeature() {
        return MarkupActiveFeatures.MARKUP_FEATURES.TAINT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String predict_(Method m) throws IfaException {
        try {
            int prediction = (int)this.getModel().predict(this.getVector(this.getTestMethod(m)));
            Taint t = this.getTaintFromString(this.getIdMap().get(prediction));
            if (t.isValidForMethod(m)) {
                return this.getIdMap().get(prediction);
            }
            Taint t2 = new Taint(t.getSourceParam().toSimplifiedString(), t.getDstParam().toSimplifiedString(), t.isReturn());
            if (t2.isValidForMethod(m)) {
                return this.getTaintString(t2, m);
            }
            LinkedHashMap probabilities = this.getModel().getSortedProbabilities(this.getVector(this.getTestMethod(m)));
            Iterator iterator = probabilities.keySet().iterator();
            do {
                if (!iterator.hasNext()) {
                    return this.getIdMap().get(prediction);
                }
                double key = (Double)iterator.next();
                t = this.getTaintFromString(this.getIdMap().get((int)key));
                if (!t.isValidForMethod(m)) continue;
                return this.getIdMap().get((int)key);
            } while (!(t2 = new Taint(t.getSourceParam().toSimplifiedString(), t.getDstParam().toSimplifiedString(), t.isReturn())).isValidForMethod(m));
            return this.getTaintString(t2, m);
        }
        catch (BadMarkupException e) {
            throw new IfaException((Throwable)e);
        }
    }

    @Override
    public boolean hasMarkup(Method m) {
        return m.getTaints().size() > 0;
    }

    @Override
    public String getMarkupFromRule(Method m) throws MarkupException {
        StringBuffer ret = new StringBuffer();
        HashMap<String, Taint> taints = new HashMap<String, Taint>();
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            try {
                Taint t = new Taint(r.getTaintRule().getSourceParameter(), r.getTaintRule().getDestinationParameter(), r.getTaintRule().isReturn());
                if (t.isNotSusceptibleToTaint()) {
                    return "dnp";
                }
                if (taints.containsKey(t.toString(m))) continue;
                taints.put(t.toString(m), t);
            }
            catch (BadMarkupException e) {
                throw new MarkupException(e);
            }
        }
        for (Taint t : taints.values()) {
            ret.append(this.getTaintString(t, m));
            ret.append(";");
        }
        if (ret.length() > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    @Override
    protected void initRules() throws MarkupException {
        try {
            Rule r = new Rule();
            r.setRuleName("boolean only args - void return - all");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("Constructor");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_CONSTRUCTOR);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("number only args - void return - all");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - string return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("string");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - number return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("log APIs - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("log");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - boolean return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("0 args - void return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setRuleValue("0");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("setter - more than 1 non-boolean, non-number arg - all");
            BaseLogicGate g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            Rule r1 = g.createRule();
            r1.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r1.getMethodRule().getReturnRule().setRuleValue("void");
            Rule r2 = g.createRule();
            r2.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r2.getMethodRule().getArgumentRule().setRuleValue("number");
            Rule r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r3.getMethodRule().getArgumentRule().setRuleValue("boolean");
            Rule r4 = g.createRule();
            r4.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
            r4.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("setter - number args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("setter - boolean args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_SETTER);
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("getter 0 args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_GETTER);
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("getter - 1 non-boolean, non-number arg - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("get");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_GREATER_THAN);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r1 = g.createRule();
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r1.getMethodRule().getReturnRule().setRuleValue("void");
            r1 = g.createRule();
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r1.getMethodRule().getReturnRule().setRuleValue("number");
            r1 = g.createRule();
            r1.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r1.getMethodRule().getReturnRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("-init constructor with non-boolean\non-number arguments - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r2.getMethodRule().getSignatureRule().setRuleValue("-init");
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r2.getMethodRule().getReturnRule().setRuleValue("id");
            r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r3.getMethodRule().getArgumentRule().setRuleValue("number");
            r4 = g.createRule();
            r4.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r4.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("-init constructor with boolean\number arguments - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r2.getMethodRule().getSignatureRule().setRuleValue("-init");
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r2.getMethodRule().getReturnRule().setRuleValue("id");
            r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r3.getMethodRule().getArgumentRule().setRuleValue("number");
            r4 = g.createRule();
            r4.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r4.getMethodRule().getArgumentRule().setRuleValue("boolean");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("ForKey: - non-void return - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r2.getMethodRule().getReturnRule().setRuleValue("number");
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r3.getMethodRule().getSignatureRule().setRuleValue("ForKey:");
            r3.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_EQUAL);
            r3.getMethodRule().getReturnRule().setRuleValue("void");
            r4 = g.createRule();
            r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r4.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("object arg - void return - objectivec");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("object");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(1);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("1");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("object return - 0 args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("object");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("handle arg - void return - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("void");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("handle");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(1);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("1");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("handle return - 0 args - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("handle");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("static 0 args - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r2 = g.createRule();
            r2.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_STATIC);
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r3.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("static 1 arg - void, boolean or number return - all");
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(1);
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r2 = g.createRule();
            r2.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.IS_STATIC);
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r3.getMethodRule().getSignatureRule().setRuleValue("+");
            BaseLogicGate g2 = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r4 = g2.createRule();
            r4.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r4.getMethodRule().getReturnRule().setRuleValue("boolean");
            Rule r5 = g2.createRule();
            r5.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r5.getMethodRule().getReturnRule().setRuleValue("void");
            Rule r6 = g2.createRule();
            r6.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r6.getMethodRule().getReturnRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("no args handle return - all");
            r.getSpecialCaseRule().setSpecialCase(VDBEnums.SPECIAL_CASES.NOT_STATIC);
            r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
            r.getMethodRule().getArgCountRule().setArgCountValue(0);
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("handle");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("ForKey: number return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("ForKey:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("default to return - all");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.OR);
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("fromJson");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("toJson");
            r1 = g.createRule();
            r1.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r1.getMethodRule().getSignatureRule().setRuleValue("deserialize");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("ForKey: - boolean return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("boolean");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("ForKey:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("number args - number return - objective c");
            r.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getReturnRule().setRuleValue("number");
            r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r.getMethodRule().getArgumentRule().setRuleValue("number");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("numberOfRowsInSection: - objective c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("numberOfRowsInSection:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("heightForRowAtIndexPath: - objective c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("heightForRowAtIndexPath:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("cellForRowAtIndexPath: - objective c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.ENDS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("cellForRowAtIndexPath:");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("this");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("CompareTo - dnp");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("CompareTo");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("CompareTo - dnp");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("compareTo");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("Static For - id return - objectivec");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r2 = g.createRule();
            r2.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r2.getMethodRule().getReturnRule().setRuleValue("id");
            r3 = g.createRule();
            r3.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.CONTAINS);
            r3.getMethodRule().getSignatureRule().setRuleValue("For");
            r4 = g.createRule();
            r4.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r4.getMethodRule().getSignatureRule().setRuleValue("+");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("-stringByA method name - objetive c");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("-stringByA");
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("encode method name - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("encode");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("create method name - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("create");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("dencode method name - all");
            r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.STARTS_WITH);
            r.getMethodRule().getSignatureRule().setRuleValue("dencode");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("default");
            r.getTaintRule().setReturn(true);
            this.getRules().add(r);
            r = new Rule();
            r.setRuleName("log NSString*;... - objective c");
            g = r.createLogicGate(VDBEnums.RULE_GATE_TYPE.AND);
            r3 = g.createRule();
            r3.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r3.getMethodRule().getArgumentRule().setArgPos(0);
            r3.getMethodRule().getArgumentRule().setRuleValue("NSString*");
            r3.getMethodRule().getReturnRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r3.getMethodRule().getReturnRule().setRuleValue("void");
            r4 = g.createRule();
            r4.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
            r4.getMethodRule().getArgumentRule().setRuleValue("...");
            r4.getMethodRule().getArgumentRule().setArgPos(1);
            r.getTaintRule().setDestinationParameter("this");
            r.getTaintRule().setSourceParameter("all");
            r.getTaintRule().setReturn(false);
            this.getRules().add(r);
            for (int i = 0; i < 5; ++i) {
                r = new Rule();
                r.setRuleName("Nserror_" + i + " - objective c");
                r.getMethodRule().getArgumentRule().setRuleOperator(VDBEnums.RULE_OPERATOR.EQUALS);
                r.getMethodRule().getArgumentRule().setRuleValue("NSError**");
                r.getMethodRule().getArgumentRule().setArgPos(i);
                r.getMethodRule().getSignatureRule().setRuleOperator(VDBEnums.RULE_OPERATOR.DOES_NOT_START_WITH);
                r.getMethodRule().getSignatureRule().setRuleValue("+");
                r.getTaintRule().setDestinationParameter(Integer.toString(i + 1));
                r.getTaintRule().setSourceParameter("this");
                r.getTaintRule().setReturn(false);
                this.getRules().add(r);
            }
        }
        catch (BadRuleException e) {
            throw new MarkupException(e);
        }
    }

    public boolean areTaintsSame(String t_string, String t2_string, Method m) throws MarkupException {
        ArrayList<Taint> t_taints = this.getTaintsFromString(t_string);
        ArrayList<Taint> t2_taints = this.getTaintsFromString(t2_string);
        return t_taints.size() == 1 && t2_taints.size() == 1 && t_taints.get(0).compareTo(t2_taints.get(0), m) == 0;
    }

    public boolean isSuperSet(String orig, String new_taint) throws MarkupException {
        return this.getTaintFromString(new_taint).isSuperSet(this.getTaintFromString(orig));
    }

    public ArrayList<Taint> getTaintsFromString(String markupString) throws MarkupException {
        ArrayList<Taint> ret = new ArrayList<Taint>();
        if (markupString.contains(";")) {
            for (String t : markupString.split(";")) {
                ret.add(this.getTaintFromString(t));
            }
        } else {
            ret.add(this.getTaintFromString(markupString));
        }
        return ret;
    }

    public Taint getTaintFromString(String t) throws MarkupException {
        String ret;
        String dst;
        String src;
        if (t.contains("-")) {
            src = t.split("-")[0];
            dst = t.split("-")[1];
            ret = t.split("-")[2];
            src = src.replaceAll("=", "-");
            src = src.replaceAll("_", ",");
            dst = dst.replaceAll("=", "-");
            dst = dst.replaceAll("_", ",");
        } else {
            src = "none";
            dst = "none";
            ret = "0";
        }
        try {
            return new Taint(src, dst, ret.equals("1"));
        }
        catch (BadMarkupException e) {
            throw new MarkupException(e);
        }
    }

    @Override
    protected void applyMarkup(Method m, String markupString) throws MarkupException, BadMarkupException {
        for (Taint t : this.getTaintsFromString(markupString)) {
            m.addTaint(t.getSourceParam().toString(m), t.getDstParam().toString(m), t.isReturn());
        }
    }

    @Override
    protected void initBulkRules() throws MarkupException, BadRuleException {
        for (VDBEnums.RULE_OPERATOR op : VDBEnums.RULE_OPERATOR.values()) {
            Rule r = new Rule();
            r.setRuleName("method name " + op.getSimpleName() + " - dnp rule");
            r.getTaintRule().setDestinationParameter("none");
            r.getTaintRule().setSourceParameter("none");
            r.getTaintRule().setReturn(false);
            this.processBulkMethodNameRule(r, new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + "rules" + File.separator, "method_" + op.getSimpleName() + "_" + this.getMarkupType() + "_dnp.rule"), op, this.getRules());
        }
    }

    @Override
    protected Rule initBulkRule() throws BadRuleException {
        return new Rule();
    }

    @Override
    protected void initAntiRules() throws MarkupException {
    }

    @Override
    protected String getMarkupType() {
        return "taint";
    }

    @Override
    protected String getAntiMatch() {
        return null;
    }
}

