/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.config;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.LogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.EngineMessage;
import com.ibm.appscan.common.model.EngineMessageReader;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.utils.StateUtil;
import com.ibm.appscan.common.model.utils.VisitingWriter;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.model.xml.TargetInfoReader;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.PackageUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.VersionUtil;
import com.ibm.appscan.config.Messages;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.internal.config.IRGenerator;
import com.ibm.appscan.internal.config.LogMergerManager;
import com.ibm.appscan.internal.config.LogZipper;
import com.ibm.appscan.internal.config.ScanModelVisitorWithProgress;
import com.ibm.appscan.internal.config.model.ScanReader;
import com.ibm.appscan.internal.config.model.TargetInfoWriter;
import com.ibm.appscan.internal.config.model.TargetsReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class Configurator {
    private IScan m_scan;
    private int m_messageCount = -1;
    private File m_logDir = null;
    private File m_logFile = null;
    private File m_configDir = null;
    private File m_logmerger_dest = null;
    private List<EngineMessage> m_engine_messages = null;

    public Configurator(IScan scan) {
        this.m_scan = scan;
    }

    public void setLogDir(File logDir) {
        this.m_logDir = logDir;
    }

    public File getLogFile() {
        return this.m_logFile;
    }

    public void setConfigDir(File configDir) {
        this.m_configDir = configDir;
    }

    public static Configurator load(IScan scan, final IProgress progress) throws IOException {
        if (scan.getState() != ITransformable.State.NEW) {
            throw new IllegalStateException(Messages.getMessage("err.load", new Object[0]));
        }
        SaveLocation location = scan.getSaveLocation();
        if (location == null) {
            throw new IOException(com.ibm.appscan.common.Messages.getMessage((String)"no.save.location", (Object[])new Object[0]));
        }
        File directory = location.getWorkLocation();
        boolean dirExists = directory.exists();
        try {
            if (!dirExists) {
                PackageUtil.unpack((File)location.getFile(), (File)directory);
            }
            scan.getLogManager().init();
            scan.getLogManager().log(new Message(1, Messages.getMessage("loading", location)));
            TargetsReader dotTargets = new TargetsReader(directory);
            dotTargets.read();
            for (Map.Entry<File, Boolean> entry : dotTargets.getTargets().entrySet()) {
                DiscoveryCore.findScanTargets((IScan)scan, (File)entry.getKey(), (boolean)entry.getValue(), (IProgress)progress);
            }
            scan.markAsClean();
            final int[] configuredTargets = new int[]{0};
            int i = 0;
            for (IScanTarget target : scan.getScanTargets()) {
                String name = dotTargets.getWorkingDirectoryNames().get(i++);
                if (name != null) {
                    target.setWorkingDirectoryName(name);
                }
                ScanModelVisitor visitor = new ScanModelVisitor(){

                    public void visit(IScanTarget target) {
                        if (new File(this.getWorkingDirectory(), ".transformed").exists()) {
                            target.findScanFiles(progress);
                            target.setTransformed(true);
                        } else {
                            configuredTargets[0] = configuredTargets[0] + 1;
                        }
                    }
                };
                visitor.init(directory);
                target.accept(visitor);
            }
            if (configuredTargets[0] == 0) {
                ScanReader dotScan = new ScanReader(directory);
                dotScan.read();
                if (dotScan.isTransformed()) {
                    scan.setTransformed(true);
                }
            }
            return new Configurator(scan);
        }
        catch (IOException e) {
            if (!dirExists && directory.exists()) {
                ((LogManager)scan.getLogManager()).close();
                DirectoryUtil.delete((File)directory);
            }
            throw e;
        }
        catch (XMLStreamException e) {
            if (!dirExists && directory.exists()) {
                ((LogManager)scan.getLogManager()).close();
                DirectoryUtil.delete((File)directory);
            }
            throw new IOException(e);
        }
    }

    public int discover(File input, boolean outputsOnly, IProgress progress) {
        return DiscoveryCore.findScanTargets((IScan)this.m_scan, (File)input, (boolean)outputsOnly, (IProgress)progress);
    }

    private File[] fetchFiles(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        return files == null ? new File[]{} : files;
    }

    private LogZipper copyLogs(File logDir) {
        String baseName;
        int dot;
        this.copyAdditionalLogs();
        File theFile = this.m_scan.getSaveLocation().getFile();
        File destination = theFile.getParentFile();
        if (this.m_logDir != null && !this.m_logDir.equals(logDir)) {
            this.m_logDir.mkdirs();
            if (this.m_logDir.isDirectory()) {
                destination = this.m_logDir;
            }
        }
        if ((dot = (baseName = theFile.getName()).lastIndexOf(46)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        final LogZipper zipper = new LogZipper(destination, baseName);
        LogManager log = (LogManager)this.m_scan.getLogManager();
        log.flush();
        zipper.add(log.getLogFile(), baseName + ".log");
        ScanModelVisitor visitor = new ScanModelVisitor(){

            protected void visit(IScanTarget target) {
                for (File file : Configurator.this.fetchFiles(this.getWorkingDirectory())) {
                    if (!file.getName().toLowerCase().endsWith(".log")) continue;
                    zipper.add(file, this.getWorkingDirectoryPath() + '/' + file.getName());
                }
            }
        };
        this.gatherSliceLogs(new File(this.m_scan.getSaveLocation().getWorkLocation(), "slices"), zipper);
        visitor.init(this.m_scan.getSaveLocation().getWorkLocation());
        this.m_scan.accept(visitor);
        return zipper;
    }

    private void gatherSliceLogs(File dir, LogZipper zipper) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                this.gatherSliceLogs(f, zipper);
            }
        } else if (dir.getName().endsWith("_logs.zip")) {
            zipper.add(dir, new File(dir.getPath().substring(dir.getPath().indexOf("slices"))).toString());
        }
    }

    public boolean validate(IProgress progress) throws IOException {
        return this.validate(progress, false);
    }

    public boolean validate(IProgress progress, boolean isDryRun) throws IOException {
        SaveLocation location = this.m_scan.getSaveLocation();
        File directory = location.getWorkLocation();
        boolean dirExists = directory.exists();
        File dotFailed = new File(directory, ".failed");
        if (dirExists && dotFailed.exists()) {
            dotFailed.delete();
        }
        this.m_scan.getLogManager().log(new Message(1, Messages.getMessage("validating", new Object[0])));
        this.m_messageCount = this.m_scan.getLogManager().getMessages().size();
        ScanModelVisitorWithProgress visitor = new ScanModelVisitorWithProgress(progress, isDryRun, this.m_scan);
        this.m_scan.accept((ScanModelVisitor)visitor);
        boolean onlyOpenSource = SystemUtil.isOpenSourceOnly() || visitor.onlyOpenSource();
        boolean isValid = visitor.isValid();
        if (this.noDataFlowTargets(directory)) {
            if (visitor.getNumFiles() == 0) {
                if (SystemUtil.isOpenSourceOnly()) {
                    this.m_scan.getLogManager().log(new Message(4, VersionUtil.replaceEnvPath((String)(Messages.getMessage("err.no.files.oso", new Object[0]) + " " + Messages.getMessage("supported.files.oso", new Object[0])))));
                } else if (SystemUtil.IRGenClient.AppScanGo.name().equalsIgnoreCase(System.getenv("APPSCAN_IRGEN_CLIENT"))) {
                    this.m_scan.getLogManager().log(new Message(4, VersionUtil.replaceEnvPath((String)(Messages.getMessage("err.no.files.appscan.go", new Object[0]) + " " + Messages.getMessage("supported.files", new Object[0])))));
                } else if (SystemUtil.isCommonEngine()) {
                    this.m_scan.getLogManager().log(new Message(4, VersionUtil.replaceEnvPath((String)(Messages.getMessage("err.no.files.common.engine", new Object[0]) + " " + Messages.getMessage("supported.files.source", new Object[0])))));
                } else {
                    this.m_scan.getLogManager().log(new Message(4, VersionUtil.replaceEnvPath((String)(Messages.getMessage("err.no.files", new Object[0]) + " " + Messages.getMessage("supported.files", new Object[0])))));
                }
                isValid = false;
                System.setProperty("DELETE_IRX", "");
            } else if (onlyOpenSource) {
                if (SystemUtil.isPropertySet((String)"FORCE_OPENSOURCE_ONLY") || SystemUtil.isOpenSourceOnly()) {
                    new File(directory, ".sources").createNewFile();
                } else {
                    this.m_scan.getLogManager().log(new Message(4, VersionUtil.replaceEnvPath((String)(Messages.getMessage("err.only.opensource", new Object[0]) + " " + Messages.getMessage("supported.files", new Object[0])))));
                    isValid = false;
                    System.setProperty("DELETE_IRX", "");
                }
            }
        }
        if (System.getProperty("dryRun") == null) {
            this.zipLogs();
        }
        if (!isValid && dirExists) {
            dotFailed.createNewFile();
            this.markAsFailed(progress);
        }
        return isValid;
    }

    public void zipLogs() throws IOException {
        LogZipper zipper = this.copyLogs(new File(this.m_scan.getSaveLocation().getWorkLocation(), "logs"));
        zipper.zipIt();
        this.m_logFile = zipper.getFile();
        this.m_logmerger_dest = new File(this.m_scan.getSaveLocation().getWorkLocation(), "logs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(IProgress progress) throws IOException, AppScanException {
        boolean success;
        SaveLocation location;
        block28: {
            if (this.m_scan.getState() != ITransformable.State.CONFIGURED || this.m_scan.isDirty()) {
                throw new IllegalStateException(Messages.getMessage("err.transform", new Object[0]));
            }
            if (!this.validate(progress)) {
                return false;
            }
            this.m_scan.getLogManager().log(new Message(1, Messages.getMessage("generating.ir", new Object[0])));
            location = this.m_scan.getSaveLocation();
            success = true;
            int rc = -1;
            try {
                LogMergerManager manager;
                LogZipper zipper2;
                File logDir;
                TargetInfoWriter writer = new TargetInfoWriter();
                new VisitingWriter((IScanModelVisitable)this.m_scan, location, (ModelWriter)writer).write(progress);
                if (writer.hasErrors()) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    if (!SystemUtil.isOpenSourceOnly()) {
                        this.copyAdditionalExactFileIfPresent(this.m_configDir, "custom.apsettings", location.getWorkLocation());
                        this.copyAdditionalExactFileIfPresent(this.m_configDir, "rule_properties.xml", location.getWorkLocation());
                        this.copyAdditionalFilesIfPresent(this.m_configDir, ".vdb", location.getWorkLocation());
                        this.copyAdditionalFilesIfPresent(this.m_configDir, "_custom_validation.xml", location.getWorkLocation());
                        rc = new IRGenerator(location, this.m_configDir).run(progress);
                    } else {
                        rc = 0;
                    }
                    logDir = new File(location.getWorkLocation(), "logs");
                    zipper2 = this.copyLogs(logDir);
                    manager = new LogMergerManager(this.m_logmerger_dest, this.m_scan);
                }
                catch (AppScanException e) {
                    LogMergerManager manager2;
                    LogZipper zipper;
                    File logDir2;
                    try {
                        rc = e.getErrorCode();
                        if (SystemUtil.isCommonEngine() && rc != 1) {
                            throw e;
                        }
                        if (rc == 2) {
                            for (IScanTarget target : this.m_scan.getScanTargets()) {
                                if (target.getStrategy() != null && target.getStrategy().collectsScanFiles()) {
                                    rc = 0;
                                } else {
                                    if (target.getChildren() == null) continue;
                                    for (IScanTarget childTarget : target.getChildren()) {
                                        if (childTarget.getStrategy() == null || !childTarget.getStrategy().collectsScanFiles()) continue;
                                        rc = 0;
                                        break;
                                    }
                                    if (rc != 0) continue;
                                }
                                break;
                            }
                        } else {
                            if (rc != 1) {
                                throw e;
                            }
                            success = false;
                        }
                        logDir2 = new File(location.getWorkLocation(), "logs");
                        zipper = this.copyLogs(logDir2);
                        manager2 = new LogMergerManager(this.m_logmerger_dest, this.m_scan);
                    }
                    catch (Throwable throwable) {
                        File logDir3 = new File(location.getWorkLocation(), "logs");
                        LogZipper zipper3 = this.copyLogs(logDir3);
                        LogMergerManager manager3 = new LogMergerManager(this.m_logmerger_dest, this.m_scan);
                        for (File log : manager3.getMergedFiles()) {
                            zipper3.add(log);
                        }
                        for (File log : this.fetchFiles(logDir3)) {
                            zipper3.add(log);
                        }
                        zipper3.zipIt();
                        this.m_logFile = zipper3.getFile();
                        throw throwable;
                    }
                    for (File log : manager2.getMergedFiles()) {
                        zipper.add(log);
                    }
                    for (Iterator<Object> iterator : this.fetchFiles(logDir2)) {
                        zipper.add((File)((Object)iterator));
                    }
                    zipper.zipIt();
                    this.m_logFile = zipper.getFile();
                    break block28;
                }
                for (File log : manager.getMergedFiles()) {
                    zipper2.add(log);
                }
                for (File file : this.fetchFiles(logDir)) {
                    zipper2.add(file);
                }
                zipper2.zipIt();
                this.m_logFile = zipper2.getFile();
            }
            finally {
                File directory = location.getWorkLocation();
                if (rc != 0 && rc != 1 && directory.exists()) {
                    new File(directory, ".failed").createNewFile();
                    this.markAsFailed(progress);
                    success = false;
                }
            }
        }
        this.m_scan.setTransformed(true);
        ScanModelVisitor visitor = new ScanModelVisitor(){

            public void visit(IScanTarget target) {
                if (!SystemUtil.isOpenSourceOnly() || SystemUtil.isOpenSourceOnly() && target != null && target.getClass().getName().contains("ThirdPartyLibScanTarget")) {
                    StateUtil.updateStateMarker((File)this.getWorkingDirectory(), (IScanTarget)target);
                }
            }
        };
        visitor.init(location.getWorkLocation());
        this.m_scan.accept(visitor);
        return success && !this.m_scan.isIncomplete();
    }

    public List<Message> getWarnings() {
        ArrayList<Message> warnings = new ArrayList<Message>();
        if (this.m_messageCount != -1) {
            List messages = this.m_scan.getLogManager().getMessages();
            for (int i = this.m_messageCount; i < messages.size(); ++i) {
                Message message = (Message)messages.get(i);
                if (message.getSeverity() != 2) continue;
                warnings.add(message);
            }
        }
        return warnings;
    }

    public List<EngineMessage> getMessages() {
        if (this.m_engine_messages == null) {
            this.m_engine_messages = new ArrayList<EngineMessage>();
            EngineMessageReader reader = null;
            try {
                File irgenLog = new File(this.m_scan.getSaveLocation().getWorkLocation().getCanonicalFile() + File.separator + "StaticAnalyzer-IRGen.xml");
                if (irgenLog.exists()) {
                    reader = new EngineMessageReader(irgenLog);
                    reader.read();
                    this.m_engine_messages.addAll(reader.getMessages());
                }
                for (Language.LANGUAGE l : Language.LANGUAGE.values()) {
                    File slices = Paths.get(this.m_scan.getSaveLocation().getWorkLocation().getPath(), "slices", l.toString()).toFile();
                    if (!slices.exists()) continue;
                    for (File slice_dir : slices.listFiles()) {
                        File slice_messages = new File(slice_dir.getPath(), "StaticAnalyzer-IRGen.xml");
                        if (!slice_messages.exists()) continue;
                        reader = new EngineMessageReader(slice_messages);
                        reader.read();
                        this.m_engine_messages.addAll(reader.getMessages());
                    }
                }
            }
            catch (IOException | XMLStreamException e) {
                this.m_scan.getLogManager().log(new Message(2, e.getMessage()));
            }
        }
        return this.m_engine_messages;
    }

    public Map<IScanTarget, List<String>> getMissingDependencies() {
        Map<IScanFile, IScanTarget> scanFiles = this.getScanFiles();
        HashMap<IScanTarget, List<String>> missingRefMap = new HashMap<IScanTarget, List<String>>();
        HashMap defaultPackages = new HashMap();
        if (this.m_engine_messages == null) {
            this.getMessages();
        }
        for (EngineMessage message : this.m_engine_messages) {
            if (!message.getType().equalsIgnoreCase("IRGenSkippingMethod")) continue;
            String missingClassName = message.getAttributeValue("missing_classname");
            String currentClassName = message.getAttributeValue("current_classname");
            if (missingClassName == null || currentClassName == null) continue;
            boolean isDefaultPackage = false;
            String source = message.getAttributeValue("filename");
            if (!source.endsWith(".class")) {
                source = source.substring(0, source.lastIndexOf(".")) + ".class";
            }
            String reference = null;
            if (missingClassName.lastIndexOf(".") == -1) {
                reference = missingClassName;
                isDefaultPackage = true;
            } else {
                reference = missingClassName.substring(0, missingClassName.lastIndexOf(".") + 1) + "*";
            }
            Iterator<IScanFile> iter = scanFiles.keySet().iterator();
            boolean found = false;
            while (!found && iter.hasNext()) {
                IScanFile scanFile = iter.next();
                if (!Paths.get(scanFile.getFile().getPath(), new String[0]).endsWith(source)) continue;
                IScanTarget target = scanFiles.get(scanFile);
                if (!missingRefMap.containsKey(target)) {
                    ArrayList<String> references = new ArrayList<String>();
                    references.add(reference);
                    if (isDefaultPackage) {
                        defaultPackages.put(target, references);
                        missingRefMap.put(target, new ArrayList());
                    } else {
                        missingRefMap.put(target, references);
                    }
                } else if (isDefaultPackage) {
                    List defaultPackageClasses = (List)defaultPackages.get(target);
                    if (!defaultPackageClasses.contains(reference)) {
                        defaultPackageClasses.add(reference);
                    }
                } else {
                    List missingRefs = (List)missingRefMap.get(target);
                    if (!missingRefs.contains(reference)) {
                        missingRefs.add(reference);
                    }
                }
                found = true;
            }
        }
        for (IScanTarget target : defaultPackages.keySet()) {
            List defaultPackageClasses = (List)defaultPackages.get(target);
            Collections.sort(defaultPackageClasses);
            String classes = defaultPackageClasses.toString().replace("[", "<default package>.* (Classes: ").replace("]", ")");
            List missingRefs = (List)missingRefMap.get(target);
            missingRefs.add(classes);
        }
        for (IScanTarget target : missingRefMap.keySet()) {
            Collections.sort((List)missingRefMap.get(target));
        }
        return missingRefMap;
    }

    public Set<String> getSkippedFiles() {
        HashSet<String> skippedFiles = new HashSet<String>();
        for (EngineMessage message : this.m_engine_messages) {
            if (!message.getType().equalsIgnoreCase("SKIPCPP") || message.getAttributeValue("file_skipped") == null) continue;
            skippedFiles.add(message.getAttributeValue("file_skipped"));
        }
        return skippedFiles;
    }

    private Map<IScanFile, IScanTarget> getScanFiles() {
        final HashMap<IScanFile, IScanTarget> map = new HashMap<IScanFile, IScanTarget>();
        IScanTarget root = null;
        for (IScanTarget target : this.m_scan.getScanTargets()) {
            if (target.getStrategy() != null && target.getScanFiles().size() == 0) {
                root = target;
            }
            ScanModelVisitor visitor = new ScanModelVisitor(){

                public void visit(IScanTarget target) {
                    for (IScanFile file : target.getScanFiles()) {
                        map.put(file, target);
                    }
                }
            };
            target.accept(visitor);
        }
        if (root != null) {
            for (Language.LANGUAGE l : Language.LANGUAGE.values()) {
                File slices = Paths.get(this.m_scan.getSaveLocation().getWorkLocation().getPath(), "slices", l.toString()).toFile();
                if (!slices.exists()) continue;
                for (File slice_dir : slices.listFiles()) {
                    File target_info_for_slice = new File(slice_dir, ".targetinfo");
                    if (!target_info_for_slice.exists()) continue;
                    TargetInfoReader reader = new TargetInfoReader(target_info_for_slice);
                    try {
                        reader.read();
                        for (IScanFile file : reader.getScanFiles()) {
                            map.put(file, root);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.m_scan.getLogManager().log(new Message(2, e.getMessage()));
                    }
                    catch (XMLStreamException e) {
                        this.m_scan.getLogManager().log(new Message(2, e.getMessage()));
                    }
                }
            }
        }
        return map;
    }

    public void markAsFailed(IProgress progress) throws IOException {
        String failedExtension;
        File oldScanFile = this.m_scan.getSaveLocation().getFile();
        String path = oldScanFile.getCanonicalPath();
        if (!path.endsWith(failedExtension = ".failed")) {
            if (path.endsWith(".irx")) {
                path = path.substring(0, path.lastIndexOf(".irx"));
            }
            path = path + failedExtension;
        }
        SaveLocation newLocation = new SaveLocation(new File(path));
        this.m_scan.setSaveLocation(newLocation);
        this.m_scan.save(progress);
        if (oldScanFile.exists()) {
            oldScanFile.delete();
        }
    }

    private void copyAdditionalLogs() {
        try {
            File additionalLogsDir = new File(this.m_scan.getSaveLocation().getFile().getParentFile(), ".staticanalyzerlogs");
            File scanLogsDir = new File(this.m_scan.getSaveLocation().getWorkLocation(), "logs");
            if (additionalLogsDir.isDirectory() && scanLogsDir.getParentFile().isDirectory()) {
                scanLogsDir.mkdirs();
                for (File file : this.fetchFiles(additionalLogsDir)) {
                    IOUtil.copy((File)file, (File)new File(scanLogsDir, file.getName()));
                }
            }
        }
        catch (IOException e) {
            this.m_scan.getLogManager().log(new Message(1, Messages.getMessage("err.copy.logs", e.getLocalizedMessage())));
        }
    }

    private void copyAdditionalExactFileIfPresent(File searchDir, String filename, File destDir) {
        try {
            if (searchDir == null || destDir == null) {
                return;
            }
            File[] searchFiles = DirectoryUtil.getMatchingFiles((File)searchDir, (String)filename);
            if (searchFiles.length > 0) {
                File destFile = new File(destDir, filename);
                IOUtil.copy((File)searchFiles[0], (File)destFile);
            }
        }
        catch (IOException ie) {
            this.m_scan.getLogManager().log(new Message(1, Messages.getMessage("err.ir.gen.copy.additional.file", filename, ie.getLocalizedMessage())));
        }
    }

    private void copyAdditionalFilesIfPresent(File searchDir, String filename, File destDir) {
        try {
            File[] searchFiles;
            if (searchDir == null || destDir == null) {
                return;
            }
            for (File f : searchFiles = DirectoryUtil.getFiles((File)searchDir, (String)filename)) {
                File destFile = new File(destDir, f.getName());
                IOUtil.copy((File)f, (File)destFile);
            }
        }
        catch (IOException ie) {
            this.m_scan.getLogManager().log(new Message(1, Messages.getMessage("err.ir.gen.copy.additional.file", filename, ie.getLocalizedMessage())));
        }
    }

    private boolean noDataFlowTargets(File workingDirectory) {
        return IOUtil.getFileCountInDirForExtension((File)workingDirectory, (String)"ipva.xml") == 0 && IOUtil.getFileCountInDirForExtension((File)workingDirectory, (String)"irx") == 0 && !Paths.get(this.m_scan.getSaveLocation().getWorkLocation().getAbsolutePath(), ".slice_present").toFile().exists();
    }
}

