/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.logging.LogMerger;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.config.LogMergerScanManifest;
import com.ibm.appscan.internal.config.LogMergerScanManifestJson;
import com.ibm.appscan.internal.config.LogMergerSlice;
import com.ibm.appscan.internal.config.LogMergerStaticAnalyzerErrors;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class LogMergerManager {
    List<File> m_mergedFiles;
    File m_destination;
    IScan m_scan;

    public LogMergerManager(File destination, IScan scan) {
        this.m_destination = destination;
        this.m_mergedFiles = new ArrayList<File>();
        this.m_scan = scan;
    }

    public List<File> getMergedFiles() throws IOException {
        if (this.m_mergedFiles.isEmpty()) {
            ArrayList<LogMerger> logMergers = new ArrayList<LogMerger>();
            if (SystemUtil.useSlicerForJavaFiles() && this.m_scan != null && Paths.get(this.m_scan.getSaveLocation().getWorkLocation().getAbsolutePath(), ".slice_present").toFile().exists()) {
                logMergers.add(new LogMergerSlice(this.m_destination, this.m_scan));
                logMergers.add(new LogMergerStaticAnalyzerErrors(this.m_destination, this.m_scan));
            }
            logMergers.add(new LogMergerScanManifest(this.m_destination, this.m_scan));
            logMergers.add(new LogMergerScanManifestJson(this.m_destination, this.m_scan));
            for (LogMerger lm : logMergers) {
                if (!lm.hasEntriesToMerge()) continue;
                this.m_mergedFiles.add(lm.getMergedFile());
            }
        }
        return this.m_mergedFiles;
    }
}

