/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config.model;

import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.xml.XMLFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.events.StartElement;

public class TargetsReader
extends XMLFileReader
implements IModelXMLConstants {
    private Map<File, Boolean> m_targets = new LinkedHashMap<File, Boolean>();
    private List<String> m_workingDirectoryNames = new ArrayList<String>();
    private File m_parentDir;

    public TargetsReader(File parentDir) {
        super(new File(parentDir, ".targets"));
        this.m_parentDir = parentDir;
    }

    protected boolean process(StartElement element) {
        if ("Target".equals(element.getName().getLocalPart())) {
            File file;
            String name = this.getAttribute(element, "working_directory");
            boolean dir = Boolean.parseBoolean(this.getAttribute(element, "dir"));
            if (name != null && (file = new File(this.m_parentDir, (name = new File(name).getName()) + '/' + ".targetinfo")).exists()) {
                this.m_targets.put(file, dir);
                this.m_workingDirectoryNames.add(name);
                return true;
            }
            String path = this.getAttribute(element, "path");
            if (path != null) {
                this.m_targets.put(new File(path), dir);
                this.m_workingDirectoryNames.add(name);
            }
        }
        return true;
    }

    public Map<File, Boolean> getTargets() {
        return this.m_targets;
    }

    public List<String> getWorkingDirectoryNames() {
        return this.m_workingDirectoryNames;
    }
}

