/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner;

import com.hcl.appscan.source.scanner.IAction;
import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.logging.Message;

public class ActionRunner {
    private static final int DEFAULT_TRIES = 3;
    private static final int WAIT_MILLIS = 60000;

    public static void executeAction(IAction action) throws SourceCodeScannerException {
        ActionRunner.executeAction(action, (IProgress)new NullProgress());
    }

    public static void executeAction(IAction action, IProgress progress) throws SourceCodeScannerException {
        ActionRunner.executeAction(action, progress, 3);
    }

    public static void executeAction(IAction action, IProgress progress, int tries) throws SourceCodeScannerException {
        int run = 0;
        while (run < tries) {
            try {
                action.run();
                break;
            }
            catch (SourceCodeScannerException e) {
                if (e.isfatal()) {
                    progress.setStatus(new Message(4, Messages.getMessage("action.failed", action.getDescription(), e.getMessage(), 0)));
                    throw e;
                }
                progress.setStatus(new Message(4, Messages.getMessage("action.failed", action.getDescription(), e.getMessage(), tries - ++run)));
                if (run >= tries) continue;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (run >= tries) {
            throw new SourceCodeScannerException(Messages.getMessage("action.exceeded.retries", action.getDescription(), tries));
        }
        progress.setStatus(new Message(1, Messages.getMessage("action.succeeded", action.getDescription())));
    }
}

