/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.storage;

import com.hcl.appscan.source.scanner.job.RequestHandler;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.storage.BlobStorage;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class BlobScanStorage
extends BlobStorage {
    private String m_fileId;

    public BlobScanStorage(String asocScanId, ILogManager logger, String url) throws SourceCodeScannerException {
        super(asocScanId, logger, url);
    }

    @Override
    public String storeFile(File file) throws SourceCodeScannerException {
        this.m_fileId = UUID.randomUUID() + ".zip";
        String storageUri = this.getStorageUri();
        this.storeScanFile(file, storageUri);
        return this.m_fileId;
    }

    private String getStorageUri() throws SourceCodeScannerException {
        try {
            JSONObject reqBody = new JSONObject();
            reqBody.put("aSoCScanId", (Object)this.getId());
            reqBody.put("blobName", (Object)this.m_fileId);
            RequestHandler requestHandler = this.getUrl() != null ? new RequestHandler(this.getUrl()) : new RequestHandler();
            HttpResponse response = requestHandler.executePostRequest("/api/v3/StorageSas/scans", reqBody);
            RequestHandler.checkAnyFailure(response);
            JSONObject resBody = response.getResponseBody();
            return this.validateReturnStorageUri(resBody);
        }
        catch (IOException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private void storeScanFile(File file, String storageUri) throws SourceCodeScannerException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("cp");
        args.add(this.getQuotedString(file.getAbsolutePath()));
        args.add(this.getQuotedString(storageUri));
        args.add("--overwrite=true");
        args.add("--check-length=true");
        if (SystemUtil.isDevDebug()) {
            args.add("--from-to LocalBlob");
        }
        this.runAzCopy(args);
    }
}

