/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstCallGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;

public abstract class ScriptEntryPoints
implements Iterable<Entrypoint> {
    private final IClassHierarchy cha;
    private final IClass scriptType;

    public ScriptEntryPoints(IClassHierarchy cha, IClass scriptType) {
        this.cha = cha;
        this.scriptType = scriptType;
    }

    protected abstract CallSiteReference makeScriptSite(IMethod var1, int var2);

    protected boolean keep(IMethod method) {
        return true;
    }

    @Override
    public Iterator<Entrypoint> iterator() {
        HashSet ES = HashSetFactory.make();
        Iterator classes = this.scriptType.getClassLoader().iterateAllClasses();
        while (classes.hasNext()) {
            IClass cls = (IClass)classes.next();
            if (!this.cha.isSubclassOf(cls, this.scriptType) || cls.isAbstract()) continue;
            for (IMethod method : cls.getDeclaredMethods()) {
                if (!this.keep(method)) continue;
                ES.add(new ScriptEntryPoint(method));
            }
        }
        return ES.iterator();
    }

    public Entrypoint make(String scriptName) {
        IClass cls = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)this.scriptType.getClassLoader().getReference(), (String)scriptName));
        assert (cls != null && this.cha.isSubclassOf(cls, this.scriptType) && !cls.isAbstract()) : String.valueOf(cls) + " for " + scriptName;
        for (IMethod method : cls.getDeclaredMethods()) {
            if (!this.keep(method)) continue;
            return new ScriptEntryPoint(method);
        }
        assert (false);
        return null;
    }

    private class ScriptEntryPoint
    extends Entrypoint {
        ScriptEntryPoint(IMethod scriptCodeBody) {
            super(scriptCodeBody);
        }

        public CallSiteReference makeSite(int programCounter) {
            return ScriptEntryPoints.this.makeScriptSite(this.getMethod(), programCounter);
        }

        public TypeReference[] getParameterTypes(int i) {
            assert (i == 0);
            if (this.getMethod().isStatic()) {
                return new TypeReference[0];
            }
            return new TypeReference[]{this.getMethod().getDeclaringClass().getReference()};
        }

        public int getNumberOfParameters() {
            return this.getMethod().isStatic() ? 0 : 1;
        }

        public SSAAbstractInvokeInstruction addCall(AbstractRootMethod m) {
            CallSiteReference site = this.makeSite(0);
            if (site == null) {
                return null;
            }
            int functionVn = this.getMethod().isStatic() ? -1 : this.makeArgument(m, 0);
            int[] paramVns = new int[Math.min(0, this.getNumberOfParameters() - 1)];
            for (int j = 0; j < paramVns.length; ++j) {
                paramVns[j] = this.makeArgument(m, j + 1);
            }
            return ((AstCallGraph.ScriptFakeRoot)m).addDirectCall(functionVn, paramVns, site);
        }
    }
}

