/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.util.CAstPrinter;
import java.util.NoSuchElementException;

public class CAstImpl
implements CAst {
    private int nextID = 0;

    @Override
    public String makeUnique() {
        return "id" + this.nextID++;
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode[] cs) {
        return new CAstNodeImpl(kind, cs);
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode[] cs) {
        CAstNode[] children = new CAstNode[cs.length + 1];
        children[0] = c1;
        System.arraycopy(cs, 0, children, 1, cs.length);
        return this.makeNode(kind, children);
    }

    @Override
    public CAstNode makeNode(int kind) {
        return this.makeNode(kind, new CAstNode[0]);
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1) {
        return this.makeNode(kind, new CAstNode[]{c1});
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2) {
        return this.makeNode(kind, new CAstNode[]{c1, c2});
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3) {
        return this.makeNode(kind, new CAstNode[]{c1, c2, c3});
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4) {
        return this.makeNode(kind, new CAstNode[]{c1, c2, c3, c4});
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4, CAstNode c5) {
        return this.makeNode(kind, new CAstNode[]{c1, c2, c3, c4, c5});
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4, CAstNode c5, CAstNode c6) {
        return this.makeNode(kind, new CAstNode[]{c1, c2, c3, c4, c5, c6});
    }

    @Override
    public CAstNode makeConstant(Object value) {
        return new CAstValueImpl(value);
    }

    @Override
    public CAstNode makeConstant(boolean value) {
        return this.makeConstant(value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public CAstNode makeConstant(char value) {
        return this.makeConstant(new Character(value));
    }

    @Override
    public CAstNode makeConstant(short value) {
        return this.makeConstant(new Short(value));
    }

    @Override
    public CAstNode makeConstant(int value) {
        return this.makeConstant(new Integer(value));
    }

    @Override
    public CAstNode makeConstant(long value) {
        return this.makeConstant(new Long(value));
    }

    @Override
    public CAstNode makeConstant(float value) {
        return this.makeConstant(new Float(value));
    }

    @Override
    public CAstNode makeConstant(double value) {
        return this.makeConstant(new Double(value));
    }

    protected static class CAstValueImpl
    implements CAstNode {
        protected final Object value;

        protected CAstValueImpl(Object value) {
            this.value = value;
        }

        @Override
        public int getKind() {
            return 300;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public CAstNode getChild(int n) {
            throw new NoSuchElementException();
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        public String toString() {
            return "CAstValue: " + this.value;
        }

        public int hashCode() {
            return this.getKind() * this.toString().hashCode();
        }
    }

    protected static class CAstNodeImpl
    implements CAstNode {
        protected final CAstNode[] cs;
        protected final int kind;

        protected CAstNodeImpl(int kind, CAstNode[] cs) {
            this.kind = kind;
            this.cs = cs;
            for (int i = 0; i < cs.length; ++i) {
                assert (cs[i] != null) : "argument " + i + " is null for node kind " + kind + " [" + CAstPrinter.entityKindAsString(kind) + "]";
            }
        }

        @Override
        public int getKind() {
            return this.kind;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public CAstNode getChild(int n) {
            try {
                return this.cs[n];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException(n + " of " + CAstPrinter.print(this));
            }
        }

        @Override
        public int getChildCount() {
            return this.cs.length;
        }

        public String toString() {
            return System.identityHashCode(this) + ":" + CAstPrinter.print(this);
        }

        public int hashCode() {
            int code = this.getKind() * (this.getChildCount() + 13);
            for (int i = 0; i < this.getChildCount() && i < 15; ++i) {
                code *= this.getChild(i).getKind();
            }
            return code;
        }
    }
}

