/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AstInstructionFactory;
import com.ibm.wala.cast.ir.ssa.AstInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;

public class AstAssertInstruction
extends SSAInstruction {
    private final int value;
    private final boolean fromSpecification;

    public AstAssertInstruction(int iindex, int value, boolean fromSpecification) {
        super(iindex);
        this.value = value;
        this.fromSpecification = fromSpecification;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int i) {
        assert (i == 0);
        return this.value;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((AstInstructionFactory)insts).AssertInstruction(this.iindex, uses == null ? this.value : uses[0], this.fromSpecification);
    }

    public String toString(SymbolTable symbolTable) {
        return "assert " + this.getValueString(symbolTable, this.value) + " (fromSpec: " + this.fromSpecification + ")";
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((AstInstructionVisitor)v).visitAssert(this);
    }

    public int hashCode() {
        return 2177 * this.value;
    }

    public Collection<TypeReference> getExceptionTypes() {
        return null;
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isFromSpecification() {
        return this.fromSpecification;
    }
}

