/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.jsp.compilers;

import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.discovery.jsp.Messages;
import com.ibm.appscan.discovery.jsp.compilers.BaseJSPCompiler;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public abstract class ExternalJSPCompiler
extends BaseJSPCompiler {
    private PrintWriter m_log = null;

    protected ExternalJSPCompiler(String[] classpathEntries) {
        super(classpathEntries);
    }

    protected final PrintWriter initLog() {
        File dir = this.m_proxy.getWorkingDirectory();
        if (dir != null) {
            dir.mkdirs();
            File log = new File(dir, "compile.log");
            try {
                this.m_log = new PrintWriter(new BufferedWriter(new FileWriter(log)));
                this.m_log.println(Messages.getMessage("building.with", this.m_proxy.getBuildInfo().getProperty("jsp_compiler")));
            }
            catch (IOException e) {
                Message message;
                Message message2 = message = new Message(2, e.getMessage());
                message2.getClass();
                message.setMessageSource(new Message.MessageSource(message2, this.m_proxy.getPath(), null));
                this.m_proxy.getLogManager().log(message);
            }
        }
        return this.m_log;
    }

    protected ProcessRunner.StreamHandler getOuputHandler() {
        this.initLog();
        return new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                if (ExternalJSPCompiler.this.m_log == null) {
                    System.out.println(line);
                } else {
                    ExternalJSPCompiler.this.m_log.println(line);
                }
            }
        };
    }

    protected ProcessRunner.StreamHandler getErrorHandler() {
        return null;
    }

    protected int mapRC(int rc) {
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int compile(Map<String, String> env, String ... args) throws IOException {
        int rc = -1;
        ProcessRunner runner = new ProcessRunner(args);
        if (env != null) {
            runner.environment().putAll(env);
        }
        try {
            rc = this.mapRC(runner.run(this.getOuputHandler(), this.getErrorHandler()));
            if (rc != 0) {
                this.m_proxy.getErrorManager().reportError(Messages.getMessage("err.jsp.compiler.rc", rc));
            }
            int n = rc;
            return n;
        }
        finally {
            IOUtil.close((Closeable)this.m_log);
        }
    }

    protected final int compile(String ... args) throws IOException {
        return this.compile((Map<String, String>)null, args);
    }
}

