/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa;

import com.hcl.appscan.ifa.Util;
import com.hcl.appscan.ifa.common.IIfaLayer;
import com.hcl.appscan.ifa.common.IfaTarget;
import com.hcl.appscan.ifa.nlp.model.JavaScript.JavaScriptModel;
import com.hcl.appscan.ifa.notes.Notes;
import com.ibm.appscan.assessment.Constants;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.utils.functional.Lazy;

public class JavaScriptIfaLayer
implements IIfaLayer {
    private Lazy<JavaScriptModel> m_js_model = Lazy.of(JavaScriptModel::new);

    public void close() throws Exception {
        if (this.m_js_model.isLoaded()) {
            ((JavaScriptModel)this.m_js_model.get()).close();
        }
    }

    public void applyIfa(IfaTarget t) {
        for (Finding f : t) {
            if (f.getData().getConfidence().toLowerCase().equals(Constants.SEVERITY90.Info.toString())) {
                t.excludeFinding(f);
                continue;
            }
            try {
                float value = ((JavaScriptModel)this.m_js_model.get()).getPredictedValue(f).floatValue();
                if ((double)value > 0.5) {
                    Util.setIfa2Note(f, Notes.getMessage("probability", Float.valueOf(value)));
                    t.includeFinding(f);
                    continue;
                }
                Util.setIfa2Note(f, Notes.getMessage("probability.uninteresting", Float.valueOf(1.0f - value)));
                t.excludeFinding(f);
            }
            catch (Exception e) {
                t.logException(e);
            }
        }
    }

    public String getIfaName() {
        return this.getClass().getSimpleName();
    }

    public static Boolean predicate(Finding f) {
        switch (f.getLanguage()) {
            case UNKNOWN: 
            case CUSTOM: {
                return JavaScriptModel.isFindingLanguageJavaScript((Finding)f);
            }
            case JAVASCRIPT: 
            case NODE_JS: 
            case ANGULAR: 
            case IONIC: 
            case JQUERY: 
            case MOOTOOLS: 
            case REACT: 
            case REACT_NATIVE: 
            case VUE_JS: {
                return true;
            }
        }
        return false;
    }
}

