/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class Bytecode {
    public static final byte prefixByte = -2;
    public static final Inst[] insts;
    public static final InstPrefix[] instPrefixes;

    static {
        int n;
        insts = new Inst[256];
        instPrefixes = new InstPrefix[256];
        Enum[] enumArray = Inst.values();
        int n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            Inst i;
            Bytecode.insts[((Inst)i).opcode + 128] = i = enumArray[n];
        }
        enumArray = InstPrefix.values();
        n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            Enum p;
            Bytecode.instPrefixes[((InstPrefix)p).opcode] = p = enumArray[n];
        }
    }

    public static enum InstPrefix {
        prefix_initblk(24, Prefix.op_initblk),
        prefix_volatile(19, Prefix.op_volatile),
        prefix_stloc(14, Prefix.op_stloc),
        prefix_ldarga(10, Prefix.op_ldarga),
        prefix_refanytype(29, Prefix.op_refanytype),
        prefix_rethrow(26, Prefix.op_rethrow),
        prefix_ldarg(9, Prefix.op_ldarg),
        prefix_ldvirtftn(7, Prefix.op_ldvirtftn),
        prefix_clt(4, Prefix.op_clt),
        prefix_arglist(0, Prefix.op_arglist),
        prefix_sizeof(28, Prefix.op_sizeof),
        prefix_starg(11, Prefix.op_starg),
        prefix_clt_un(5, Prefix.op_clt, EnumSet.of(Flag.flag_un)),
        prefix_endfilter(17, Prefix.op_endfilter),
        prefix_ldftn(6, Prefix.op_ldftn),
        prefix_constrained(22, Prefix.op_constrained),
        prefix_ldloc(12, Prefix.op_ldloc),
        prefix_readonly(30, Prefix.op_readonly),
        prefix_ceq(1, Prefix.op_ceq),
        prefix_cpblk(23, Prefix.op_cpblk),
        prefix_cgt(2, Prefix.op_cgt),
        prefix_no(25, Prefix.op_no),
        prefix_initobj(21, Prefix.op_initobj),
        prefix_unaligned(18, Prefix.op_unaligned),
        prefix_ldloca(13, Prefix.op_ldloca),
        prefix_cgt_un(3, Prefix.op_cgt, EnumSet.of(Flag.flag_un)),
        prefix_tail(20, Prefix.op_tail),
        prefix_localloc(15, Prefix.op_localloc);

        private final byte opcode;
        private final Prefix op;
        private final Set<Flag> flags;

        public void visit(CILPrefixVisitor v) {
            this.op.visit(v, this.flags);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.opcode).append((Object)this.op);
            for (Flag f : this.flags) {
                sb.append(".").append((Object)f);
            }
            return sb.toString();
        }

        private InstPrefix(byte opcode, Prefix op, Set<Flag> flags) {
            this.opcode = opcode;
            this.op = op;
            this.flags = flags;
        }

        private InstPrefix(byte opcode, Prefix op) {
            this(opcode, op, Collections.emptySet());
        }
    }

    public static enum Inst {
        inst_conv_ovf_i4_un(-124, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i4, Flag.flag_un)),
        inst_ldc_i4_0(22, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_0)),
        inst_conv_ovf_u8_un(-119, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u8, Flag.flag_un)),
        inst_stind_ref(81, Opcode.op_stind, EnumSet.of(Flag.flag_ref)),
        inst_brfalse_s(44, Opcode.op_brfalse, EnumSet.of(Flag.flag_s)),
        inst_or(96, Opcode.op_or),
        inst_rem(93, Opcode.op_rem),
        inst_ldarg_3(5, Opcode.op_ldarg, EnumSet.of(Flag.flag_3)),
        inst_conv_ovf_i8_un(-123, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i8, Flag.flag_un)),
        inst_unbox_any(-91, Opcode.op_unbox, EnumSet.of(Flag.flag_any)),
        inst_ldloc_2(8, Opcode.op_ldloc, EnumSet.of(Flag.flag_2)),
        inst_add_ovf(-42, Opcode.op_add, EnumSet.of(Flag.flag_ovf)),
        inst_ldfld(123, Opcode.op_ldfld),
        inst_conv_u(-32, Opcode.op_conv, EnumSet.of(Flag.flag_u)),
        inst_mkrefany(-58, Opcode.op_mkrefany),
        inst_stsfld(-128, Opcode.op_stsfld),
        inst_switch(69, Opcode.op_switch),
        inst_blt(63, Opcode.op_blt),
        inst_ldc_i4_s(31, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_s)),
        inst_ldarg_0(2, Opcode.op_ldarg, EnumSet.of(Flag.flag_0)),
        inst_bgt(61, Opcode.op_bgt),
        inst_ldc_i4(32, Opcode.op_ldc, EnumSet.of(Flag.flag_i4)),
        inst_conv_ovf_u8(-70, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u8)),
        inst_conv_i8(106, Opcode.op_conv, EnumSet.of(Flag.flag_i8)),
        inst_shr_un(100, Opcode.op_shr, EnumSet.of(Flag.flag_un)),
        inst_ldind_ref(80, Opcode.op_ldind, EnumSet.of(Flag.flag_ref)),
        inst_dup(37, Opcode.op_dup),
        inst_ldloca_s(18, Opcode.op_ldloca, EnumSet.of(Flag.flag_s)),
        inst_stloc_2(12, Opcode.op_stloc, EnumSet.of(Flag.flag_2)),
        inst_sub_ovf_un(-37, Opcode.op_sub, EnumSet.of(Flag.flag_ovf, Flag.flag_un)),
        inst_stfld(125, Opcode.op_stfld),
        inst_conv_ovf_u2_un(-121, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u2, Flag.flag_un)),
        inst_br(56, Opcode.op_br),
        inst_call(40, Opcode.op_call),
        inst_box(-116, Opcode.op_box),
        inst_ldc_i4_6(28, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_6)),
        inst_castclass(116, Opcode.op_castclass),
        inst_ldind_r4(78, Opcode.op_ldind, EnumSet.of(Flag.flag_r4)),
        inst_calli(41, Opcode.op_calli),
        inst_conv_ovf_i2_un(-125, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i2, Flag.flag_un)),
        inst_ldind_i4(74, Opcode.op_ldind, EnumSet.of(Flag.flag_i4)),
        inst_conv_u8(110, Opcode.op_conv, EnumSet.of(Flag.flag_u8)),
        inst_add(88, Opcode.op_add),
        inst_stobj(-127, Opcode.op_stobj),
        inst_leave_s(-34, Opcode.op_leave, EnumSet.of(Flag.flag_s)),
        inst_stind_i8(85, Opcode.op_stind, EnumSet.of(Flag.flag_i8)),
        inst_beq_s(46, Opcode.op_beq, EnumSet.of(Flag.flag_s)),
        inst_ble(62, Opcode.op_ble),
        inst_cpobj(112, Opcode.op_cpobj),
        inst_conv_u2(-47, Opcode.op_conv, EnumSet.of(Flag.flag_u2)),
        inst_stelem_i(-101, Opcode.op_stelem, EnumSet.of(Flag.flag_i)),
        inst_ldc_i4_1(23, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_1)),
        inst_bge(60, Opcode.op_bge),
        inst_ble_s(49, Opcode.op_ble, EnumSet.of(Flag.flag_s)),
        inst_div(91, Opcode.op_div),
        inst_brfalse(57, Opcode.op_brfalse),
        inst_ldelem_u2(-109, Opcode.op_ldelem, EnumSet.of(Flag.flag_u2)),
        inst_ldind_u4(75, Opcode.op_ldind, EnumSet.of(Flag.flag_u4)),
        inst_stind_r4(86, Opcode.op_stind, EnumSet.of(Flag.flag_r4)),
        inst_conv_r8(108, Opcode.op_conv, EnumSet.of(Flag.flag_r8)),
        inst_ldc_r4(34, Opcode.op_ldc, EnumSet.of(Flag.flag_r4)),
        inst_stelem_i2(-99, Opcode.op_stelem, EnumSet.of(Flag.flag_i2)),
        inst_newobj(115, Opcode.op_newobj),
        inst_callvirt(111, Opcode.op_callvirt),
        inst_ldloc_3(9, Opcode.op_ldloc, EnumSet.of(Flag.flag_3)),
        inst_stloc_s(19, Opcode.op_stloc, EnumSet.of(Flag.flag_s)),
        inst_ldarga_s(15, Opcode.op_ldarga, EnumSet.of(Flag.flag_s)),
        inst_ldc_i4_m1(21, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_m1)),
        inst_add_ovf_un(-41, Opcode.op_add, EnumSet.of(Flag.flag_ovf, Flag.flag_un)),
        inst_stelem_i4(-98, Opcode.op_stelem, EnumSet.of(Flag.flag_i4)),
        inst_isinst(117, Opcode.op_isinst),
        inst_conv_ovf_u1(-76, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u1)),
        inst_stelem_r4(-96, Opcode.op_stelem, EnumSet.of(Flag.flag_r4)),
        inst_conv_ovf_u_un(-117, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u, Flag.flag_un)),
        inst_blt_s(50, Opcode.op_blt, EnumSet.of(Flag.flag_s)),
        inst_ldarg_1(3, Opcode.op_ldarg, EnumSet.of(Flag.flag_1)),
        inst_pop(38, Opcode.op_pop),
        inst_stelem_i8(-97, Opcode.op_stelem, EnumSet.of(Flag.flag_i8)),
        inst_ldelem_i2(-110, Opcode.op_ldelem, EnumSet.of(Flag.flag_i2)),
        inst_xor(97, Opcode.op_xor),
        inst_bge_un_s(52, Opcode.op_bge, EnumSet.of(Flag.flag_un, Flag.flag_s)),
        inst_ldloc_0(6, Opcode.op_ldloc, EnumSet.of(Flag.flag_0)),
        inst_conv_u4(109, Opcode.op_conv, EnumSet.of(Flag.flag_u4)),
        inst_stloc_3(13, Opcode.op_stloc, EnumSet.of(Flag.flag_3)),
        inst_stelem_r8(-95, Opcode.op_stelem, EnumSet.of(Flag.flag_r8)),
        inst_ldelem_ref(-102, Opcode.op_ldelem, EnumSet.of(Flag.flag_ref)),
        inst_throw(122, Opcode.op_throw),
        inst_ldind_r8(79, Opcode.op_ldind, EnumSet.of(Flag.flag_r8)),
        inst_ldc_i4_7(29, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_7)),
        inst_jmp(39, Opcode.op_jmp),
        inst_nop(0, Opcode.op_nop),
        inst_ckfinite(-61, Opcode.op_ckfinite),
        inst_conv_ovf_i4(-73, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i4)),
        inst_beq(59, Opcode.op_beq),
        inst_mul_ovf(-40, Opcode.op_mul, EnumSet.of(Flag.flag_ovf)),
        inst_brtrue(58, Opcode.op_brtrue),
        inst_ldelem_u4(-107, Opcode.op_ldelem, EnumSet.of(Flag.flag_u4)),
        inst_shr(99, Opcode.op_shr),
        inst_ldind_i1(70, Opcode.op_ldind, EnumSet.of(Flag.flag_i1)),
        inst_conv_ovf_i1_un(-126, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i1, Flag.flag_un)),
        inst_ldelem_i(-105, Opcode.op_ldelem, EnumSet.of(Flag.flag_i)),
        inst_ldelema(-113, Opcode.op_ldelema),
        inst_mul(90, Opcode.op_mul),
        inst_stloc_0(10, Opcode.op_stloc, EnumSet.of(Flag.flag_0)),
        inst_conv_ovf_u2(-74, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u2)),
        inst_blt_un_s(55, Opcode.op_blt, EnumSet.of(Flag.flag_un, Flag.flag_s)),
        inst_conv_ovf_i8(-71, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i8)),
        inst_bgt_un(66, Opcode.op_bgt, EnumSet.of(Flag.flag_un)),
        inst_ldtoken(-48, Opcode.op_ldtoken),
        inst_conv_u1(-46, Opcode.op_conv, EnumSet.of(Flag.flag_u1)),
        inst_and(95, Opcode.op_and),
        inst_ldc_i4_2(24, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_2)),
        inst_ldsflda(127, Opcode.op_ldsflda),
        inst_unbox(121, Opcode.op_unbox),
        inst_stind_i2(83, Opcode.op_stind, EnumSet.of(Flag.flag_i2)),
        inst_leave(-35, Opcode.op_leave),
        inst_refanyval(-62, Opcode.op_refanyval),
        inst_stind_r8(87, Opcode.op_stind, EnumSet.of(Flag.flag_r8)),
        inst_bge_s(47, Opcode.op_bge, EnumSet.of(Flag.flag_s)),
        inst_conv_ovf_u(-43, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u)),
        inst_conv_ovf_u1_un(-122, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u1, Flag.flag_un)),
        inst_bne_un_s(51, Opcode.op_bne, EnumSet.of(Flag.flag_un, Flag.flag_s)),
        inst_ldc_i4_4(26, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_4)),
        inst_ldelem_i4(-108, Opcode.op_ldelem, EnumSet.of(Flag.flag_i4)),
        inst_ldarg_s(14, Opcode.op_ldarg, EnumSet.of(Flag.flag_s)),
        inst_conv_i1(103, Opcode.op_conv, EnumSet.of(Flag.flag_i1)),
        inst_bge_un(65, Opcode.op_bge, EnumSet.of(Flag.flag_un)),
        inst_conv_ovf_i_un(-118, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i, Flag.flag_un)),
        inst_ldelem_i1(-112, Opcode.op_ldelem, EnumSet.of(Flag.flag_i1)),
        inst_ldelem(-93, Opcode.op_ldelem),
        inst_ldelem_u1(-111, Opcode.op_ldelem, EnumSet.of(Flag.flag_u1)),
        inst_ldloc_s(17, Opcode.op_ldloc, EnumSet.of(Flag.flag_s)),
        inst_conv_r4(107, Opcode.op_conv, EnumSet.of(Flag.flag_r4)),
        inst_stind_i(-33, Opcode.op_stind, EnumSet.of(Flag.flag_i)),
        inst_sub_ovf(-38, Opcode.op_sub, EnumSet.of(Flag.flag_ovf)),
        inst_ldelem_r4(-104, Opcode.op_ldelem, EnumSet.of(Flag.flag_r4)),
        inst_ldelem_i8(-106, Opcode.op_ldelem, EnumSet.of(Flag.flag_i8)),
        inst_conv_i4(105, Opcode.op_conv, EnumSet.of(Flag.flag_i4)),
        inst_not(102, Opcode.op_not),
        inst_neg(101, Opcode.op_neg),
        inst_mul_ovf_un(-39, Opcode.op_mul, EnumSet.of(Flag.flag_ovf, Flag.flag_un)),
        inst_ldlen(-114, Opcode.op_ldlen),
        inst_bne_un(64, Opcode.op_bne, EnumSet.of(Flag.flag_un)),
        inst_ldflda(124, Opcode.op_ldflda),
        inst_div_un(92, Opcode.op_div, EnumSet.of(Flag.flag_un)),
        inst_ldarg_2(4, Opcode.op_ldarg, EnumSet.of(Flag.flag_2)),
        inst_stelem_i1(-100, Opcode.op_stelem, EnumSet.of(Flag.flag_i1)),
        inst_ldind_u1(71, Opcode.op_ldind, EnumSet.of(Flag.flag_u1)),
        inst_ldloc_1(7, Opcode.op_ldloc, EnumSet.of(Flag.flag_1)),
        inst_ldelem_r8(-103, Opcode.op_ldelem, EnumSet.of(Flag.flag_r8)),
        inst_stind_i1(82, Opcode.op_stind, EnumSet.of(Flag.flag_i1)),
        inst_ldc_i4_8(30, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_8)),
        inst_stelem(-92, Opcode.op_stelem),
        inst_newarr(-115, Opcode.op_newarr),
        inst_sub(89, Opcode.op_sub),
        inst_conv_ovf_i(-44, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i)),
        inst_blt_un(68, Opcode.op_blt, EnumSet.of(Flag.flag_un)),
        inst_ret(42, Opcode.op_ret),
        inst_ldc_i8(33, Opcode.op_ldc, EnumSet.of(Flag.flag_i8)),
        inst_starg_s(16, Opcode.op_starg, EnumSet.of(Flag.flag_s)),
        inst_break(1, Opcode.op_break),
        inst_ldstr(114, Opcode.op_ldstr),
        inst_endfinally(-36, Opcode.op_endfinally),
        inst_conv_i2(104, Opcode.op_conv, EnumSet.of(Flag.flag_i2)),
        inst_ldind_i2(72, Opcode.op_ldind, EnumSet.of(Flag.flag_i2)),
        inst_stloc_1(11, Opcode.op_stloc, EnumSet.of(Flag.flag_1)),
        inst_ble_un_s(54, Opcode.op_ble, EnumSet.of(Flag.flag_un, Flag.flag_s)),
        inst_ldc_i4_3(25, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_3)),
        inst_ldind_i8(76, Opcode.op_ldind, EnumSet.of(Flag.flag_i8)),
        inst_ldsfld(126, Opcode.op_ldsfld),
        inst_stelem_ref(-94, Opcode.op_stelem, EnumSet.of(Flag.flag_ref)),
        inst_bgt_s(48, Opcode.op_bgt, EnumSet.of(Flag.flag_s)),
        inst_conv_i(-45, Opcode.op_conv, EnumSet.of(Flag.flag_i)),
        inst_ldobj(113, Opcode.op_ldobj),
        inst_ldc_i4_5(27, Opcode.op_ldc, EnumSet.of(Flag.flag_i4, Flag.flag_5)),
        inst_conv_r_un(118, Opcode.op_conv, EnumSet.of(Flag.flag_r, Flag.flag_un)),
        inst_conv_ovf_i1(-77, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i1)),
        inst_brtrue_s(45, Opcode.op_brtrue, EnumSet.of(Flag.flag_s)),
        inst_conv_ovf_i2(-75, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_i2)),
        inst_ldnull(20, Opcode.op_ldnull),
        inst_conv_ovf_u4(-72, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u4)),
        inst_ldind_u2(73, Opcode.op_ldind, EnumSet.of(Flag.flag_u2)),
        inst_br_s(43, Opcode.op_br, EnumSet.of(Flag.flag_s)),
        inst_rem_un(94, Opcode.op_rem, EnumSet.of(Flag.flag_un)),
        inst_conv_ovf_u4_un(-120, Opcode.op_conv, EnumSet.of(Flag.flag_ovf, Flag.flag_u4, Flag.flag_un)),
        inst_shl(98, Opcode.op_shl),
        inst_stind_i4(84, Opcode.op_stind, EnumSet.of(Flag.flag_i4)),
        inst_ldind_i(77, Opcode.op_ldind, EnumSet.of(Flag.flag_i)),
        inst_ldc_r8(35, Opcode.op_ldc, EnumSet.of(Flag.flag_r8)),
        inst_ble_un(67, Opcode.op_ble, EnumSet.of(Flag.flag_un)),
        inst_bgt_un_s(53, Opcode.op_bgt, EnumSet.of(Flag.flag_un, Flag.flag_s));

        private final byte opcode;
        private final Opcode op;
        private final Set<Flag> flags;

        public void visit(CILVisitor v) {
            this.op.visit(v, this.flags);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.opcode).append((Object)this.op);
            for (Flag f : this.flags) {
                sb.append(".").append((Object)f);
            }
            return sb.toString();
        }

        private Inst(byte opcode, Opcode op, Set<Flag> flags) {
            this.opcode = opcode;
            this.op = op;
            this.flags = flags;
        }

        private Inst(byte opcode, Opcode op) {
            this(opcode, op, Collections.emptySet());
        }
    }

    public static enum Prefix {
        op_no{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_no(flags);
            }
        }
        ,
        op_constrained{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_constrained(flags);
            }
        }
        ,
        op_tail{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_tail(flags);
            }
        }
        ,
        op_volatile{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_volatile(flags);
            }
        }
        ,
        op_ldarga{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ldarga(flags);
            }
        }
        ,
        op_sizeof{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_sizeof(flags);
            }
        }
        ,
        op_cpblk{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_cpblk(flags);
            }
        }
        ,
        op_stloc{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_stloc(flags);
            }
        }
        ,
        op_ldftn{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ldftn(flags);
            }
        }
        ,
        op_clt{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_clt(flags);
            }
        }
        ,
        op_arglist{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_arglist(flags);
            }
        }
        ,
        op_rethrow{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_rethrow(flags);
            }
        }
        ,
        op_initblk{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_initblk(flags);
            }
        }
        ,
        op_ldloc{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ldloc(flags);
            }
        }
        ,
        op_ldvirtftn{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ldvirtftn(flags);
            }
        }
        ,
        op_initobj{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_initobj(flags);
            }
        }
        ,
        op_ceq{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ceq(flags);
            }
        }
        ,
        op_endfilter{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_endfilter(flags);
            }
        }
        ,
        op_starg{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_starg(flags);
            }
        }
        ,
        op_localloc{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_localloc(flags);
            }
        }
        ,
        op_ldarg{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ldarg(flags);
            }
        }
        ,
        op_readonly{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_readonly(flags);
            }
        }
        ,
        op_refanytype{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_refanytype(flags);
            }
        }
        ,
        op_ldloca{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_ldloca(flags);
            }
        }
        ,
        op_unaligned{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_unaligned(flags);
            }
        }
        ,
        op_cgt{

            @Override
            public void visit(CILPrefixVisitor v, Set<Flag> flags) {
                v.visit_cgt(flags);
            }
        };


        public abstract void visit(CILPrefixVisitor var1, Set<Flag> var2);
    }

    public static interface CILPrefixVisitor {
        public void visit_no(Set<Flag> var1);

        public void visit_constrained(Set<Flag> var1);

        public void visit_tail(Set<Flag> var1);

        public void visit_volatile(Set<Flag> var1);

        public void visit_ldarga(Set<Flag> var1);

        public void visit_sizeof(Set<Flag> var1);

        public void visit_cpblk(Set<Flag> var1);

        public void visit_stloc(Set<Flag> var1);

        public void visit_ldftn(Set<Flag> var1);

        public void visit_clt(Set<Flag> var1);

        public void visit_arglist(Set<Flag> var1);

        public void visit_rethrow(Set<Flag> var1);

        public void visit_initblk(Set<Flag> var1);

        public void visit_ldloc(Set<Flag> var1);

        public void visit_ldvirtftn(Set<Flag> var1);

        public void visit_initobj(Set<Flag> var1);

        public void visit_ceq(Set<Flag> var1);

        public void visit_endfilter(Set<Flag> var1);

        public void visit_starg(Set<Flag> var1);

        public void visit_localloc(Set<Flag> var1);

        public void visit_ldarg(Set<Flag> var1);

        public void visit_readonly(Set<Flag> var1);

        public void visit_refanytype(Set<Flag> var1);

        public void visit_ldloca(Set<Flag> var1);

        public void visit_unaligned(Set<Flag> var1);

        public void visit_cgt(Set<Flag> var1);
    }

    public static enum Opcode {
        op_ldloc{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldloc(flags);
            }
        }
        ,
        op_conv{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_conv(flags);
            }
        }
        ,
        op_ldsfld{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldsfld(flags);
            }
        }
        ,
        op_stfld{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_stfld(flags);
            }
        }
        ,
        op_shl{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_shl(flags);
            }
        }
        ,
        op_throw{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_throw(flags);
            }
        }
        ,
        op_ldfld{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldfld(flags);
            }
        }
        ,
        op_box{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_box(flags);
            }
        }
        ,
        op_ldsflda{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldsflda(flags);
            }
        }
        ,
        op_brtrue{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_brtrue(flags);
            }
        }
        ,
        op_ldloca{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldloca(flags);
            }
        }
        ,
        op_shr{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_shr(flags);
            }
        }
        ,
        op_pop{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_pop(flags);
            }
        }
        ,
        op_starg{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_starg(flags);
            }
        }
        ,
        op_leave{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_leave(flags);
            }
        }
        ,
        op_ldarg{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldarg(flags);
            }
        }
        ,
        op_and{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_and(flags);
            }
        }
        ,
        op_ckfinite{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ckfinite(flags);
            }
        }
        ,
        op_break{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_break(flags);
            }
        }
        ,
        op_ldarga{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldarga(flags);
            }
        }
        ,
        op_rem{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_rem(flags);
            }
        }
        ,
        op_refanyval{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_refanyval(flags);
            }
        }
        ,
        op_ldstr{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldstr(flags);
            }
        }
        ,
        op_newarr{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_newarr(flags);
            }
        }
        ,
        op_ret{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ret(flags);
            }
        }
        ,
        op_cpobj{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_cpobj(flags);
            }
        }
        ,
        op_neg{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_neg(flags);
            }
        }
        ,
        op_ldc{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldc(flags);
            }
        }
        ,
        op_div{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_div(flags);
            }
        }
        ,
        op_ble{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ble(flags);
            }
        }
        ,
        op_isinst{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_isinst(flags);
            }
        }
        ,
        op_bne{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_bne(flags);
            }
        }
        ,
        op_ldelem{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldelem(flags);
            }
        }
        ,
        op_or{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_or(flags);
            }
        }
        ,
        op_mkrefany{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_mkrefany(flags);
            }
        }
        ,
        op_blt{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_blt(flags);
            }
        }
        ,
        op_brfalse{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_brfalse(flags);
            }
        }
        ,
        op_ldtoken{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldtoken(flags);
            }
        }
        ,
        op_switch{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_switch(flags);
            }
        }
        ,
        op_stsfld{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_stsfld(flags);
            }
        }
        ,
        op_br{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_br(flags);
            }
        }
        ,
        op_mul{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_mul(flags);
            }
        }
        ,
        op_dup{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_dup(flags);
            }
        }
        ,
        op_nop{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_nop(flags);
            }
        }
        ,
        op_ldflda{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldflda(flags);
            }
        }
        ,
        op_not{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_not(flags);
            }
        }
        ,
        op_calli{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_calli(flags);
            }
        }
        ,
        op_castclass{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_castclass(flags);
            }
        }
        ,
        op_bge{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_bge(flags);
            }
        }
        ,
        op_jmp{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_jmp(flags);
            }
        }
        ,
        op_beq{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_beq(flags);
            }
        }
        ,
        op_stind{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_stind(flags);
            }
        }
        ,
        op_callvirt{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_callvirt(flags);
            }
        }
        ,
        op_ldlen{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldlen(flags);
            }
        }
        ,
        op_call{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_call(flags);
            }
        }
        ,
        op_stobj{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_stobj(flags);
            }
        }
        ,
        op_ldind{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldind(flags);
            }
        }
        ,
        op_unbox{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_unbox(flags);
            }
        }
        ,
        op_sub{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_sub(flags);
            }
        }
        ,
        op_ldobj{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldobj(flags);
            }
        }
        ,
        op_bgt{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_bgt(flags);
            }
        }
        ,
        op_ldelema{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldelema(flags);
            }
        }
        ,
        op_stelem{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_stelem(flags);
            }
        }
        ,
        op_newobj{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_newobj(flags);
            }
        }
        ,
        op_xor{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_xor(flags);
            }
        }
        ,
        op_add{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_add(flags);
            }
        }
        ,
        op_endfinally{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_endfinally(flags);
            }
        }
        ,
        op_ldnull{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_ldnull(flags);
            }
        }
        ,
        op_stloc{

            @Override
            public void visit(CILVisitor v, Set<Flag> flags) {
                v.visit_stloc(flags);
            }
        };


        public abstract void visit(CILVisitor var1, Set<Flag> var2);
    }

    public static interface CILVisitor {
        public void visit_ldloc(Set<Flag> var1);

        public void visit_conv(Set<Flag> var1);

        public void visit_ldsfld(Set<Flag> var1);

        public void visit_stfld(Set<Flag> var1);

        public void visit_shl(Set<Flag> var1);

        public void visit_throw(Set<Flag> var1);

        public void visit_ldfld(Set<Flag> var1);

        public void visit_box(Set<Flag> var1);

        public void visit_ldsflda(Set<Flag> var1);

        public void visit_brtrue(Set<Flag> var1);

        public void visit_ldloca(Set<Flag> var1);

        public void visit_shr(Set<Flag> var1);

        public void visit_pop(Set<Flag> var1);

        public void visit_starg(Set<Flag> var1);

        public void visit_leave(Set<Flag> var1);

        public void visit_ldarg(Set<Flag> var1);

        public void visit_and(Set<Flag> var1);

        public void visit_ckfinite(Set<Flag> var1);

        public void visit_break(Set<Flag> var1);

        public void visit_ldarga(Set<Flag> var1);

        public void visit_rem(Set<Flag> var1);

        public void visit_refanyval(Set<Flag> var1);

        public void visit_ldstr(Set<Flag> var1);

        public void visit_newarr(Set<Flag> var1);

        public void visit_ret(Set<Flag> var1);

        public void visit_cpobj(Set<Flag> var1);

        public void visit_neg(Set<Flag> var1);

        public void visit_ldc(Set<Flag> var1);

        public void visit_div(Set<Flag> var1);

        public void visit_ble(Set<Flag> var1);

        public void visit_isinst(Set<Flag> var1);

        public void visit_bne(Set<Flag> var1);

        public void visit_ldelem(Set<Flag> var1);

        public void visit_or(Set<Flag> var1);

        public void visit_mkrefany(Set<Flag> var1);

        public void visit_blt(Set<Flag> var1);

        public void visit_brfalse(Set<Flag> var1);

        public void visit_ldtoken(Set<Flag> var1);

        public void visit_switch(Set<Flag> var1);

        public void visit_stsfld(Set<Flag> var1);

        public void visit_br(Set<Flag> var1);

        public void visit_mul(Set<Flag> var1);

        public void visit_dup(Set<Flag> var1);

        public void visit_nop(Set<Flag> var1);

        public void visit_ldflda(Set<Flag> var1);

        public void visit_not(Set<Flag> var1);

        public void visit_calli(Set<Flag> var1);

        public void visit_castclass(Set<Flag> var1);

        public void visit_bge(Set<Flag> var1);

        public void visit_jmp(Set<Flag> var1);

        public void visit_beq(Set<Flag> var1);

        public void visit_stind(Set<Flag> var1);

        public void visit_callvirt(Set<Flag> var1);

        public void visit_ldlen(Set<Flag> var1);

        public void visit_call(Set<Flag> var1);

        public void visit_stobj(Set<Flag> var1);

        public void visit_ldind(Set<Flag> var1);

        public void visit_unbox(Set<Flag> var1);

        public void visit_sub(Set<Flag> var1);

        public void visit_ldobj(Set<Flag> var1);

        public void visit_bgt(Set<Flag> var1);

        public void visit_ldelema(Set<Flag> var1);

        public void visit_stelem(Set<Flag> var1);

        public void visit_newobj(Set<Flag> var1);

        public void visit_xor(Set<Flag> var1);

        public void visit_add(Set<Flag> var1);

        public void visit_endfinally(Set<Flag> var1);

        public void visit_ldnull(Set<Flag> var1);

        public void visit_stloc(Set<Flag> var1);
    }

    public static enum Flag {
        flag_u,
        flag_u4,
        flag_4,
        flag_any,
        flag_i,
        flag_r8,
        flag_5,
        flag_i4,
        flag_6,
        flag_m1,
        flag_7,
        flag_u8,
        flag_8,
        flag_i8,
        flag_ref,
        flag_un,
        flag_ovf,
        flag_0,
        flag_r,
        flag_u1,
        flag_r4,
        flag_1,
        flag_u2,
        flag_i1,
        flag_s,
        flag_2,
        flag_i2,
        flag_3;

    }
}

