/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.types.MethodReference;

public class CILInvokeInstruction
implements IInvokeInstruction {
    private final MethodReference callee;
    private final IInvokeInstruction.IDispatch dispatchType;
    private final boolean isTailCall;
    private final Translator.RuntimeType returnType;
    private final int outParameters;

    public CILInvokeInstruction(MethodReference callee, Translator.RuntimeType returnType, IInvokeInstruction.IDispatch dispatchType, boolean isTailCall, int outParameters) {
        this.callee = callee;
        this.returnType = returnType;
        this.dispatchType = dispatchType;
        this.isTailCall = isTailCall;
        this.outParameters = outParameters;
    }

    public String toString() {
        return "Invoke(" + this.callee.getName() + "," + this.callee.getReturnType() + "," + (Object)((Object)this.returnType) + "," + this.outParameters + ")";
    }

    public boolean isTailCall() {
        return this.isTailCall;
    }

    public MethodReference getCallee() {
        return this.callee;
    }

    public String getClassType() {
        return this.callee.getDeclaringClass().getName().toString();
    }

    public IInvokeInstruction.IDispatch getInvocationCode() {
        return this.dispatchType;
    }

    public String getMethodName() {
        return this.callee.getName().toString();
    }

    public String getMethodSignature() {
        String fullSig = this.callee.getSignature();
        return fullSig.substring(fullSig.indexOf(40));
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return (this.dispatchType.hasImplicitThis() ? 1 : 0) + this.callee.getNumberOfParameters();
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return this.callee.getReturnType().getName().toString();
    }

    public byte getPushedWordSize() {
        if (this.returnType == Translator.RuntimeType.Void) {
            return 0;
        }
        if (this.returnType == Translator.RuntimeType.int64 || this.returnType == Translator.RuntimeType.F) {
            return 2;
        }
        return 1;
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return this.dispatchType != Dispatch.JMP;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitInvoke((IInvokeInstruction)this);
    }

    public static enum Dispatch implements IInvokeInstruction.IDispatch
    {
        CALLI{

            public boolean hasImplicitThis() {
                return false;
            }
        }
        ,
        JMP{

            public boolean hasImplicitThis() {
                return false;
            }
        };

    }
}

