/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.ILoadIndirectInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.types.TypeReference;

public class CILLoadIndirectInstruction
implements ILoadIndirectInstruction {
    private final TypeReference loadedType;
    private final Translator.RuntimeType runtimeType;

    CILLoadIndirectInstruction(TypeReference loadedType, Translator.RuntimeType runtimeType) {
        this.loadedType = loadedType;
        this.runtimeType = runtimeType;
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return this.loadedType.getName().toString();
    }

    public byte getPushedWordSize() {
        return this.runtimeType.size();
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return true;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitLoadIndirect((ILoadIndirectInstruction)this);
    }

    public String toString() {
        return "LoadIndirect(" + this.loadedType + "," + (Object)((Object)this.runtimeType) + ")";
    }
}

