/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Bytecode;
import com.ibm.wala.dotnet.cil.CILArrayLoadInstruction;
import com.ibm.wala.dotnet.cil.CILArrayStoreInstruction;
import com.ibm.wala.dotnet.cil.CILBinaryOpInstruction;
import com.ibm.wala.dotnet.cil.CILComparisonInstruction;
import com.ibm.wala.dotnet.cil.CILConditionalBranchInstruction;
import com.ibm.wala.dotnet.cil.CILConversionInstruction;
import com.ibm.wala.dotnet.cil.CILGetInstruction;
import com.ibm.wala.dotnet.cil.CILInvokeInstruction;
import com.ibm.wala.dotnet.cil.CILIsInstInstruction;
import com.ibm.wala.dotnet.cil.CILLoadIndirectInstruction;
import com.ibm.wala.dotnet.cil.CILLoadInstruction;
import com.ibm.wala.dotnet.cil.CILMetadataConstantInstruction;
import com.ibm.wala.dotnet.cil.CILPutInstruction;
import com.ibm.wala.dotnet.cil.CILShiftInstruction;
import com.ibm.wala.dotnet.cil.CILStoreIndirectInstruction;
import com.ibm.wala.dotnet.cil.CILStoreInstruction;
import com.ibm.wala.dotnet.cil.CILUnaryOpInstruction;
import com.ibm.wala.dotnet.loader.AssemblyClassLoader;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public class Translator<C, F, M, A, T> {
    private final byte[] bytecode;
    private final AssemblyClassLoader<C, F, M, A, T> loader;
    private final CLRMethod<C, F, M, A, T> method;
    public final List<IInstruction> instructions = new ArrayList<IInstruction>();
    private Stack<RuntimeType> stack = new Stack();
    private final Map<Integer, List<CLRMethod.ExceptionEntry>> exceptions;
    private final SortedSet<InstructionMap> instMaps = new TreeSet<InstructionMap>();
    private final MutableIntSet addressTakenArguments = IntSetUtil.make();
    private final MutableIntSet addressTakenLocals = IntSetUtil.make();
    public final BCInfo<C, F, M, A, T> emptyInfo = new BCInfo(new IInstruction[]{PopInstruction.make((int)0)}, new int[0], Collections.EMPTY_LIST, new int[0]);

    private Translator(CLRMethod<C, F, M, A, T> method) {
        this.method = method;
        this.loader = method.getDeclaringClass().getClassLoader();
        this.bytecode = method.getBytecode();
        this.exceptions = new HashMap<Integer, List<CLRMethod.ExceptionEntry>>();
        for (CLRMethod.ExceptionEntry entry : method.getExceptionEntries()) {
            this.addException(entry.tryStart, entry);
            this.addException(entry.tryEnd, entry);
            this.addException(entry.handlerStart, entry);
            this.addException(entry.handlerEnd, entry);
        }
    }

    private List<CLRMethod.ExceptionEntry> getFinallyBlocks(int bytecodeOffset) {
        LinkedList<CLRMethod.ExceptionEntry> result = new LinkedList<CLRMethod.ExceptionEntry>();
        for (CLRMethod.ExceptionEntry entry : this.method.getExceptionEntries()) {
            if (entry.handlerKind != CLRMethod.HandlerKind.FINALLY || entry.tryStart > bytecodeOffset || bytecodeOffset > entry.tryEnd) continue;
            result.add(entry);
        }
        return result;
    }

    private List<CLRMethod.ExceptionEntry> getExitedFinallyBlocks(int start, int end) {
        List<CLRMethod.ExceptionEntry> sb = this.getFinallyBlocks(start);
        List<CLRMethod.ExceptionEntry> eb = this.getFinallyBlocks(end);
        sb.removeAll(eb);
        return sb;
    }

    private void addException(int index, CLRMethod.ExceptionEntry entry) {
        if (!this.exceptions.containsKey(index)) {
            this.exceptions.put(index, new LinkedList());
        }
        this.exceptions.get(index).add(entry);
    }

    private long read64(int i) {
        return (long)this.read32(i + 4) << 32 | (long)this.read32(i) & 0xFFFFFFFFL;
    }

    private int read32(int i) {
        return this.read8(i + 3) << 24 | this.read8(i + 2) << 16 | this.read8(i + 1) << 8 | this.read8(i);
    }

    private int read16(int i) {
        return this.read8(i + 1) << 8 | this.read8(i);
    }

    private int read8(int i) {
        return this.bytecode[i] & 0xFF;
    }

    private int argIndex(int i) {
        return i;
    }

    private int localIndex(int i) {
        return i + this.method.getNumberOfParameters();
    }

    public static RuntimeType getRuntimeType(String type) {
        if (type.startsWith("P")) {
            type = type.substring(1, type.length());
        }
        if (type.equals("void")) {
            return RuntimeType.Void;
        }
        if (type.equals("int64") || type.equals("uint64")) {
            return RuntimeType.int64;
        }
        if (type.equals("double") || type.equals("single") || type.equals("float") || type.equals("float32") || type.equals("float64")) {
            return RuntimeType.F;
        }
        if (type.equals("typedbyref")) {
            return RuntimeType.ref;
        }
        if (type.matches("u?intptr")) {
            return RuntimeType.nativeInt;
        }
        if (type.matches("u?int[1-9]*") || type.equals("boolean") || type.equals("char") || type.matches("s?byte")) {
            return RuntimeType.int32;
        }
        return RuntimeType.O;
    }

    public RuntimeType getRuntimeType(TypeReference type) {
        C handle;
        if (type.isPrimitiveType()) {
            assert (type.getName().toString().length() > 8) : type.toString();
            return Translator.getRuntimeType(type.getName().toString().substring(8).toLowerCase());
        }
        String typeName = type.getName().toString();
        RuntimeType t = Translator.getRuntimeType(typeName);
        LowLevelInterface<C, F, M, A, T> reader = this.loader.getAssembly().getReader();
        if (!reader.classNotValid(handle = reader.findClass(type)) && t != RuntimeType.Void && (reader.classIsValueType(handle) || reader.classIsPointer(handle)) && !reader.classIsPrimitive(handle)) {
            return RuntimeType.nativeInt;
        }
        return t;
    }

    public static String toDescriptor(RuntimeType type) {
        if (type == RuntimeType.int32 || type == RuntimeType.nativeInt) {
            return "I";
        }
        if (type == RuntimeType.int64) {
            return "J";
        }
        if (type == RuntimeType.F) {
            return "D";
        }
        if (type == RuntimeType.O) {
            return "Ljava/lang/Object;";
        }
        if (type == RuntimeType.Void) {
            return "V";
        }
        if (type == RuntimeType.ref) {
            return "I";
        }
        assert (false);
        return null;
    }

    private MethodReference getMethodRef(M handle) {
        C type = this.loader.getAssembly().getReader().methodGetDeclaringClass(handle);
        TypeReference tref = this.loader.scope.findClass(type);
        String methodName = this.loader.getAssembly().getReader().methodGetName(handle);
        Atom mn = Atom.findOrCreateUnicodeAtom((String)methodName);
        Descriptor descriptor = this.loader.computeMethodDescriptor(type, handle);
        return MethodReference.findOrCreate((TypeReference)tref, (Atom)mn, (Descriptor)descriptor);
    }

    private TypeReference getTypeRef(C handle) {
        return this.loader.getReference(handle);
    }

    private FieldReference getFieldRef(F handle) {
        TypeReference declaringRef = this.getTypeRef(this.loader.getAssembly().getReader().fieldDeclaringClass(handle));
        String fieldName = this.loader.getAssembly().getReader().fieldGetName(handle);
        Atom nm = Atom.findOrCreateUnicodeAtom((String)fieldName);
        C type = this.loader.getAssembly().getReader().fieldGetType(handle);
        TypeReference typeRef = this.loader.getReference(type);
        return FieldReference.findOrCreate((TypeReference)declaringRef, (Atom)nm, (TypeReference)typeRef);
    }

    private IInvokeInstruction.IDispatch getDispatchType(Bytecode.Opcode op, M handle) {
        if (op == Bytecode.Opcode.op_call || op == Bytecode.Opcode.op_newobj) {
            if (this.loader.getAssembly().getReader().methodIsStatic(handle)) {
                return IInvokeInstruction.Dispatch.STATIC;
            }
            return IInvokeInstruction.Dispatch.SPECIAL;
        }
        if (op == Bytecode.Opcode.op_callvirt) {
            C type = this.loader.getAssembly().getReader().methodGetDeclaringClass(handle);
            if (this.loader.getAssembly().getReader().classIsInterface(type)) {
                return IInvokeInstruction.Dispatch.INTERFACE;
            }
            return IInvokeInstruction.Dispatch.VIRTUAL;
        }
        assert (op == Bytecode.Opcode.op_calli);
        return CILInvokeInstruction.Dispatch.CALLI;
    }

    private TypeReference getTypeFromFlags(Set<Bytecode.Flag> flags) {
        if (flags.contains((Object)Bytecode.Flag.flag_i1)) {
            return CLRTypeReference.Int8;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_i2)) {
            return CLRTypeReference.Int16;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_i4)) {
            return CLRTypeReference.Int32;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_i8)) {
            return CLRTypeReference.Int64;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_u1)) {
            return CLRTypeReference.UInt8;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_u2)) {
            return CLRTypeReference.UInt16;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_u4)) {
            return CLRTypeReference.UInt32;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_u8)) {
            return CLRTypeReference.UInt64;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_r4)) {
            return CLRTypeReference.Float32;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_r8)) {
            return CLRTypeReference.Float64;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_i)) {
            return CLRTypeReference.IntPtr;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_r)) {
            return CLRTypeReference.Float64;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_u)) {
            return CLRTypeReference.UIntPtr;
        }
        if (flags.contains((Object)Bytecode.Flag.flag_ref)) {
            return CLRTypeReference.SystemObject;
        }
        return CLRTypeReference.Void;
    }

    private void initializeLocals() {
        for (int i = 0; i < this.loader.getAssembly().getReader().methodGetMaxLocals(this.method.getHandle()); ++i) {
            C typeHandle = this.method.getLocalVariableType(i);
            TypeReference localType = this.getTypeRef(typeHandle);
            RuntimeType rt = this.getRuntimeType(localType);
            switch (rt) {
                case ref: 
                case O: {
                    this.instructions.add((IInstruction)ConstantInstruction.makeString(null));
                    break;
                }
                case int32: 
                case nativeInt: {
                    this.instructions.add((IInstruction)ConstantInstruction.make((int)0));
                    break;
                }
                case int64: {
                    this.instructions.add((IInstruction)ConstantInstruction.make((long)0L));
                    break;
                }
                case F: {
                    this.instructions.add((IInstruction)ConstantInstruction.make((double)0.0));
                }
            }
            this.instructions.add((IInstruction)new CILStoreInstruction(this.localIndex(i), rt, false));
        }
    }

    public BCInfo<C, F, M, A, T> translateInternal() {
        this.initializeLocals();
        new Visitor(null, 0, this.bytecode.length).translateBytecode();
        int[] pcMap = new int[this.instructions.size()];
        for (int i = 0; i < pcMap.length; ++i) {
            pcMap[i] = -1;
        }
        LinkedList<CLRMethod.ExceptionEntry> allEntries = new LinkedList<CLRMethod.ExceptionEntry>();
        IInstruction[] instrsArray = this.instructions.toArray(new IInstruction[this.instructions.size()]);
        for (InstructionMap map : this.instMaps) {
            CLRMethod.ExceptionEntry[] values;
            int[] targetMap = map.targetMap();
            int bcStart = map.mapInstIndex(map.getStart());
            int bcEnd = map.mapInstIndex(map.end);
            for (Integer inst : map.pcMap.keySet()) {
                pcMap[inst.intValue()] = map.mapInstIndex(inst);
                int[] oldBranchTargets = instrsArray[inst].getBranchTargets();
                instrsArray[inst.intValue()] = instrsArray[inst].redirectTargets(targetMap);
                int[] branchTargets = instrsArray[inst].getBranchTargets();
                assert (branchTargets != null) : instrsArray[inst].getClass() + ": " + instrsArray[inst];
                for (int i = 0; i < branchTargets.length; ++i) {
                    assert (branchTargets[i] != -1) : "no map for " + oldBranchTargets[i] + " in " + this.method;
                }
            }
            for (CLRMethod.ExceptionEntry e : values = this.method.getExceptionEntries()) {
                if ((e.handlerKind == CLRMethod.HandlerKind.FINALLY || e.handlerKind == CLRMethod.HandlerKind.FAULT) && e.handlerStart == bcStart || (e.tryStart > bcStart || e.tryEnd < bcEnd) && (e.tryStart < bcStart || e.tryEnd > bcEnd)) continue;
                for (int i = targetMap[e.tryStart]; i <= targetMap[e.tryEnd]; ++i) {
                    if (!map.pcMap.containsKey(i)) continue;
                    CLRMethod<C, F, M, A, T> cLRMethod = this.method;
                    cLRMethod.getClass();
                    allEntries.add(new CLRMethod.ExceptionEntry(cLRMethod, e.handlerKind, e.catchType, i, i, e.filterStart == -1 ? -1 : targetMap[e.filterStart], targetMap[e.handlerStart], targetMap[e.handlerEnd]));
                }
            }
        }
        final MutableIntSet addressTakenIndices = IntSetUtil.make();
        this.addressTakenArguments.foreach(new IntSetAction(){

            public void act(int x) {
                addressTakenIndices.add(Translator.this.argIndex(x));
            }
        });
        this.addressTakenLocals.foreach(new IntSetAction(){

            public void act(int x) {
                addressTakenIndices.add(Translator.this.localIndex(x));
            }
        });
        return BCInfo.make(instrsArray, pcMap, allEntries, IntSetUtil.toArray((IntSet)addressTakenIndices));
    }

    public static <C, F, M, A, T> BCInfo<C, F, M, A, T> translate(CLRMethod<C, F, M, A, T> m) {
        Translator<C, F, M, A, T> xlator = new Translator<C, F, M, A, T>(m);
        try {
            return xlator.translateInternal();
        }
        catch (TranslatorError e) {
            return xlator.emptyInfo;
        }
    }

    private class Visitor {
        private final int end;
        private int cursor;
        private int startCursor;
        private final InstructionMap pcMap;
        private final Map<Integer, Stack<RuntimeType>> branchStacks = new HashMap<Integer, Stack<RuntimeType>>();
        private final Bytecode.CILVisitor instTranslator = new Bytecode.CILVisitor(){

            @Override
            public void visit_add(Set<Bytecode.Flag> flags) {
                Visitor.this.doBinaryOp(Bytecode.Opcode.op_add, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.ADD);
            }

            @Override
            public void visit_and(Set<Bytecode.Flag> flags) {
                Visitor.this.doIntegerOp(Bytecode.Opcode.op_and, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.AND);
            }

            @Override
            public void visit_beq(Set<Bytecode.Flag> flags) {
                Visitor.this.doBranch(Bytecode.Opcode.op_beq, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.EQ);
            }

            @Override
            public void visit_bge(Set<Bytecode.Flag> flags) {
                Visitor.this.doBranch(Bytecode.Opcode.op_bge, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.GE);
            }

            @Override
            public void visit_bgt(Set<Bytecode.Flag> flags) {
                Visitor.this.doBranch(Bytecode.Opcode.op_bgt, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.GT);
            }

            @Override
            public void visit_ble(Set<Bytecode.Flag> flags) {
                Visitor.this.doBranch(Bytecode.Opcode.op_ble, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.LE);
            }

            @Override
            public void visit_blt(Set<Bytecode.Flag> flags) {
                Visitor.this.doBranch(Bytecode.Opcode.op_blt, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.LT);
            }

            @Override
            public void visit_bne(Set<Bytecode.Flag> flags) {
                Visitor.this.doBranch(Bytecode.Opcode.op_bne, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.NE);
            }

            @Override
            public void visit_box(Set<Bytecode.Flag> flags) {
                TypeReference boxedType = Visitor.this.readType();
                RuntimeType value = (RuntimeType)((Object)Translator.this.stack.pop());
                Translator.this.stack.push(Translator.this.getRuntimeType(boxedType));
                Visitor.this.addInstruction((IInstruction)new CILUnaryOpInstruction(CILUnaryOpInstruction.Operator.BOX, value));
            }

            @Override
            public void visit_br(Set<Bytecode.Flag> flags) {
                int offset;
                if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    offset = (byte)Visitor.this.read8();
                    Visitor.this.cursor++;
                } else {
                    offset = Visitor.this.read32();
                    Visitor.this.cursor = Visitor.this.cursor + 4;
                }
                int target = Visitor.this.cursor + offset;
                assert (target < Translator.this.bytecode.length);
                Visitor.this.addInstruction((IInstruction)GotoInstruction.make((int)target));
                Visitor.this.branchStacks.put(target, (Stack)Translator.this.stack.clone());
                Translator.this.stack = null;
            }

            @Override
            public void visit_break(Set<Bytecode.Flag> flags) {
            }

            @Override
            public void visit_brfalse(Set<Bytecode.Flag> flags) {
                if (((RuntimeType)((Object)Translator.this.stack.peek())).equals((Object)RuntimeType.O)) {
                    Visitor.this.addInstruction((IInstruction)ConstantInstruction.makeString(null));
                } else {
                    Visitor.this.addInstruction((IInstruction)ConstantInstruction.make((int)0));
                }
                Visitor.this.doBranch(Bytecode.Opcode.op_brfalse, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.EQ);
            }

            @Override
            public void visit_brtrue(Set<Bytecode.Flag> flags) {
                if (((RuntimeType)((Object)Translator.this.stack.peek())).equals((Object)RuntimeType.O)) {
                    Visitor.this.addInstruction((IInstruction)ConstantInstruction.makeString(null));
                } else {
                    Visitor.this.addInstruction((IInstruction)ConstantInstruction.make((int)0));
                }
                Visitor.this.doBranch(Bytecode.Opcode.op_brtrue, flags, (IConditionalBranchInstruction.IOperator)IConditionalBranchInstruction.Operator.NE);
            }

            @Override
            public void visit_call(Set<Bytecode.Flag> flags) {
                Visitor.this.doCall(Bytecode.Opcode.op_call);
            }

            @Override
            public void visit_calli(Set<Bytecode.Flag> flags) {
                Visitor.this.doCall(Bytecode.Opcode.op_calli);
            }

            @Override
            public void visit_callvirt(Set<Bytecode.Flag> flags) {
                Visitor.this.doCall(Bytecode.Opcode.op_callvirt);
            }

            @Override
            public void visit_castclass(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Visitor.this.addInstruction((IInstruction)CheckCastInstruction.make((String)type.getName().toString()));
            }

            @Override
            public void visit_ckfinite(Set<Bytecode.Flag> flags) {
                Visitor.this.doUnaryOp(Bytecode.Opcode.op_ckfinite, flags, CILUnaryOpInstruction.Operator.CK_FINITE);
            }

            @Override
            public void visit_conv(Set<Bytecode.Flag> flags) {
                RuntimeType fromType = (RuntimeType)((Object)Translator.this.stack.pop());
                TypeReference toType = Translator.this.getTypeFromFlags(flags);
                RuntimeType tt = Translator.this.getRuntimeType(toType);
                Translator.this.stack.push(tt);
                Visitor.this.addInstruction((IInstruction)new CILConversionInstruction(flags, fromType, tt, toType));
            }

            @Override
            public void visit_cpobj(Set<Bytecode.Flag> flags) {
                Visitor.this.doUnaryOp(Bytecode.Opcode.op_cpobj, flags, CILUnaryOpInstruction.Operator.CPOBJ);
            }

            @Override
            public void visit_div(Set<Bytecode.Flag> flags) {
                Visitor.this.doBinaryOp(Bytecode.Opcode.op_div, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.DIV);
            }

            @Override
            public void visit_dup(Set<Bytecode.Flag> flags) {
                Visitor.this.addInstruction((IInstruction)DupInstruction.make((int)0));
                Translator.this.stack.push(Translator.this.stack.peek());
            }

            @Override
            public void visit_endfinally(Set<Bytecode.Flag> flags) {
                if (Visitor.this.cursor != Visitor.this.end || Visitor.this.pcMap.parent == null) {
                    Visitor.this.addInstruction((IInstruction)ThrowInstruction.make((boolean)true));
                } else {
                    Visitor.this.addInstruction((IInstruction)PopInstruction.make((int)0));
                }
                Translator.this.stack = null;
            }

            @Override
            public void visit_isinst(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Visitor.this.addInstruction(CILIsInstInstruction.make(type));
            }

            @Override
            public void visit_jmp(Set<Bytecode.Flag> flags) {
                Visitor.this.doCall(Bytecode.Opcode.op_jmp);
                Translator.this.stack = null;
            }

            @Override
            public void visit_ldarg(Set<Bytecode.Flag> flags) {
                int index = -1;
                if (flags.contains((Object)Bytecode.Flag.flag_0)) {
                    index = 0;
                } else if (flags.contains((Object)Bytecode.Flag.flag_1)) {
                    index = 1;
                } else if (flags.contains((Object)Bytecode.Flag.flag_2)) {
                    index = 2;
                } else if (flags.contains((Object)Bytecode.Flag.flag_3)) {
                    index = 3;
                } else if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    index = Visitor.this.read8();
                    Visitor.this.cursor++;
                } else assert (false);
                TypeReference type = Translator.this.method.getParameterType(index);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.argIndex(index), type, Translator.this.getRuntimeType(type), true, false));
                Translator.this.stack.push(Translator.this.getRuntimeType(type));
            }

            @Override
            public void visit_ldarga(Set<Bytecode.Flag> flags) {
                assert (flags.contains((Object)Bytecode.Flag.flag_s));
                int index = Visitor.this.read8();
                Visitor.this.cursor++;
                TypeReference type = Translator.this.method.getParameterType(index);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.argIndex(index), type, Translator.this.getRuntimeType(type), true, false));
                Translator.this.stack.push(RuntimeType.ref);
            }

            @Override
            public void visit_ldc(Set<Bytecode.Flag> flags) {
                ConstantInstruction inst;
                RuntimeType type = RuntimeType.int32;
                if (flags.contains((Object)Bytecode.Flag.flag_0)) {
                    inst = ConstantInstruction.make((int)0);
                } else if (flags.contains((Object)Bytecode.Flag.flag_1)) {
                    inst = ConstantInstruction.make((int)1);
                } else if (flags.contains((Object)Bytecode.Flag.flag_2)) {
                    inst = ConstantInstruction.make((int)2);
                } else if (flags.contains((Object)Bytecode.Flag.flag_3)) {
                    inst = ConstantInstruction.make((int)3);
                } else if (flags.contains((Object)Bytecode.Flag.flag_4)) {
                    inst = ConstantInstruction.make((int)4);
                } else if (flags.contains((Object)Bytecode.Flag.flag_5)) {
                    inst = ConstantInstruction.make((int)5);
                } else if (flags.contains((Object)Bytecode.Flag.flag_6)) {
                    inst = ConstantInstruction.make((int)6);
                } else if (flags.contains((Object)Bytecode.Flag.flag_7)) {
                    inst = ConstantInstruction.make((int)7);
                } else if (flags.contains((Object)Bytecode.Flag.flag_8)) {
                    inst = ConstantInstruction.make((int)8);
                } else if (flags.contains((Object)Bytecode.Flag.flag_m1)) {
                    inst = ConstantInstruction.make((int)-1);
                } else if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    int value = Visitor.this.read8();
                    Visitor.this.cursor++;
                    inst = ConstantInstruction.make((int)value);
                } else if (flags.contains((Object)Bytecode.Flag.flag_i4)) {
                    inst = ConstantInstruction.make((int)Visitor.this.read32());
                    Visitor.this.cursor = Visitor.this.cursor + 4;
                } else if (flags.contains((Object)Bytecode.Flag.flag_i8)) {
                    inst = ConstantInstruction.make((long)Visitor.this.read64());
                    type = RuntimeType.int64;
                    Visitor.this.cursor = Visitor.this.cursor + 8;
                } else if (flags.contains((Object)Bytecode.Flag.flag_r4)) {
                    inst = ConstantInstruction.make((float)Float.intBitsToFloat(Visitor.this.read32()));
                    Visitor.this.cursor = Visitor.this.cursor + 4;
                    type = RuntimeType.F;
                } else if (flags.contains((Object)Bytecode.Flag.flag_r8)) {
                    inst = ConstantInstruction.make((double)Double.longBitsToDouble(Visitor.this.read64()));
                    Visitor.this.cursor = Visitor.this.cursor + 8;
                    type = RuntimeType.F;
                } else {
                    inst = null;
                    assert (false);
                }
                Translator.this.stack.push(type);
                Visitor.this.addInstruction((IInstruction)inst);
            }

            @Override
            public void visit_ldelem(Set<Bytecode.Flag> flags) {
                TypeReference eltType = Translator.this.getTypeFromFlags(flags);
                RuntimeType type = Translator.this.getRuntimeType(eltType);
                if (type == RuntimeType.Void) {
                    TypeReference declaredType = Visitor.this.readType();
                    type = Translator.this.getRuntimeType(declaredType);
                }
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                Translator.this.stack.push(type);
                Visitor.this.addInstruction(new CILArrayLoadInstruction(eltType, false));
            }

            @Override
            public void visit_ldelema(Set<Bytecode.Flag> flags) {
                TypeReference eltType = Visitor.this.readType();
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                Translator.this.stack.push(Translator.this.getRuntimeType(eltType));
                Visitor.this.addInstruction(new CILArrayLoadInstruction(eltType, true));
            }

            @Override
            public void visit_ldfld(Set<Bytecode.Flag> flags) {
                boolean isStatic = Visitor.this.checkStaticField();
                int token = Visitor.this.read32();
                Object fieldHandle = Translator.this.loader.resolveFieldToken(Translator.this.method, token);
                Object typeHandle = Translator.this.loader.getAssembly().getReader().fieldGetType(fieldHandle);
                TypeReference typeRef = Translator.this.loader.getReference(typeHandle);
                FieldReference field = Visitor.this.readField();
                assert (typeRef != null && field != null) : "field: " + field + ", type: " + typeRef;
                Translator.this.stack.pop();
                RuntimeType type = Translator.this.getRuntimeType(typeRef);
                Translator.this.stack.push(type);
                Visitor.this.addInstruction(new CILGetInstruction(field, isStatic, false));
                if (isStatic) {
                    Visitor.this.addInstruction((IInstruction)PopInstruction.make((int)1));
                }
            }

            @Override
            public void visit_ldflda(Set<Bytecode.Flag> flags) {
                boolean isStatic = Visitor.this.checkStaticField();
                FieldReference field = Visitor.this.readField();
                Translator.this.stack.pop();
                Translator.this.stack.push(RuntimeType.nativeInt);
                Visitor.this.addInstruction(new CILGetInstruction(field, isStatic, true));
                if (isStatic) {
                    Visitor.this.addInstruction((IInstruction)PopInstruction.make((int)1));
                }
            }

            @Override
            public void visit_ldind(Set<Bytecode.Flag> flags) {
                TypeReference type = Translator.this.getTypeFromFlags(flags);
                RuntimeType runtimeType = Translator.this.getRuntimeType(type);
                Translator.this.stack.pop();
                Translator.this.stack.push(runtimeType);
                Visitor.this.addInstruction((IInstruction)new CILLoadIndirectInstruction(type, runtimeType));
            }

            @Override
            public void visit_ldlen(Set<Bytecode.Flag> flags) {
                Translator.this.stack.pop();
                Translator.this.stack.push(RuntimeType.nativeInt);
                Visitor.this.addInstruction((IInstruction)ArrayLengthInstruction.make());
            }

            @Override
            public void visit_ldloc(Set<Bytecode.Flag> flags) {
                int index = -1;
                if (flags.contains((Object)Bytecode.Flag.flag_0)) {
                    index = 0;
                } else if (flags.contains((Object)Bytecode.Flag.flag_1)) {
                    index = 1;
                } else if (flags.contains((Object)Bytecode.Flag.flag_2)) {
                    index = 2;
                } else if (flags.contains((Object)Bytecode.Flag.flag_3)) {
                    index = 3;
                } else if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    index = Visitor.this.read8();
                    Visitor.this.cursor++;
                } else assert (false);
                TypeReference type = Translator.this.loader.getReference(Translator.this.method.getLocalVariableType(index));
                RuntimeType runtimeType = Translator.this.getRuntimeType(type);
                Translator.this.stack.push(runtimeType);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.localIndex(index), type, runtimeType, false, false));
            }

            @Override
            public void visit_ldloca(Set<Bytecode.Flag> flags) {
                TypeReference type;
                int index = -1;
                if (flags.contains((Object)Bytecode.Flag.flag_0)) {
                    index = 0;
                } else if (flags.contains((Object)Bytecode.Flag.flag_1)) {
                    index = 1;
                } else if (flags.contains((Object)Bytecode.Flag.flag_2)) {
                    index = 2;
                } else if (flags.contains((Object)Bytecode.Flag.flag_3)) {
                    index = 3;
                } else if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    index = Visitor.this.read8();
                    Visitor.this.cursor++;
                } else assert (false);
                Translator.this.stack.push(RuntimeType.ref);
                try {
                    type = Translator.this.loader.getReference(Translator.this.method.getLocalVariableType(index));
                }
                catch (Exception e) {
                    throw new TranslatorError("Cannot understand type in " + Translator.this.method + " at " + Visitor.this.cursor);
                }
                RuntimeType runtimeType = Translator.this.getRuntimeType(type);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.localIndex(index), type, runtimeType, false, true));
            }

            @Override
            public void visit_ldnull(Set<Bytecode.Flag> flags) {
                Translator.this.stack.push(RuntimeType.O);
                Visitor.this.addInstruction((IInstruction)ConstantInstruction.makeString(null));
            }

            @Override
            public void visit_ldobj(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Translator.this.stack.pop();
                Translator.this.stack.push(Translator.this.getRuntimeType(type));
                Visitor.this.addInstruction((IInstruction)new CILLoadIndirectInstruction(type, Translator.this.getRuntimeType(type)));
            }

            @Override
            public void visit_ldsfld(Set<Bytecode.Flag> flags) {
                if (!Visitor.this.checkStaticField()) {
                    throw new TranslatorError("cannot read type in " + Translator.this.method + " at " + Visitor.this.cursor);
                }
                FieldReference field = Visitor.this.readField();
                RuntimeType type = Translator.this.getRuntimeType(field.getFieldType());
                Translator.this.stack.push(type);
                Visitor.this.addInstruction(new CILGetInstruction(field, true, false));
            }

            @Override
            public void visit_ldsflda(Set<Bytecode.Flag> flags) {
                if (!Visitor.this.checkStaticField()) {
                    throw new TranslatorError("cannot read type in " + Translator.this.method + " at " + Visitor.this.cursor);
                }
                FieldReference field = Visitor.this.readField();
                Translator.this.stack.push(RuntimeType.nativeInt);
                Visitor.this.addInstruction(new CILGetInstruction(field, true, true));
            }

            @Override
            public void visit_ldstr(Set<Bytecode.Flag> flags) {
                int token = Visitor.this.read32();
                Visitor.this.cursor = Visitor.this.cursor + 4;
                Translator.this.stack.push(RuntimeType.O);
                Visitor.this.addInstruction((IInstruction)ConstantInstruction.makeString((String)Translator.this.loader.resolveStringToken(Translator.this.method, token)));
            }

            @Override
            public void visit_ldtoken(Set<Bytecode.Flag> flags) {
                int token = Visitor.this.read32();
                Visitor.this.cursor = Visitor.this.cursor + 4;
                Translator.this.stack.push(RuntimeType.ref);
                Object c_handle = Translator.this.loader.resolveTypeToken(Translator.this.method, token);
                if (!Translator.this.loader.getAssembly().getReader().classNotValid(c_handle)) {
                    TypeReference ref = Translator.this.loader.getReference(c_handle);
                    Visitor.this.addInstruction((IInstruction)new CILMetadataConstantInstruction(CLRTypeReference.SystemType, ref));
                    return;
                }
                Object m_handle = Translator.this.loader.resolveMethodToken(Translator.this.method, token);
                if (!Translator.this.loader.getAssembly().getReader().methodNotValid(m_handle)) {
                    MethodReference ref = Translator.this.getMethodRef(m_handle);
                    Visitor.this.addInstruction((IInstruction)new CILMetadataConstantInstruction(CLRTypeReference.SystemReflectionMethodBase, ref));
                    return;
                }
                Object f_handle = Translator.this.loader.resolveFieldToken(Translator.this.method, token);
                if (!Translator.this.loader.getAssembly().getReader().fieldNotValid(f_handle)) {
                    FieldReference ref = Translator.this.getFieldRef(f_handle);
                    Visitor.this.addInstruction((IInstruction)new CILMetadataConstantInstruction(CLRTypeReference.SystemReflectionFieldInfo, ref));
                    return;
                }
                throw new TranslatorError("Cannot understand token in " + Translator.this.method + " at " + Visitor.this.cursor);
            }

            @Override
            public void visit_leave(Set<Bytecode.Flag> flags) {
                int offset;
                if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    offset = (byte)Visitor.this.read8();
                    Visitor.this.cursor++;
                } else {
                    offset = Visitor.this.read32();
                    Visitor.this.cursor = Visitor.this.cursor + 4;
                }
                int target = offset + Visitor.this.cursor;
                if (target > Visitor.this.cursor) {
                    Visitor.this.branchStacks.put(target, new Stack());
                }
                List finallyBlocks = Translator.this.getExitedFinallyBlocks(Visitor.this.startCursor, target);
                for (CLRMethod.ExceptionEntry entry : finallyBlocks) {
                    Visitor v = new Visitor(Visitor.this.pcMap, entry.handlerStart, entry.handlerEnd);
                    v.translateBytecode();
                }
                assert (target < Translator.this.bytecode.length);
                Visitor.this.addInstruction((IInstruction)GotoInstruction.make((int)target));
                Translator.this.stack = null;
            }

            @Override
            public void visit_mkrefany(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
            }

            @Override
            public void visit_mul(Set<Bytecode.Flag> flags) {
                Visitor.this.doBinaryOp(Bytecode.Opcode.op_mul, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.MUL);
            }

            @Override
            public void visit_neg(Set<Bytecode.Flag> flags) {
                Visitor.this.doUnaryOp(Bytecode.Opcode.op_neg, flags, (IUnaryOpInstruction.IOperator)IUnaryOpInstruction.Operator.NEG);
            }

            @Override
            public void visit_newarr(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Translator.this.stack.push(Translator.this.getRuntimeType(type));
                Visitor.this.addInstruction((IInstruction)NewInstruction.make((String)("[" + type.getName().toString()), (int)1));
            }

            @Override
            public void visit_newobj(Set<Bytecode.Flag> flags) {
                Translator.this.stack.push(RuntimeType.O);
                MethodReference ctor = Visitor.this.doCall(Bytecode.Opcode.op_newobj);
                Translator.this.stack.push(Translator.this.getRuntimeType(ctor.getDeclaringClass()));
            }

            @Override
            public void visit_nop(Set<Bytecode.Flag> flags) {
                Visitor.this.addInstruction((IInstruction)PopInstruction.make((int)0));
            }

            @Override
            public void visit_not(Set<Bytecode.Flag> flags) {
                Visitor.this.doUnaryOp(Bytecode.Opcode.op_not, flags, CILUnaryOpInstruction.Operator.NOT);
            }

            @Override
            public void visit_or(Set<Bytecode.Flag> flags) {
                Visitor.this.doBinaryOp(Bytecode.Opcode.op_or, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.OR);
            }

            @Override
            public void visit_pop(Set<Bytecode.Flag> flags) {
                Visitor.this.addInstruction((IInstruction)PopInstruction.make((int)1));
                Translator.this.stack.pop();
            }

            @Override
            public void visit_refanyval(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
            }

            @Override
            public void visit_rem(Set<Bytecode.Flag> flags) {
                Visitor.this.doBinaryOp(Bytecode.Opcode.op_rem, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.REM);
            }

            @Override
            public void visit_ret(Set<Bytecode.Flag> flags) {
                TypeReference retType = Translator.this.method.getReturnType();
                Visitor.this.addInstruction((IInstruction)ReturnInstruction.make((String)Translator.toDescriptor(Translator.this.getRuntimeType(retType))));
                if (Translator.this.getRuntimeType(retType) != RuntimeType.Void) {
                    Translator.this.stack.pop();
                }
                Translator.this.stack = null;
            }

            @Override
            public void visit_shl(Set<Bytecode.Flag> flags) {
                Visitor.this.doShiftOp(Bytecode.Opcode.op_shl, flags, IShiftInstruction.Operator.SHL);
            }

            @Override
            public void visit_shr(Set<Bytecode.Flag> flags) {
                if (flags.contains((Object)Bytecode.Flag.flag_un)) {
                    Visitor.this.doShiftOp(Bytecode.Opcode.op_shr, flags, IShiftInstruction.Operator.USHR);
                } else {
                    Visitor.this.doShiftOp(Bytecode.Opcode.op_shr, flags, IShiftInstruction.Operator.SHR);
                }
            }

            @Override
            public void visit_starg(Set<Bytecode.Flag> flags) {
                assert (flags.contains((Object)Bytecode.Flag.flag_s));
                int index = Visitor.this.read8();
                Visitor.this.cursor++;
                RuntimeType type = Translator.getRuntimeType(Translator.this.method.getParameterType(index).getName().toString());
                Visitor.this.addInstruction((IInstruction)new CILStoreInstruction(Translator.this.argIndex(index), type, true));
                Translator.this.stack.pop();
            }

            @Override
            public void visit_stelem(Set<Bytecode.Flag> flags) {
                TypeReference eltType = Translator.this.getTypeFromFlags(flags);
                RuntimeType type = Translator.this.getRuntimeType(eltType);
                if (type == RuntimeType.Void) {
                    TypeReference declaredType = Visitor.this.readType();
                    type = Translator.getRuntimeType(declaredType.getName().toString());
                }
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                Visitor.this.addInstruction(new CILArrayStoreInstruction(eltType));
            }

            @Override
            public void visit_stfld(Set<Bytecode.Flag> flags) {
                FieldReference field = Visitor.this.readField();
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                Visitor.this.addInstruction(new CILPutInstruction(field, false));
            }

            @Override
            public void visit_stind(Set<Bytecode.Flag> flags) {
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                TypeReference type = Translator.this.getTypeFromFlags(flags);
                Visitor.this.addInstruction((IInstruction)new CILStoreIndirectInstruction(type));
            }

            @Override
            public void visit_stloc(Set<Bytecode.Flag> flags) {
                int index = -1;
                if (flags.contains((Object)Bytecode.Flag.flag_0)) {
                    index = 0;
                } else if (flags.contains((Object)Bytecode.Flag.flag_1)) {
                    index = 1;
                } else if (flags.contains((Object)Bytecode.Flag.flag_2)) {
                    index = 2;
                } else if (flags.contains((Object)Bytecode.Flag.flag_3)) {
                    index = 3;
                } else if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                    index = Visitor.this.read8();
                    Visitor.this.cursor++;
                } else assert (false);
                RuntimeType type = Translator.getRuntimeType(Translator.this.loader.getReference(Translator.this.method.getLocalVariableType(index)).getName().toString());
                Translator.this.stack.pop();
                Visitor.this.addInstruction((IInstruction)new CILStoreInstruction(Translator.this.localIndex(index), type, false));
            }

            @Override
            public void visit_stobj(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Translator.this.stack.pop();
                Translator.this.stack.pop();
                Visitor.this.addInstruction((IInstruction)new CILStoreIndirectInstruction(type));
            }

            @Override
            public void visit_stsfld(Set<Bytecode.Flag> flags) {
                FieldReference field = Visitor.this.readField();
                Translator.this.stack.pop();
                Visitor.this.addInstruction(new CILPutInstruction(field, true));
            }

            @Override
            public void visit_sub(Set<Bytecode.Flag> flags) {
                Visitor.this.doBinaryOp(Bytecode.Opcode.op_sub, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.SUB);
            }

            @Override
            public void visit_switch(Set<Bytecode.Flag> flags) {
                int targets = Visitor.this.read32();
                Visitor.this.cursor = Visitor.this.cursor + 4;
                int endPC = Visitor.this.cursor + 4 * targets;
                int[] casesAndLabels = new int[targets * 2];
                for (int i = 0; i < targets; ++i) {
                    casesAndLabels[2 * i] = i;
                    casesAndLabels[2 * i + 1] = endPC + Visitor.this.read32();
                    Visitor.this.cursor = Visitor.this.cursor + 4;
                }
                assert (Visitor.this.cursor == endPC);
                Translator.this.stack.pop();
                Visitor.this.addInstruction((IInstruction)SwitchInstruction.make((int[])casesAndLabels, (int)endPC));
            }

            @Override
            public void visit_throw(Set<Bytecode.Flag> flags) {
                Translator.this.stack.pop();
                Visitor.this.addInstruction((IInstruction)ThrowInstruction.make((boolean)false));
            }

            @Override
            public void visit_unbox(Set<Bytecode.Flag> flags) {
                Translator.this.stack.pop();
                TypeReference boxedType = Visitor.this.readType();
                RuntimeType value = Translator.this.getRuntimeType(boxedType);
                Visitor.this.addInstruction((IInstruction)new CILUnaryOpInstruction(CILUnaryOpInstruction.Operator.UNBOX, value));
                Translator.this.stack.push(value);
            }

            @Override
            public void visit_xor(Set<Bytecode.Flag> flags) {
                Visitor.this.doIntegerOp(Bytecode.Opcode.op_xor, flags, (IBinaryOpInstruction.IOperator)IBinaryOpInstruction.Operator.XOR);
            }
        };
        private TypeReference constraint;
        private boolean no_typecheck;
        private boolean no_nullcheck;
        private boolean no_rangecheck;
        private boolean readonly;
        private boolean tail;
        private byte alignment;
        private boolean volatile_prefix;
        private final Bytecode.CILPrefixVisitor prefixTranslator = new Bytecode.CILPrefixVisitor(){

            @Override
            public void visit_arglist(Set<Bytecode.Flag> flags) {
                Translator.this.stack.push(RuntimeType.O);
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ceq(Set<Bytecode.Flag> flags) {
                Visitor.this.doCompareOp(Bytecode.Opcode.op_beq, flags, IComparisonInstruction.Operator.CMP);
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_cgt(Set<Bytecode.Flag> flags) {
                if (flags.contains((Object)Bytecode.Flag.flag_un) && Translator.this.stack.peek() == RuntimeType.O) {
                    Visitor.this.doCompareOp(Bytecode.Opcode.op_beq, flags, IComparisonInstruction.Operator.CMP);
                    Visitor.this.doUnaryOp(Bytecode.Opcode.op_not, flags, CILUnaryOpInstruction.Operator.NOT);
                } else {
                    Visitor.this.doCompareOp(Bytecode.Opcode.op_bgt, flags, IComparisonInstruction.Operator.CMPG);
                }
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_clt(Set<Bytecode.Flag> flags) {
                Visitor.this.doCompareOp(Bytecode.Opcode.op_blt, flags, IComparisonInstruction.Operator.CMPL);
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_cpblk(Set<Bytecode.Flag> flags) {
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_endfilter(Set<Bytecode.Flag> flags) {
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_initblk(Set<Bytecode.Flag> flags) {
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_initobj(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Translator.this.stack.pop();
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ldarg(Set<Bytecode.Flag> flags) {
                int index = Visitor.this.read16();
                Visitor.this.cursor = Visitor.this.cursor + 2;
                TypeReference type = Translator.this.method.getParameterType(index);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.argIndex(index), type, Translator.this.getRuntimeType(type), true, false));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ldarga(Set<Bytecode.Flag> flags) {
                int index = Visitor.this.read16();
                Visitor.this.cursor = Visitor.this.cursor + 2;
                TypeReference type = Translator.this.method.getParameterType(index);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.argIndex(index), type, Translator.this.getRuntimeType(type), true, true));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ldftn(Set<Bytecode.Flag> flags) {
                MethodReference method = Visitor.this.readMethod();
                Translator.this.stack.push(RuntimeType.nativeInt);
                Visitor.this.addInstruction((IInstruction)ConstantInstruction.makeString(null));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ldloc(Set<Bytecode.Flag> flags) {
                int index = Visitor.this.read16();
                Visitor.this.cursor = Visitor.this.cursor + 2;
                TypeReference type = Translator.this.loader.getReference(Translator.this.method.getLocalVariableType(index));
                RuntimeType runtimeType = Translator.this.getRuntimeType(type);
                Translator.this.stack.push(runtimeType);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.localIndex(index), type, runtimeType, false, false));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ldloca(Set<Bytecode.Flag> flags) {
                int index = Visitor.this.read16();
                Visitor.this.cursor = Visitor.this.cursor + 2;
                TypeReference type = Translator.this.loader.getReference(Translator.this.method.getLocalVariableType(index));
                RuntimeType runtimeType = Translator.this.getRuntimeType(type);
                Translator.this.stack.push(runtimeType);
                Visitor.this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.localIndex(index), type, runtimeType, false, true));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_ldvirtftn(Set<Bytecode.Flag> flags) {
                MethodReference ref = Visitor.this.readMethod();
                Translator.this.stack.pop();
                Translator.this.stack.push(RuntimeType.nativeInt);
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_localloc(Set<Bytecode.Flag> flags) {
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_refanytype(Set<Bytecode.Flag> flags) {
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_rethrow(Set<Bytecode.Flag> flags) {
                Visitor.this.addInstruction((IInstruction)ThrowInstruction.make((boolean)true));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_sizeof(Set<Bytecode.Flag> flags) {
                TypeReference type = Visitor.this.readType();
                Translator.this.stack.push(RuntimeType.int32);
                Visitor.this.addInstruction((IInstruction)ConstantInstruction.make((int)0));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_starg(Set<Bytecode.Flag> flags) {
                int index = Visitor.this.read16();
                Visitor.this.cursor = Visitor.this.cursor + 2;
                RuntimeType type = Translator.getRuntimeType(Translator.this.method.getParameterType(index).getName().toString());
                Visitor.this.addInstruction((IInstruction)new CILStoreInstruction(Translator.this.argIndex(index), type, true));
                Translator.this.stack.pop();
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_stloc(Set<Bytecode.Flag> flags) {
                int index = Visitor.this.read16();
                Visitor.this.cursor = Visitor.this.cursor + 2;
                RuntimeType type = Translator.getRuntimeType(Translator.this.loader.getReference(Translator.this.method.getLocalVariableType(index)).getName().toString());
                Translator.this.stack.pop();
                Visitor.this.addInstruction((IInstruction)new CILStoreInstruction(Translator.this.localIndex(index), type, false));
                Visitor.this.clearPrefixes();
            }

            @Override
            public void visit_tail(Set<Bytecode.Flag> flags) {
                Visitor.this.tail = true;
            }

            @Override
            public void visit_unaligned(Set<Bytecode.Flag> flags) {
                Visitor.this.alignment = (byte)Visitor.this.read8();
                Visitor.this.cursor++;
            }

            @Override
            public void visit_volatile(Set<Bytecode.Flag> flags) {
                Visitor.this.volatile_prefix = true;
            }

            @Override
            public void visit_constrained(Set<Bytecode.Flag> flags) {
                Visitor.this.constraint = Visitor.this.readType();
            }

            @Override
            public void visit_no(Set<Bytecode.Flag> flags) {
                int code = Visitor.this.read8();
                Visitor.this.cursor++;
                if ((code & 1) != 0) {
                    Visitor.this.no_typecheck = true;
                }
                if ((code & 2) != 0) {
                    Visitor.this.no_rangecheck = true;
                }
                if ((code & 4) != 0) {
                    Visitor.this.no_nullcheck = true;
                }
            }

            @Override
            public void visit_readonly(Set<Bytecode.Flag> flags) {
                Visitor.this.readonly = true;
            }
        };

        private Visitor(InstructionMap parent, int start, int end) {
            this.end = end;
            this.cursor = start;
            this.pcMap = new InstructionMap(parent, Translator.this.instructions.size());
            Translator.this.instMaps.add(this.pcMap);
        }

        private long read64() {
            return Translator.this.read64(this.cursor);
        }

        private int read32() {
            return Translator.this.read32(this.cursor);
        }

        private int read16() {
            return Translator.this.read16(this.cursor);
        }

        private int read8() {
            return Translator.this.read8(this.cursor);
        }

        private TypeReference readType() {
            int token = this.read32();
            this.cursor += 4;
            Object handle = Translator.this.loader.resolveTypeToken(Translator.this.method, token);
            if (Translator.this.loader.getAssembly().getReader().classNotValid(handle)) {
                throw new TranslatorError("cannot read type in " + Translator.this.method + " at " + this.cursor);
            }
            return Translator.this.loader.getReference(handle);
        }

        private MethodReference readMethod() {
            int token = this.read32();
            this.cursor += 4;
            Object handle = Translator.this.loader.resolveMethodToken(Translator.this.method, token);
            if (Translator.this.loader.getAssembly().getReader().methodNotValid(handle)) {
                throw new TranslatorError("cannot read method in " + Translator.this.method + " at " + this.cursor);
            }
            return Translator.this.getMethodRef(handle);
        }

        private boolean checkStaticField() {
            int token = this.read32();
            Object handle = Translator.this.loader.resolveFieldToken(Translator.this.method, token);
            if (Translator.this.loader.getAssembly().getReader().fieldNotValid(handle)) {
                throw new TranslatorError("cannot read static field in " + Translator.this.method + " at " + this.cursor);
            }
            return Translator.this.loader.getAssembly().getReader().fieldIsStatic(handle);
        }

        private FieldReference readField() {
            int token = this.read32();
            this.cursor += 4;
            Object handle = Translator.this.loader.resolveFieldToken(Translator.this.method, token);
            if (Translator.this.loader.getAssembly().getReader().fieldNotValid(handle)) {
                throw new TranslatorError("cannot read field in " + Translator.this.method + " at " + this.cursor);
            }
            return Translator.this.getFieldRef(handle);
        }

        private void doBinaryOp(Bytecode.Opcode op, Set<Bytecode.Flag> flags, IBinaryOpInstruction.IOperator opcode) {
            RuntimeType lhs = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType rhs = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType result = flags.contains((Object)Bytecode.Flag.flag_ovf) ? lhs.overflow(op, rhs) : lhs.binary(op, rhs);
            Translator.this.stack.push(result);
            this.addInstruction((IInstruction)new CILBinaryOpInstruction(flags, opcode, result));
        }

        private void doShiftOp(Bytecode.Opcode op, Set<Bytecode.Flag> flags, IShiftInstruction.Operator opcode) {
            RuntimeType shift = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType value = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType result = value.shift(op, shift);
            Translator.this.stack.push(result);
            this.addInstruction((IInstruction)new CILShiftInstruction(flags, opcode, result));
        }

        private void doIntegerOp(Bytecode.Opcode op, Set<Bytecode.Flag> flags, IBinaryOpInstruction.IOperator opcode) {
            RuntimeType lhs = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType rhs = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType result = lhs.integer(op, rhs);
            Translator.this.stack.push(result);
            this.addInstruction((IInstruction)new CILBinaryOpInstruction(flags, opcode, result));
        }

        private void doCompareOp(Bytecode.Opcode op, Set<Bytecode.Flag> flags, IComparisonInstruction.Operator opcode) {
            RuntimeType lhs = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType rhs = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType result = lhs.branch(op, rhs);
            Translator.this.stack.push(RuntimeType.int32);
            this.addInstruction((IInstruction)new CILComparisonInstruction(opcode, result));
        }

        private void doUnaryOp(Bytecode.Opcode op, Set<Bytecode.Flag> flags, IUnaryOpInstruction.IOperator opcode) {
            RuntimeType operand = (RuntimeType)((Object)Translator.this.stack.pop());
            RuntimeType result = operand.unary(op);
            Translator.this.stack.push(result);
            this.addInstruction((IInstruction)new CILUnaryOpInstruction(opcode, result));
        }

        private void doBranch(Bytecode.Opcode op, Set<Bytecode.Flag> flags, IConditionalBranchInstruction.IOperator opcode) {
            int offset;
            RuntimeType lhs = (RuntimeType)((Object)Translator.this.stack.pop());
            boolean isUnsigned = flags.contains((Object)Bytecode.Flag.flag_un);
            if (flags.contains((Object)Bytecode.Flag.flag_s)) {
                offset = (byte)this.read8();
                ++this.cursor;
            } else {
                offset = this.read32();
                this.cursor += 4;
            }
            int target = this.cursor + offset;
            if (op != Bytecode.Opcode.op_brtrue && op != Bytecode.Opcode.op_brfalse) {
                RuntimeType rhs = (RuntimeType)((Object)Translator.this.stack.pop());
                this.addInstruction((IInstruction)new CILConditionalBranchInstruction(opcode, target, isUnsigned, lhs.branch(op, rhs)));
            } else {
                this.addInstruction((IInstruction)new CILConditionalBranchInstruction(opcode, target, isUnsigned, lhs));
            }
            if (target > this.cursor) {
                this.branchStacks.put(target, (Stack)Translator.this.stack.clone());
            }
        }

        private MethodReference doCall(Bytecode.Opcode op) {
            MethodReference ref;
            boolean isTailCall = this.tail;
            int token = this.read32();
            this.cursor += 4;
            Object handle = Translator.this.loader.resolveMethodToken(Translator.this.method, token);
            if (Translator.this.loader.getAssembly().getReader().methodNotValid(handle)) {
                throw new TranslatorError("invalid method for " + (Object)((Object)op) + " at " + this.startCursor);
            }
            try {
                ref = Translator.this.getMethodRef(handle);
            }
            catch (Exception e) {
                throw new TranslatorError("cannot understand method in " + Translator.this.method + " at " + this.startCursor, e);
            }
            IInvokeInstruction.IDispatch code = Translator.this.getDispatchType(op, handle);
            int numberOfParameters = ref.getNumberOfParameters();
            if (op == Bytecode.Opcode.op_newobj) {
                for (int i = 0; i < numberOfParameters; ++i) {
                    Object paramTypeHandle = Translator.this.loader.getAssembly().getReader().methodGetParameterType(handle, numberOfParameters - i - 1);
                    TypeReference type = Translator.this.loader.getReference(paramTypeHandle);
                    this.addInstruction((IInstruction)new CILStoreInstruction(Translator.this.method.getMaxLocals() + numberOfParameters - i + 1, Translator.this.getRuntimeType(type), false));
                }
                NewInstruction inst = NewInstruction.make((String)ref.getDeclaringClass().getName().toString(), (int)0);
                this.addInstruction((IInstruction)inst);
                this.addInstruction((IInstruction)DupInstruction.make((int)0));
                this.addInstruction((IInstruction)new CILStoreInstruction(Translator.this.method.getMaxLocals() + 1, Translator.this.getRuntimeType(ref.getDeclaringClass()), false));
                for (int i = 0; i < numberOfParameters; ++i) {
                    Object paramTypeHandle = Translator.this.loader.getAssembly().getReader().methodGetParameterType(handle, i);
                    TypeReference type = Translator.this.loader.getReference(paramTypeHandle);
                    this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.method.getMaxLocals() + i + 2, type, Translator.this.getRuntimeType(type), false, false));
                }
            }
            int outParameters = Translator.this.loader.getAssembly().getReader().methodGetNumberOfOutParameters(handle);
            CILInvokeInstruction inst = new CILInvokeInstruction(ref, Translator.this.getRuntimeType(ref.getReturnType()), code, isTailCall, outParameters);
            this.addInstruction((IInstruction)inst);
            for (int i = 0; i < inst.getPoppedCount(); ++i) {
                if (Translator.this.stack.isEmpty()) {
                    throw new TranslatorError("bad stack for call to " + ref + " of type " + code + " at " + this.startCursor);
                }
                Translator.this.stack.pop();
            }
            Object retTypeHandle = Translator.this.loader.getAssembly().getReader().methodGetReturnType(handle);
            TypeReference retTypeRef = Translator.this.loader.getReference(retTypeHandle);
            RuntimeType result = Translator.this.getRuntimeType(retTypeRef);
            if (result != RuntimeType.Void) {
                Translator.this.stack.push(result);
            }
            if (op == Bytecode.Opcode.op_newobj) {
                TypeReference type = ref.getDeclaringClass();
                this.addInstruction((IInstruction)new CILLoadInstruction(Translator.this.method.getMaxLocals() + 1, type, Translator.this.getRuntimeType(type), false, false));
            }
            return ref;
        }

        private void clearPrefixes() {
            this.constraint = null;
            this.no_nullcheck = false;
            this.no_typecheck = false;
            this.no_rangecheck = false;
            this.readonly = false;
            this.tail = false;
            this.alignment = (byte)-1;
            this.volatile_prefix = false;
            this.startCursor = this.cursor;
        }

        private boolean startsHandler(int offset, boolean hasException) {
            List handlers = (List)Translator.this.exceptions.get(offset);
            if (handlers != null) {
                for (CLRMethod.ExceptionEntry handler : handlers) {
                    if (handler.handlerKind.hasExceptionValue() != hasException || handler.handlerStart != offset) continue;
                    return true;
                }
            }
            return false;
        }

        private void translateBytecode() {
            this.startCursor = this.cursor;
            try {
                while (this.cursor < this.end) {
                    if (this.startsHandler(this.cursor, true)) {
                        Translator.this.stack = new Stack();
                        Translator.this.stack.push(RuntimeType.O);
                    } else if (this.startsHandler(this.cursor, false)) {
                        Translator.this.stack = new Stack();
                    } else if (Translator.this.stack == null) {
                        if (this.branchStacks.containsKey(this.cursor)) {
                            Translator.this.stack = this.branchStacks.get(this.cursor);
                        } else {
                            Translator.this.stack = new Stack();
                        }
                    }
                    if (Translator.this.bytecode[this.cursor] == -2) {
                        ++this.cursor;
                        Bytecode.instPrefixes[Translator.this.bytecode[this.cursor++]].visit(this.prefixTranslator);
                        continue;
                    }
                    Bytecode.insts[Translator.this.bytecode[this.cursor++] + 128].visit(this.instTranslator);
                    this.clearPrefixes();
                }
            }
            catch (TranslatorError e) {
                StringBuffer sb = new StringBuffer("in " + Translator.this.method.getName() + " of " + Translator.this.method.getDeclaringClass() + "\ninstructions:\n");
                for (IInstruction inst : Translator.this.instructions) {
                    sb.append(inst).append("\n");
                }
                throw new TranslatorError(sb.toString(), e);
            }
        }

        private void addInstruction(IInstruction instr) {
            CILLoadInstruction ld;
            Translator.this.instructions.add(instr);
            this.pcMap.addInstruction(this.startCursor, Translator.this.instructions.size() - 1);
            if (instr instanceof CILLoadInstruction && (ld = (CILLoadInstruction)instr).isAddressOf()) {
                if (ld.isArgument()) {
                    Translator.this.addressTakenArguments.add(ld.getVarIndex());
                } else {
                    Translator.this.addressTakenLocals.add(ld.getVarIndex());
                }
            }
        }
    }

    public static enum RuntimeType {
        int32{

            @Override
            RuntimeType binary(Bytecode.Opcode op, RuntimeType rhs) {
                switch (rhs) {
                    case int32: {
                        return int32;
                    }
                    case nativeInt: {
                        return nativeInt;
                    }
                    case ref: {
                        if (op != Bytecode.Opcode.op_add) break;
                        return ref;
                    }
                }
                throw new TypeError(this, rhs, op);
            }

            @Override
            RuntimeType integer(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return rhs;
                }
                throw new TypeError(this, rhs, op);
            }

            @Override
            RuntimeType overflow(Bytecode.Opcode op, RuntimeType rhs) {
                return this.binary(op, rhs);
            }

            @Override
            RuntimeType shift(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return int32;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32) {
                    return int32;
                }
                if (rhs == nativeInt) {
                    return nativeInt;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType unary(Bytecode.Opcode op) {
                return int32;
            }
        }
        ,
        int64{

            @Override
            RuntimeType binary(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int64) {
                    return int64;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType integer(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int64) {
                    return int64;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType overflow(Bytecode.Opcode op, RuntimeType rhs) {
                return this.binary(op, rhs);
            }

            @Override
            RuntimeType shift(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return int64;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int64) {
                    return int64;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType unary(Bytecode.Opcode op) {
                return int64;
            }

            @Override
            byte size() {
                return 2;
            }
        }
        ,
        nativeInt{

            @Override
            RuntimeType binary(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return nativeInt;
                }
                if (rhs == ref && op == Bytecode.Opcode.op_add) {
                    return ref;
                }
                throw new TypeError(this, rhs, op);
            }

            @Override
            RuntimeType integer(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return nativeInt;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType overflow(Bytecode.Opcode op, RuntimeType rhs) {
                return this.binary(op, rhs);
            }

            @Override
            RuntimeType shift(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return nativeInt;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == int32 || rhs == nativeInt) {
                    return nativeInt;
                }
                if (rhs == ref && (op == Bytecode.Opcode.op_beq || op == Bytecode.Opcode.op_bne)) {
                    return ref;
                }
                throw new TypeError(this, rhs, op);
            }

            @Override
            RuntimeType unary(Bytecode.Opcode op) {
                return nativeInt;
            }
        }
        ,
        F{

            @Override
            RuntimeType binary(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == F) {
                    return F;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == F) {
                    return F;
                }
                throw new TypeError((RuntimeType)this, rhs);
            }

            @Override
            RuntimeType unary(Bytecode.Opcode op) {
                return F;
            }
        }
        ,
        ref{

            @Override
            RuntimeType binary(Bytecode.Opcode op, RuntimeType rhs) {
                if (!(rhs != int32 && rhs != nativeInt || op != Bytecode.Opcode.op_add && op != Bytecode.Opcode.op_sub)) {
                    return ref;
                }
                if (rhs == ref && op == Bytecode.Opcode.op_sub) {
                    return ref;
                }
                throw new TypeError(this, rhs, op);
            }

            @Override
            RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == ref) {
                    return ref;
                }
                if (rhs == nativeInt && (op == Bytecode.Opcode.op_beq || op == Bytecode.Opcode.op_bne)) {
                    return ref;
                }
                throw new TypeError(this, rhs, op);
            }

            @Override
            RuntimeType overflow(Bytecode.Opcode op, RuntimeType rhs) {
                return this.binary(op, rhs);
            }
        }
        ,
        O{

            @Override
            RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
                if (rhs == O && (op == Bytecode.Opcode.op_beq || op == Bytecode.Opcode.op_bne)) {
                    return O;
                }
                throw new TypeError(this, rhs, op);
            }
        }
        ,
        Void;


        byte size() {
            return 1;
        }

        RuntimeType binary(Bytecode.Opcode op, RuntimeType rhs) {
            throw new TypeError(this, rhs);
        }

        RuntimeType unary(Bytecode.Opcode op) {
            throw new TypeError(this);
        }

        RuntimeType integer(Bytecode.Opcode op, RuntimeType rhs) {
            throw new TypeError(this, rhs);
        }

        RuntimeType shift(Bytecode.Opcode op, RuntimeType rhs) {
            throw new TypeError(this, rhs);
        }

        RuntimeType overflow(Bytecode.Opcode op, RuntimeType rhs) {
            throw new TypeError(this, rhs);
        }

        RuntimeType branch(Bytecode.Opcode op, RuntimeType rhs) {
            throw new TypeError(this, rhs);
        }
    }

    private static class TypeError
    extends TranslatorError {
        private static final long serialVersionUID = 6099313046786125911L;

        private TypeError(RuntimeType lhs, RuntimeType rhs) {
            super("cannot combine " + (Object)((Object)lhs) + ", " + (Object)((Object)rhs));
        }

        private TypeError(RuntimeType lhs, RuntimeType rhs, Bytecode.Opcode op) {
            super("cannot combine " + (Object)((Object)lhs) + ", " + (Object)((Object)rhs) + " for " + (Object)((Object)op));
        }

        private TypeError(RuntimeType type) {
            super("invalid type " + (Object)((Object)type));
        }
    }

    private static class TranslatorError
    extends RuntimeException {
        private static final long serialVersionUID = -2684681908076094575L;

        private TranslatorError(String msg) {
            super(msg);
        }

        private TranslatorError(String msg, Exception e) {
            super(msg, e);
        }
    }

    public class InstructionMap
    implements Comparable<InstructionMap> {
        private final int start;
        private int end;
        private final InstructionMap parent;
        private final Map<Integer, Integer> pcMap = new TreeMap<Integer, Integer>();
        private final Map<Integer, Integer> bcMap = new TreeMap<Integer, Integer>();

        private InstructionMap(InstructionMap parent, int start) {
            this.parent = parent;
            this.start = start;
            this.end = start - 1;
        }

        private int getStart() {
            int i = this.start;
            do {
                if (!this.pcMap.containsKey(i)) continue;
                return i;
            } while (++i <= this.end);
            return -1;
        }

        private void addInstruction(int cursor, int instIndex) {
            this.pcMap.put(instIndex, cursor);
            this.bcMap.put(cursor, instIndex);
            if (instIndex > this.end) {
                this.end = instIndex;
            }
        }

        private int depth() {
            if (this.parent == null) {
                return 0;
            }
            return 1 + this.parent.depth();
        }

        @Override
        public int compareTo(InstructionMap arg0) {
            int diff = this.start - arg0.start;
            if (diff != 0) {
                return diff;
            }
            return arg0.depth() - this.depth();
        }

        private int mapInstIndex(int instIndex) {
            assert (this.pcMap.containsKey(instIndex));
            return this.pcMap.get(instIndex);
        }

        private int mapBytecodeIndex(int bytecodeIndex) {
            if (this.bcMap.containsKey(bytecodeIndex)) {
                return this.bcMap.get(bytecodeIndex);
            }
            return this.parent.mapBytecodeIndex(bytecodeIndex);
        }

        private int[] targetMap() {
            int[] targetMap = new int[Translator.this.bytecode.length + 1];
            for (int i = 0; i < targetMap.length; ++i) {
                targetMap[i] = -1;
            }
            InstructionMap ptr = this;
            while (ptr != null) {
                for (Integer instIndex : ptr.pcMap.keySet()) {
                    if (targetMap[ptr.pcMap.get(instIndex)] != -1) continue;
                    targetMap[ptr.pcMap.get((Object)instIndex).intValue()] = instIndex;
                }
                ptr = ptr.parent;
            }
            return targetMap;
        }
    }

    public static class BCInfo<C, F, M, A, T> {
        private final int[] pcMap;
        private final IInstruction[] instructions;
        private final int[] addressTakenLocals;
        private final ExceptionHandler[][] handlers;

        private static <C, F, M, A, T> ExceptionHandler[][] computeInstructionHandlers(IInstruction[] instrs, List<CLRMethod.ExceptionEntry> exceptions) {
            ExceptionHandler[][] result = new ExceptionHandler[instrs.length][];
            for (int index = 0; index < instrs.length; ++index) {
                LinkedList<ExceptionHandler> handlers = new LinkedList<ExceptionHandler>();
                for (CLRMethod.ExceptionEntry e : exceptions) {
                    int tryStart = e.tryStart;
                    int tryEnd = e.tryEnd;
                    if (tryStart > index || index > tryEnd) continue;
                    handlers.add(new ExceptionHandler(e.getHandlerLabel(), e.catchType == null ? null : e.catchType.getName().toString()));
                }
                result[index] = new ExceptionHandler[handlers.size()];
                int i = 0;
                for (ExceptionHandler h : handlers) {
                    result[index][i++] = h;
                }
            }
            return result;
        }

        private BCInfo(IInstruction[] instructions, int[] pcMap, ExceptionHandler[][] exceptions, int[] addressTakenLocals) {
            this.instructions = instructions;
            this.pcMap = pcMap;
            this.handlers = exceptions;
            this.addressTakenLocals = addressTakenLocals;
        }

        private BCInfo(IInstruction[] instructions, int[] pcMap, List<CLRMethod.ExceptionEntry> exceptions, int[] addressTakenLocals) {
            this(instructions, pcMap, BCInfo.computeInstructionHandlers(instructions, exceptions), addressTakenLocals);
        }

        private IntSet computeTargetInstructions() {
            MutableIntSet targets = IntSetUtil.make();
            for (IInstruction iInstruction : this.instructions) {
                int[] gotos = iInstruction.getBranchTargets();
                if (gotos == null) continue;
                int[] nArray = gotos;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int g = nArray[i];
                    targets.add(g);
                }
            }
            for (IInstruction iInstruction : this.handlers) {
                if (iInstruction == null) continue;
                for (IInstruction instHandler : iInstruction) {
                    targets.add(instHandler.getHandler());
                }
            }
            return targets;
        }

        private IntSet computeDeadInstructions() {
            IntSet allTargets = this.computeTargetInstructions();
            MutableIntSet deadInstructions = IntSetUtil.make();
            for (int i = 1; i < this.instructions.length; ++i) {
                if (allTargets.contains(i) || this.instructions[i - 1].isFallThrough() && !deadInstructions.contains(i - 1)) continue;
                deadInstructions.add(i);
            }
            return deadInstructions;
        }

        private BCInfo<C, F, M, A, T> pruneDeadInstructions() {
            IntSet deadInstructions = this.computeDeadInstructions();
            if (deadInstructions.isEmpty()) {
                return null;
            }
            int[] instMap = new int[this.instructions.length];
            int j = 0;
            for (int i = 0; i < this.instructions.length; ++i) {
                instMap[i] = !deadInstructions.contains(i) ? j++ : -1;
            }
            IInstruction[] newInstructions = new IInstruction[this.instructions.length - deadInstructions.size()];
            int[] newPcMap = new int[this.instructions.length - deadInstructions.size()];
            int j2 = 0;
            for (int i = 0; i < this.instructions.length; ++i) {
                if (deadInstructions.contains(i)) continue;
                newPcMap[j2] = this.pcMap[i];
                newInstructions[j2++] = this.instructions[i].redirectTargets(instMap);
            }
            ExceptionHandler[][] newHandlers = new ExceptionHandler[newInstructions.length][];
            int ni = 0;
            for (int i = 0; i < this.handlers.length; ++i) {
                if (deadInstructions.contains(i)) continue;
                if (this.handlers[i] != null) {
                    newHandlers[ni] = new ExceptionHandler[this.handlers[i].length];
                    for (int j3 = 0; j3 < this.handlers[i].length; ++j3) {
                        newHandlers[ni][j3] = new ExceptionHandler(instMap[this.handlers[i][j3].getHandler()], this.handlers[i][j3].getCatchClass());
                    }
                }
                ++ni;
            }
            return new BCInfo<C, F, M, A, T>(newInstructions, newPcMap, newHandlers, this.addressTakenLocals);
        }

        private static <C, F, M, A, T> BCInfo<C, F, M, A, T> make(IInstruction[] instructions, int[] pcMap, List<CLRMethod.ExceptionEntry> exceptions, int[] addressTakenLocals) {
            BCInfo<C, F, M, A, T> newInfo;
            BCInfo<C, F, M, A, T> info = new BCInfo<C, F, M, A, T>(instructions, pcMap, exceptions, addressTakenLocals);
            while ((newInfo = super.pruneDeadInstructions()) != null) {
                info = newInfo;
            }
            return info;
        }

        public ExceptionHandler[][] getHandlers() {
            return this.handlers;
        }

        public int[] getAddressTakenLocals() {
            return this.addressTakenLocals;
        }

        public IInstruction[] getInstructions() {
            return this.instructions;
        }

        public int getProgramCounter(int instructionIndex) {
            return this.pcMap[instructionIndex];
        }
    }
}

