/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.m2lstr;

import com.ibm.wala.automaton.regex.string.AbstractPatternCompiler;
import com.ibm.wala.automaton.regex.string.ComplementPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IntersectionPattern;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableBindingPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.M2LSymbol;
import com.ibm.wala.samso.translator.IDeclarationSet;
import java.util.Arrays;

public class RegexpToM2L
extends AbstractPatternCompiler<IDeclarationSet> {
    private final IExtendedFormulaFactory ffactory;

    public RegexpToM2L(IExtendedFormulaFactory ffactory) {
        this.ffactory = ffactory;
    }

    public IDeclarationSet onComplement(ComplementPattern pattern) {
        IDeclarationSet declSet = (IDeclarationSet)this.compile(pattern.getPattern());
        return DeclarationSets.createComplement(declSet, this.ffactory);
    }

    public IDeclarationSet onConcatenation(ConcatenationPattern pattern) {
        IDeclarationSet declSet1 = (IDeclarationSet)this.compile(pattern.getHead());
        IDeclarationSet declSet2 = (IDeclarationSet)this.compile(pattern.getTail());
        return DeclarationSets.createConcatenation(Arrays.asList(declSet1, declSet2), this.ffactory);
    }

    public IDeclarationSet onEmpty(EmptyPattern pattern) {
        return DeclarationSets.createEmpty(this.ffactory);
    }

    public IDeclarationSet onIntersection(IntersectionPattern pattern) {
        IDeclarationSet declSet1 = (IDeclarationSet)this.compile(pattern.getLeft());
        IDeclarationSet declSet2 = (IDeclarationSet)this.compile(pattern.getRight());
        return DeclarationSets.createIntersection(Arrays.asList(declSet1, declSet2), this.ffactory);
    }

    public IDeclarationSet onIteration(IterationPattern pattern) {
        IDeclarationSet declSet1 = (IDeclarationSet)this.compile(pattern.getPattern());
        return DeclarationSets.createIteration(declSet1, this.ffactory);
    }

    public IDeclarationSet onSymbol(SymbolPattern pattern) {
        ISymbol sym = pattern.getSymbol();
        if (sym instanceof StringSymbol) {
            StringSymbol ssym = (StringSymbol)sym;
            String s = ssym.getName();
            return DeclarationSets.createDeclarationSet(s, this.ffactory);
        }
        if (sym instanceof CharSymbol) {
            CharSymbol csym = (CharSymbol)sym;
            String s = Character.toString(csym.charValue());
            return DeclarationSets.createDeclarationSet(s, this.ffactory);
        }
        if (sym instanceof RangeSymbol) {
            RangeSymbol rsym = (RangeSymbol)sym;
            CharSymbol min = (CharSymbol)rsym.getMin();
            CharSymbol max = (CharSymbol)rsym.getMax();
            IPositionSetVariable R = this.ffactory.createPositionSetVariable();
            IFormula body = this.ffactory.createCharset(R, min.charValue(), max.charValue());
            return DeclarationSets.createDeclarationSet(R, body, this.ffactory);
        }
        if (sym instanceof IntSymbol) {
            IntSymbol isym = (IntSymbol)sym;
            String s = Character.toString(isym.charValue());
            return DeclarationSets.createDeclarationSet(s, this.ffactory);
        }
        if (sym instanceof M2LSymbol) {
            M2LSymbol msym = (M2LSymbol)sym;
            return msym.getLanguage();
        }
        return DeclarationSets.createAny(this.ffactory);
    }

    public IDeclarationSet onUnion(UnionPattern pattern) {
        IDeclarationSet declSet1 = (IDeclarationSet)this.compile(pattern.getLeft());
        IDeclarationSet declSet2 = (IDeclarationSet)this.compile(pattern.getRight());
        return DeclarationSets.createUnion(Arrays.asList(declSet1, declSet2), this.ffactory);
    }

    public IDeclarationSet onVariableBinding(VariableBindingPattern pattern) {
        return (IDeclarationSet)this.compile(pattern.getPattern());
    }

    public IDeclarationSet onVariableReference(VariableReferencePattern pattern) {
        return DeclarationSets.createAny(this.ffactory);
    }
}

